<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" encoding="utf-8" indent="yes"/>
	<xsl:include href="main.xsl"/>
	<xsl:include href="ap-service-status.xsl"/>
	<xsl:include href="wakeup-statistic.xsl"/>
	<xsl:include href="label-event.xsl"/>
	<xsl:include href="join-request.xsl"/>
	<xsl:include href="update-task.xsl"/>
	<xsl:include href="storage.xsl"/>
	<xsl:include href="utilization.xsl"/>
	<xsl:include href="default.xsl"/>

	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<title>imagotag Access Point</title>
				<link rel="stylesheet" type="text/css" media="screen, print" href="/default.css"/>
				<link rel="icon" href="/images/imagotag_32_white_on_green.png" type="image/png"/>
				<script type="text/javascript" src="/rewrite.js"></script>
			</head>
			<body onload="rewrite();">
				<div id="navigation">
					<h2>Labels</h2>
					<ul>
						<li><a href="/service/labels/assigned.xml">Assigned</a></li>
						<li><a href="/service/labels/online.xml">Online</a></li>
						<li><a href="/service/labels/offline.xml">Offline</a></li>
						<li><a href="/service/labels/registered.xml">Registered</a></li>
						<li><a href="/service/labels/discovered.xml">Discovered</a></li>
					</ul>
					
					<h2>Tasks</h2>
					<ul>
						<li><a href="/service/tasks/all.xml">Task Queue</a></li>
						<li><a href="/service/labels/events.xml">Events</a></li>
					</ul>

					<h2>Maintenance</h2>
					<ul>
						<li><a href="/service/status.xml">Status</a></li>
						<li><a href="/service/utilization.xml">Utilization</a></li>
						<li><a href="/admin.xml">Administration</a></li>
					</ul>

				</div>

				<div id="content">
					<xsl:apply-templates/>
				</div>

				<div id="footer">
					© SES-imagotag GmbH
				</div>
			</body>
		</html>
	</xsl:template>
	
	
	<!-- Label details -->
	<xsl:template match="label-details">
		<h1>Label Details</h1>
		<xsl:apply-templates/>
	</xsl:template>

</xsl:stylesheet>
