<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- List of Operational metrics -->
	<xsl:template match="operation-metrics">
		<h1>Operation metrics</h1>

		<xsl:if test="info-packet">
			<h2>
				Info packet
			</h2>
			<table>
				<tr>
					<th>
						Message-type
					</th>
					<td>
						<xsl:value-of select="./info-packet/message-type" />
					</td>
				</tr>
			</table>
			
			<xsl:for-each select="./info-packet/infos/info">
				<h2><xsl:value-of select="./@category"/></h2>
				<table>
					<xsl:for-each select="./info-entry">
						<tr>
							<th><xsl:value-of select="./@key"/></th>
							
							<xsl:for-each select="./info-entry-value">
								<td><xsl:value-of select="./@value"/></td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:for-each>
		</xsl:if>

		<br />

		<xsl:if test="extended-info-packet">
			<h2>
				Extended info packet
			</h2>
			<table>
				<tr>
					<th>
						Message-type
					</th>
					<td>
						<xsl:value-of select="./extended-info-packet/message-type" />
					</td>
				</tr>
			</table>

			<xsl:for-each select="./extended-info-packet/infos/info">
				<h2><xsl:value-of select="./@category"/></h2>
				<table>
					<xsl:if test="count(./header-info/header) &gt; 1">
						<tr>
							<th></th>
							<xsl:for-each select="./header-info/header">
								<th><xsl:value-of select="./@value"/></th>
							</xsl:for-each>
						</tr>
					</xsl:if>
					
					<xsl:for-each select="./info-entry">
						<tr>
							<th><xsl:value-of select="./@key"/></th>
							
							<xsl:for-each select="./info-entry-value">
								<td><xsl:value-of select="./@value"/></td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
