<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Label Events -->
<xsl:template match="events">
	<h1>Events (<xsl:value-of select="count(event)"/>)</h1>

	<table class="list">
		<tr>
			<th>Label ID</th>
			<th>Event ID</th>
			<th>Time</th>
			<th>Type</th>
			<th>Data</th>
		</tr>

		<xsl:for-each select="event">
			<xsl:sort select="./@time"/>
			
			<tr>
				<td class="serial">
					<a>
						<xsl:attribute name="href"><xsl:value-of select="./@address"/>.xml</xsl:attribute>
						<xsl:value-of select="./@address"/>
					</a>
				</td>
				<td class="taskId"><xsl:value-of select="./@id"/></td>
				<td><xsl:value-of select="./@time"/></td>
				<td><xsl:value-of select="./@type"/></td>
				<td><xsl:value-of select="./@data"/></td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>

</xsl:stylesheet>
