<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Join Requests -->
<xsl:template match="join-requests">
	<xsl:choose>
		<xsl:when test="count">
			<h1>Discovered Labels (<xsl:value-of select="count"/>)</h1>
		</xsl:when>
		<xsl:otherwise>
			<h1>Discovered Labels (<xsl:value-of select="count(join-request)"/>)</h1>

			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Time</th>
					<th>Status</th>
				</tr>
		
				<xsl:for-each select="join-request">
					<xsl:sort select="./@time"/>
					
					<tr>
						<td class="serial">
							<a>
								<xsl:attribute name="href"><xsl:value-of select="./@address"/>.xml</xsl:attribute>
								<xsl:value-of select="./@address"/>
							</a>
						</td>
						<td><xsl:value-of select="./@time"/></td>
						<td>
							<xsl:attribute name="class"><xsl:value-of select="./@status"/></xsl:attribute>
							<xsl:value-of select="./@status"/>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>


<!-- Single Join Request (details view) -->
<xsl:template match="join-request">
	<h2>Join Status of Label <xsl:value-of select="./@address"/></h2>

	<table class="detail">
		<tr>
			<th>Label ID:</th>
			<td class="serial"><xsl:value-of select="./@address"/></td>
		</tr>
		<tr>
			<th>Join status update:</th>
			<td><xsl:value-of select="./@time"/></td>
		</tr>
		<tr>
			<th>Join status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="./@status"/></xsl:attribute>
				<xsl:value-of select="./@status"/>
			</td>
		</tr>
	</table>
</xsl:template>

</xsl:stylesheet>
