﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- How to display the service status -->
<xsl:template match="service-status">
	<xsl:variable name ="devicetype" select ="property[@key='device-type']" />
	<h1><xsl:value-of select="./@name"/> Status</h1>
	
	<h2>Device Status</h2>

	<table class="detail">
		<tr>
			<th>AP ID:</th>
			<td><xsl:value-of select="property[@key='id']"/></td>
		</tr>
		
		<xsl:if test="property[@key='device-model'] != ''">
			<tr>
				<th>Device Model:</th>
				<td><xsl:value-of select="property[@key='device-model']"/></td>
			</tr>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="contains($devicetype, 'LANCOM')">
				<tr>
					<th>Transmitter:</th>
					<td><xsl:value-of select="property[@key='transmitter-name']"/></td>
				</tr>
				<tr>
					<th>Serial Number:</th>
					<td><xsl:value-of select="property[@key='transmitter-serial']"/></td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<th>Transmitter:</th>
					<td><xsl:value-of select="property[@key='device-type']"/></td>
				</tr>
				<tr>
					<th>Serial Number:</th>
					<td><xsl:value-of select="property[@key='serial']"/></td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
		
		
		<tr>
			<th>Software Version:</th>
			<td><xsl:value-of select="property[@key='version']"/></td>
		</tr>
		<tr>
			<th>Firmware Version:</th>
			<td><xsl:value-of select="property[@key='firmware-version']"/> (<xsl:value-of select="property[@key='extended-version']"/>)</td>
		</tr>
		<tr>
			<th>Hardware Revision:</th>
			<td><xsl:value-of select="property[@key='hardware-version']"/></td>
		</tr>
		<tr>
			<th>Build:</th>
			<td><xsl:value-of select="property[@key='build']"/></td>
		</tr>
		<tr>
			<th>FCC/IC compliant mode:</th>
			<td><xsl:value-of select="property[@key='compliant-mode']"/></td>
		</tr>
		<tr>
			<th>Configuration mode:</th>
			<td><xsl:value-of select="property[@key='configuration-type']"/></td>
		</tr>
	</table>
	
	<h2>Service Status</h2>
	
	<table class="detail">
		<tr>
			<th>Status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="property[@key='status']"/></xsl:attribute>
				<xsl:value-of select="property[@key='status']"/>
			</td>
		</tr>
		<xsl:if test="property[@key='comm-daemon-status']" >
			<tr>
				<th>Mode:</th>
				<td>
					<xsl:choose>
						<xsl:when test="property[@key='thinap-mode'] = 'true'">THIN</xsl:when>
						<xsl:otherwise>THICK</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<th>Uptime:</th>
			<td><xsl:value-of select="property[@key='service-uptime']"/></td>
		</tr>
		<tr>
			<th>Time:</th>
			<td><xsl:value-of select="property[@key='time']"/></td>
		</tr>
		<xsl:choose>
			<xsl:when test="property[@key='thinap-mode'] = 'false'">
				<tr>
					<th>Labels:</th>
					<td><xsl:value-of select="property[@key='labels']"/></td>
				</tr>
				<tr>
					<th>Waiting Tasks:</th>
					<td><xsl:value-of select="property[@key='waiting-tasks']"/></td>
				</tr>
				<tr>
					<th>Total Tasks:</th>
					<td><xsl:value-of select="property[@key='tasks']"/></td>
				</tr>
				<tr>
					<th>Total Tasks Size:</th>
					<td><xsl:value-of select="property[@key='task-size-readable']"/></td>
				</tr>
				<tr>
					<th>Total UART Errors:</th>
					<td><xsl:value-of select="property[@key='uart-errors']"/></td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<th>Core Service Host:</th>
					<td><xsl:value-of select="property[@key='server-hostname']"/> [<xsl:value-of select="property[@key='server-address']"/>]</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
	</table>
	
	<xsl:if test="property[@key='comm-daemon-status']" >
		<h2>Communication-Daemon Status</h2>
		<table class="detail">
			<tr>
				<th>Status:</th>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="property[@key='comm-daemon-status']"/></xsl:attribute>
					<xsl:value-of select="property[@key='comm-daemon-status']"/>
				</td>
			</tr>
			<tr>
				<th>Connection-Mode:</th>
				<td>
					<xsl:choose>
						<xsl:when test="property[@key='outbound-mode'] = 'true'">OUTBOUND</xsl:when>
						<xsl:otherwise>INBOUND</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<th>Version:</th>
				<td>
					<xsl:value-of select="property[@key='comm-daemon-version']"/>
				</td>
			</tr>
			<xsl:if test="property[@key='comm-daemon-remote-endpoint']" >
				<tr>
					<th>Task Provider:</th>
					<td>
						<xsl:value-of select="property[@key='comm-daemon-remote-endpoint']"/>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:if>
	
	<h2>Network Status</h2>
	
	<table class="detail">
		<tr>
			<th>Hostname:</th>
			<td><xsl:value-of select="property[@key='hostname']"/></td>
		</tr>
		<tr>
			<th>IP Address:</th>
			<td><xsl:value-of select="property[@key='ip-address']"/></td>
		</tr>
		<tr>
			<th>MAC Address:</th>
			<td><xsl:value-of select="property[@key='mac-address']"/></td>
		</tr>
		<tr>
			<th>Wireless Channel:</th>
			<td><xsl:value-of select="property[@key='channel']"/></td>
		</tr>
	</table>
	
	
	<h2>Ressources</h2>
	
	<table class="detail">
		<tr>
			<th>JVM Total Memory:</th>
			<td><xsl:value-of select="property[@key='total-memory']"/></td>
		</tr>
		<tr>
			<th>JVM Free Memory:</th>
			<td><xsl:value-of select="property[@key='free-memory']"/></td>
		</tr>
		<tr>
			<th>JVM Max Memory:</th>
			<td><xsl:value-of select="property[@key='max-memory']"/></td>
		</tr>
		<tr>
			<th>Threads:</th>
			<td><xsl:value-of select="property[@key='threads']"/></td>
		</tr>
	</table>
	
	<xsl:if test="property[@key='roaming-table-valid']='true' and property[@key='thinap-mode'] = 'false'">
		<h2>Roaming Status</h2>
		
		<table class="detail">
			<tr>
				<th>Core Service Host:</th>
				<td><xsl:value-of select="property[@key='server-hostname']"/> [<xsl:value-of select="property[@key='server-address']"/>]</td>
			</tr>
			<tr>
				<th>Last Update:</th>
				<td><xsl:value-of select="property[@key='roaming-table-time']"/></td>
			</tr>
			<tr>
				<th>Valid Time:</th>
				<td><xsl:value-of select="property[@key='roaming-valid-time']"/> minutes</td>
			</tr>
			<tr>
				<th>Registered Labels:</th>
				<td><xsl:value-of select="property[@key='registered-labels']"/></td>
			</tr>
			<tr>
				<th>Ping Interval:</th>
				<td><xsl:value-of select="property[@key='ping-interval']"/> minutes</td>
			</tr>
			<tr>
				<th>Used Channels:</th>
				<td><xsl:value-of select="property[@key='used-channels']"/></td>
			</tr>
		</table>
	</xsl:if>
	
	<xsl:if test="count(problem) &gt; 0">
		<h2>Problems</h2>
	
		<table>
			<tr>
				<th>Severity</th>
				<th>Message</th>
			</tr>
			
			<xsl:for-each select="problem">
				<tr>
					<td>
						<xsl:attribute name="class"><xsl:value-of select="./@severity"/> centered</xsl:attribute>
						<xsl:value-of select="./@severity"/>
					</td>
					<td>
						<xsl:value-of select="./@message"/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
