<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<title>imagotag Access Point Administration</title>
				<link rel="stylesheet" type="text/css" media="screen, print" href="/default.css"/>
				<link rel="icon" href="/images/imagotag_32_white_on_green.png" type="image/png"/>
				<script type="text/javascript" src="/rewrite.js"></script>
			</head>
			<body onload="rewrite()">
				<div id="navigation">

					<h2>System Settings</h2>
					<ul>
						<li><a href="/service/config/autoConfig.xml">Configuration Mode</a></li>
						<li><a href="/service/config/wireless.xml">Wireless Channel</a></li>
						<li><a href="/service/config/outputPower.xml">Output Power</a></li>
						<li><a href="/service/config/communicationDaemon.xml">Communication Daemon</a></li>
						<li><a href="/service/config/network.xml">Network</a></li>
						<li><a href="/service/config/datetime.xml">Date/Time</a></li>
						<li><a href="/service/config/msp.xml">MSP Integration</a></li>
						<li><a href="/service/config/broadcast.xml">Discovery Broadcast</a></li>
						<li><a href="/service/config/logging.xml">Logging</a></li>
						<li><a href="/service/config/ssl.xml">SSL</a></li> 
						<li><a href="/service/config/webservice.xml">Webserver</a></li>  
						<!--<li><a href="/service/serial/serialConfiguration.xml">Serial</a></li>-->
					</ul>
					
					<h2>Web UI Certificate</h2>
					<ul>
						<li><a href="/service/config/certificate/view.xml">Certificate</a></li>
						<!--<li><a href="/service/config/certificate/keypair.xml">Manage Keypair</a></li>-->
						<!--<li><a href="/service/config/certificate/csr.xml">Generate CSR/Certificate</a></li>-->
						<li><a href="/admin/uploadCertificate.xml">Upload Certificate</a></li>
						<li><a href="/service/config/truststore.xml">Truststore</a></li>
					</ul>
					
					<h2>Thin AP Certificate</h2>
					<ul>
						<li><a href="/service/config/certificate/thinap/view.xml">Certificate</a></li>
						<li><a href="/admin/uploadThinApCertificate.xml">Upload Certificate</a></li>
					</ul>
					
					<h2>Management</h2>
					<ul>
						<li><a href="/service/config/password.xml">Change Password</a></li>
						<li><a href="/admin/updateSoftware.xml">Update Software</a></li>
						<li><a href="/admin/updateConfiguration.xml">Update Configuration</a></li>
						<li><a href="/admin/updateFirmware.xml">Update Firmware</a></li>
						<li><a href="/admin/restoreFactoryDefaults.xml">Factory Defaults</a></li>
						<li><a href="/admin/sendBroadcast.xml">Send Discovery</a></li>
						<!-- <li><a href="/identifyDevice.xml">Identify Device</a></li> -->
						<li><a href="/admin/shutdownReboot.xml">Shutdown/Reboot</a></li>
					</ul>
					
					<h2>Status</h2>
					<ul>
						<li><a href="/service/config/configuration.xml">Current Settings</a></li>
						<li><a href="/service/config/system/viewLog.xml">View Logs</a></li>
						<!--<li><a href="/service/serial/result.png">WiSpy Frequency Spectrum</a></li>-->
					</ul>
					
					<div id="back">
						<a href="/">Back</a>
					</div>
				</div>
				
				<div id="content">
					<xsl:apply-templates/>
				</div>
				
				<div id="footer">
					© SES-imagotag GmbH
				</div>
			</body>
		</html>
	</xsl:template>

</xsl:stylesheet>
