﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- Article -->
  
<xsl:template match="ArticleRecordList">
	<h1>Articles</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Article Number</th>
					<th>Name</th>
					<th>Price</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="ArticleRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="ArticleRecord">
	<tr>
		<td>
			<xsl:value-of select="ArticleNumber"/>
		</td>
		<td>
			<xsl:value-of select="Name"/>
		</td>
		<td>
			<xsl:value-of select="Price"/>
		</td>
		<td class="actions">
			<a><xsl:attribute name="href">/service/article/<xsl:value-of select="ArticleNumber"/>.xml</xsl:attribute>Show details</a>,
			<a><xsl:attribute name="href">/service/matching/article/<xsl:value-of select="ArticleNumber"/>.xml</xsl:attribute>Show matchings</a>
		</td>
	</tr>
</xsl:template>


<!-- LabelInfo -->

<xsl:template match="LabelInfoList">
	<h1>Labels</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Version</th>
					<th>Type</th>
					<th>Last seen</th>
					<th>Sync</th>
					<th>Power</th>
					<th>Page</th>
					<th>Error</th>
					<th>RSSI</th>
					<th>LQI</th>
					<th>Encryption</th>
					<th>AP</th>
					<th>Status</th>
					<th>Task Type</th>
					<th>Page</th>
					<th>Task Status</th>
					<th>Updated at</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="LabelInfo"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelInfo">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="FirmwareVersion"/>
		</td>
		<td>
			<xsl:value-of select="Type"/>
		</td>
		<td>
			<xsl:value-of select="WakeupTime"/>
		</td>
		<td>
			<xsl:value-of select="SyncQuality"/>
		</td>
		<td>
			<xsl:value-of select="PowerStatus"/>
		</td>
		<td>
			<xsl:value-of select="CurrentPage"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="LabelErrors != '0'">
					<xsl:attribute name="class">ERROR</xsl:attribute>
					<a>
						<xsl:attribute name="href">/service/description/labelerror/code/<xsl:value-of select="LabelErrors"/>.xml</xsl:attribute>
						<xsl:value-of select="LabelErrors"/>
					</a>
				</xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:value-of select="Rssi"/>
		</td>
		<td>
			<xsl:value-of select="Lqi"/>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="SecurityStatus"/></xsl:attribute>
			<xsl:value-of select="SecurityStatus"/>
		</td>		
		<td>
			<xsl:value-of select="AccessPointId"/>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="ConnectionStatus"/></xsl:attribute>
			<xsl:value-of select="ConnectionStatus"/>
		</td>
		<td>
			<xsl:value-of select="UpdateInfo/TaskType"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="UpdateInfo/Page != ''"><xsl:value-of select="UpdateInfo/Page"/></xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="UpdateInfo/Status"/></xsl:attribute>
			<xsl:value-of select="UpdateInfo/Status"/>
		</td>
		<td>
			<xsl:value-of select="UpdateInfo/UpdatedAt"/>
		</td>
		<td class="actions">
			<a>
				<xsl:attribute name="href">/service/updatestatus/label/<xsl:value-of select="LabelIdString"/>.xml?page=0</xsl:attribute>
				Show log
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template match="LabelInfoEntry">
	<h1>Label <xsl:value-of select="LabelInfo/LabelIdString"/></h1>
	
	<h2>Label Details</h2>
	
	<table class="detail">
		<tr>
			<th>Label ID:</th>
			<td><span class="serial"><xsl:value-of select="LabelInfo/LabelIdString"/></span></td>
		</tr>
		<tr>
			<th>Firmware:</th>
			<td>Version <xsl:value-of select="LabelInfo/FirmwareVersion"/></td>
		</tr>
		<tr>
			<th>Type:</th>
			<td><xsl:value-of select="LabelInfo/Type"/></td>
		</tr>
		<tr>
			<th>Power status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="LabelInfo/PowerStatus"/></xsl:attribute>
				<xsl:value-of select="LabelInfo/PowerStatus"/>
			</td>
		</tr>
		<tr>
			<th>Encryption:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="LabelInfo/SecurityStatus"/></xsl:attribute>
				<xsl:value-of select="LabelInfo/SecurityStatus"/>
			</td>
		</tr>
		<tr>
			<th>Current page:</th>
			<td><xsl:value-of select="LabelInfo/CurrentPage"/></td>
		</tr>
		<tr>
			<th>Error code:</th>
			<td>
				<xsl:choose>
					<xsl:when test="LabelInfo/LabelErrors != '0'">
						<xsl:attribute name="class">ERROR</xsl:attribute>
						<a>
							<xsl:attribute name="href">/service/description/labelerror/code/<xsl:value-of select="LabelInfo/LabelErrors"/>.xml</xsl:attribute>
							<xsl:value-of select="LabelInfo/LabelErrors"/>
						</a>
					</xsl:when>
					<xsl:otherwise>-</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</table>
	
	<h2>Connection Status</h2>
	
	<table class="detail">
		<tr>
			<th>Connection status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="LabelInfo/ConnectionStatus"/></xsl:attribute>
				<xsl:value-of select="LabelInfo/ConnectionStatus"/>
			</td>
		</tr>
		<tr>
			<th>Last seen:</th>
			<td><xsl:value-of select="LabelInfo/WakeupTime"/></td>
		</tr>
		<tr>
			<th>Connected to AP:</th>
			<td>
				<a>
					<xsl:attribute name="href">/service/accesspointinfo/<xsl:value-of select="LabelInfo/AccessPointId"/>.xml</xsl:attribute>
					<xsl:value-of select="LabelInfo/AccessPointId"/>
				</a>
			</td>
		</tr>
		<tr>
			<th>Sync quality:</th>
			<td><xsl:value-of select="LabelInfo/SyncQuality"/></td>
		</tr>
		<tr>
			<th>RSSI:</th>
			<td><xsl:value-of select="LabelInfo/Rssi"/> dBm</td>
		</tr>
		<tr>
			<th>LQI:</th>
			<td><xsl:value-of select="LabelInfo/Lqi"/></td>
		</tr>
	</table>
	
	<xsl:if test="LabelInfo/UpdateInfo/TaskId != ''">
		<h2>Last Update Status</h2>
		
		<table class="detail">
			<tr>
				<th>Task ID:</th>
				<td>
					<a class="taskId">
						<xsl:attribute name="href">/service/updatestatus/task/<xsl:value-of select="LabelInfo/UpdateInfo/TaskId"/>.xml</xsl:attribute>
						<xsl:value-of select="LabelInfo/UpdateInfo/TaskId"/>
					</a>
				</td>
			</tr>
			<tr>
				<th>Task type:</th>
				<td><xsl:value-of select="LabelInfo/UpdateInfo/TaskType"/></td>
			</tr>
			<tr>
				<th>Page</th>
				<td>
					<xsl:choose>
						<xsl:when test="LabelInfo/UpdateInfo/Page != ''"><xsl:value-of select="LabelInfo/UpdateInfo/Page"/></xsl:when>
						<xsl:otherwise>-</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<th>Status:</th>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="LabelInfo/UpdateInfo/Status"/></xsl:attribute>
					<xsl:value-of select="LabelInfo/UpdateInfo/Status"/>
				</td>
			</tr>
			<xsl:if test="LabelInfo/UpdateInfo/ErrorCode != ''">
				<tr>
					<th>Error code:</th>
					<td>
						<a>
							<xsl:attribute name="href">/service/description/updateerror/code/<xsl:value-of select="LabelInfo/UpdateInfo/ErrorCode"/>.xml</xsl:attribute>
							<xsl:value-of select="LabelInfo/UpdateInfo/ErrorCode"/>
						</a>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<th>Updated at:</th>
				<td><xsl:value-of select="LabelInfo/UpdateInfo/UpdatedAt"/></td>
			</tr>
		</table>
	</xsl:if>
	
	<h2>Actions</h2>
	
	<ul>
		<li>
			<a>
				<xsl:attribute name="href">/service/status/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml</xsl:attribute>
				Show current update status
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/updatestatus/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml?page=0</xsl:attribute>
				Show update log
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/matching/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml</xsl:attribute>
				Show matching
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/labeldetail/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml</xsl:attribute>
				Show label data
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/labelpagecontent/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml</xsl:attribute>
				Show label page content
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/batteryreplacement/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml</xsl:attribute>
				Show battery replacements
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/history/labelinfo/label/<xsl:value-of select="LabelInfo/LabelIdString"/>.xml?page=0</xsl:attribute>
				Show label history
			</a>
		</li>
	</ul>
</xsl:template>


<!-- Matching -->

<xsl:template match="MatchingRecordList">
	<h1>Matchings</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Label ID</th>
					<th>Article Number</th>
					<th>Template</th>
				</tr>

				<xsl:apply-templates select="MatchingRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="MatchingRecord">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="ArticleNumber"/>
		</td>
		<td>
			<xsl:value-of select="Template"/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="MatchingRecordEntry">
	<h1>Matching for <xsl:value-of select="MatchingRecord/LabelIdString"/></h1>
	
	<h2>Matching Details</h2>
	
	<table class="detail">
		<tr>
			<th>Label ID:</th>
			<td><span class="serial"><xsl:value-of select="MatchingRecord/LabelIdString"/></span></td>
		</tr>
		<tr>
			<th>Article number:</th>
			<td><xsl:value-of select="MatchingRecord/ArticleNumber"/></td>
		</tr>
		<tr>
			<th>Template:</th>
			<td><xsl:value-of select="MatchingRecord/Template"/></td>
		</tr>
		<tr>
			<th>Updated at:</th>
			<td><xsl:value-of select="MatchingRecord/UpdatedAt"/></td>
		</tr>
	</table>
</xsl:template>


<!-- Template -->

<xsl:template match="TemplateList">
	<h1>Templates</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Filename</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="Template"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="Template">
	<tr>
		<td>
			<xsl:value-of select="TemplateFilename"/>
		</td>
		<td class="actions">
			<a><xsl:attribute name="href">/service/matching/template/<xsl:value-of select="Identifier"/>.xml</xsl:attribute>Show matchings,</a>
			<xsl:text> </xsl:text>
			<a><xsl:attribute name="href">/service/template/source/<xsl:value-of select="Identifier"/></xsl:attribute>Show source</a>
		</td>
	</tr>
</xsl:template>

<xsl:template match="FontRecordList">
	<h1>Fonts</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Name</th>
					<th>Family</th>
					<th>Filename</th>
					<th>System Font</th>
				</tr>
				
				<xsl:apply-templates select="FontRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="FontRecord">
	<tr>
		<td>
			<xsl:value-of select="Identifier"/>
		</td>
		<td>
			<xsl:value-of select="FontFamily"/>
		</td>
		<td>
			<xsl:value-of select="FontFilename"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="FontFilename = ''">
					Yes
				</xsl:when>
				<xsl:otherwise>
					No
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</tr>
</xsl:template>


<!-- Access Point Update Packages -->

<xsl:template match="AccessPointUpdatePackageRecordList">
	<h1>Access Point Update Packages</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Name</th>
					<th>Version</th>
					<th>Required Version</th>
					<th>Size</th>
					<th>Type</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="AccessPointUpdatePackageRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="AccessPointUpdatePackageRecord">
	<tr>
		<td>
			<xsl:value-of select="Identifier"/>
		</td>
		<td>
			<xsl:value-of select="UpdateVersion"/>
		</td>
		<td style="text-align: center;">
			<xsl:value-of select="RequiredVersion"/>
		</td>
		<td>
			<xsl:value-of select="format-number(number(Size) div 1024 div 1024, '###,###.00;(###,###.00)')"/> MB
		</td>		
		<td>
			<xsl:choose>
				<xsl:when test="AccessPointType">
					<xsl:value-of select="AccessPointType"/>
				</xsl:when>
				<xsl:otherwise>Unknown</xsl:otherwise>
			</xsl:choose> 
		</td>
		<td class="actions">
			<a><xsl:attribute name="href">/service/updatepackage/download/<xsl:value-of select="Identifier"/></xsl:attribute>Download</a>
		</td>
	</tr>
</xsl:template>

<!-- Access Point Updates -->

<xsl:template match="AccessPointUpdateRecordList ">
	<h1>Access Point Updates</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>AP ID</th>
					<th>AP Version</th>
					<th>Update Type</th>
					<th>Status</th>
					<th>Error Code</th>
					<th>Retries Left</th>
					<th>Updated At</th>
				</tr>
				
				<xsl:apply-templates select="AccessPointUpdateRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="AccessPointUpdateRecord">
	<tr>
		<td>
			<xsl:value-of select="AccessPointId"/>
		</td>
		<td>
			<xsl:value-of select="AccessPointVersion"/>
		</td>
		<td>
			<xsl:value-of select="UpdateType"/>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="Status"/></xsl:attribute>
			<xsl:value-of select="Status"/>
		</td>
		<td>
			<xsl:value-of select="ErrorCode"/>
		</td>
		<td>
			<xsl:value-of select="RetriesLeft"/>
		</td>
		<td>
			<xsl:value-of select="UpdatedAt"/>
		</td>
	</tr>
</xsl:template>

<!-- Force Access Point Updates -->

<xsl:template match="ForceAccessPointSoftwareUpdate ">
	<h1>Access Point Updates</h1>
			<table class="record">
				<tr>
					<th>Name</th>
					<th>Version</th>
					<th>Required Version</th>
					<th>AP Type</th>
					<th>Devices</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="UpdatePackage"/>
			</table>
</xsl:template>

<xsl:template match="UpdatePackage">
	<form method="post" action="forceUpdate.html">
		<tr>
			<td>
				<xsl:value-of select="@filename"/>
			</td>
			<td>
				<xsl:value-of select="@version"/>
			</td>
			<td style="text-align:center;">
				<xsl:value-of select="@required-version"/>
			</td>
			<td>
				<xsl:value-of select="@type"/>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="count(AccessPoint) &gt; 0">
							<input type='hidden' name='checksum'><xsl:attribute name="value"><xsl:value-of select="@checksum"/></xsl:attribute></input>
								<xsl:for-each select="AccessPoint">
								<p>
									<label>
										AP <xsl:value-of select="@id"/>
									</label>
										<input type="checkbox" style="vertical-align: middle; margin: 0px;margin-left:5px">
											<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
											<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>						
										</input>
									
								</p>	
								</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>No devices for update available</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<input type="submit" value="Force Update"/>
			</td>
		</tr>
	</form>
</xsl:template>

<!-- UpdateStatus -->

<xsl:template match="UpdateStatusList">
	<h1>Updates</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Task ID</th>
					<th>Task type</th>
					<th>Page</th>
					<th>AP ID</th>
					<th>Status</th>
					<th>Updated at</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="UpdateStatus"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="UpdateStatus">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="TaskRecord/LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="TaskRecord/LabelIdString"/>
			</a>
		</td>
		<td>
			<a class="taskId">
				<xsl:attribute name="href">/service/updatestatus/task/<xsl:value-of select="TaskId"/>.xml</xsl:attribute>
				<xsl:value-of select="TaskId"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="TaskRecord/TaskType"/>
		</td>
		<td>
			<xsl:value-of select="TaskRecord/Page"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="AccessPointId != ''"><xsl:value-of select="AccessPointId"/></xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="Status"/></xsl:attribute>
			<xsl:value-of select="Status"/>
		</td>
		<td>
			<xsl:value-of select="UpdatedAt"/>
		</td>
		<td class="actions">
			<xsl:choose>
				<xsl:when test="TaskRecord/TaskType = 'IMAGE' or TaskRecord/TaskType = 'PRELOAD_IMAGE'">
					<a>
						<xsl:attribute name="href">/service/updatestatus/image/<xsl:value-of select="TaskId"/>.png</xsl:attribute>
						Show image
					</a>
				</xsl:when>
				<xsl:when test="TaskRecord/TaskType = 'QUERY_COUNTER' or TaskRecord/TaskType = 'QUERY_SENSOR' or TaskRecord/TaskType = 'GET_CONFIG' or TaskRecord/TaskType = 'SET_CONFIG'">
					<a>
						<xsl:attribute name="href">/service/labeldetail/task/<xsl:value-of select="TaskId"/>.xml</xsl:attribute>
						Show data
					</a>
				</xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
	</tr>
</xsl:template>

<xsl:template match="UpdateStatusEntry">
	<h1>Task <xsl:value-of select="UpdateStatus/TaskId"/></h1>
	
	<h2>Update Status Details</h2>
	
	<table class="detail">
		<tr>
			<th>ID:</th>
			<td><span class="taskId"><xsl:value-of select="UpdateStatus/TaskId"/></span></td>
		</tr>
		<tr>
			<th>Label ID:</th>
			<td>
				<a class="serial">
					<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="UpdateStatus/TaskRecord/LabelIdString"/>.xml</xsl:attribute>
					<xsl:value-of select="UpdateStatus/TaskRecord/LabelIdString"/>
				</a>
			</td>
		</tr>
		<xsl:if test="UpdateStatus/TaskRecord/ExternalId != '0' and UpdateStatus/TaskRecord/ExternalId != ''">
			<tr>
				<th>External ID:</th>
				<td>
					<a class="serial">
						<xsl:attribute name="href">/service/updatestatus/externalid/<xsl:value-of select="UpdateStatus/TaskRecord/ExternalId"/>.xml</xsl:attribute>
						<xsl:value-of select="UpdateStatus/TaskRecord/ExternalId"/>
					</a>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<th>Transaction ID:</th>
			<td>
				<xsl:value-of select="UpdateStatus/TaskRecord/TransactionId"/>
			</td>
		</tr>
		<tr>
			<th>Priority:</th>
			<td>
				<xsl:value-of select="UpdateStatus/TaskRecord/Priority"/>
			</td>
		</tr>
		<tr>
			<th>Status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="UpdateStatus/Status"/></xsl:attribute>
				<xsl:value-of select="UpdateStatus/Status"/>
			</td>
		</tr>
		<xsl:if test="UpdateStatus/ErrorCode != ''">
			<tr>
				<th>Error code:</th>
				<td>
					<a>
						<xsl:attribute name="href">/service/description/updateerror/code/<xsl:value-of select="UpdateStatus/ErrorCode"/>.xml</xsl:attribute>
						<xsl:value-of select="UpdateStatus/ErrorCode"/>
					</a>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<th>Task type:</th>
			<td>
				<xsl:value-of select="UpdateStatus/TaskRecord/TaskType"/>
			</td>
		</tr>
		<xsl:if test="UpdateStatus/TaskRecord/TaskType = 'IMAGE' or UpdateStatus/TaskRecord/TaskType = 'PRELOAD_IMAGE'">
			<tr>
				<th>Image:</th>
				<td>
					<img>
						<xsl:attribute name="src">/service/updatestatus/image/<xsl:value-of select="UpdateStatus/TaskId"/>.png</xsl:attribute>
					</img>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="UpdateStatus/TaskRecord/Page != ''">
			<tr>
				<th>Page:</th>
				<td>
					<xsl:value-of select="UpdateStatus/TaskRecord/Page"/>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<th>Retries left:</th>
			<td><xsl:value-of select="UpdateStatus/RetriesLeft"/></td>
		</tr>
		<tr>
			<th>Revision:</th>
			<td><xsl:value-of select="UpdateStatus/Revision"/></td>
		</tr>
		<tr>
			<th>Created at:</th>
			<td><xsl:value-of select="UpdateStatus/CreatedAt"/></td>
		</tr>
		<tr>
			<th>Updated at:</th>
			<td><xsl:value-of select="UpdateStatus/UpdatedAt"/></td>
		</tr>
		<tr>
			<th>Retries valid until:</th>
			<xsl:choose>
				<xsl:when test="UpdateStatus/RetriesValidUntil != ''">
					<td><xsl:value-of select="UpdateStatus/RetriesValidUntil"/></td>
				</xsl:when>
				<xsl:otherwise><td>-</td></xsl:otherwise>
			</xsl:choose>
		</tr>
	</table>
	
	<xsl:if test="UpdateStatus/AccessPointId != ''">
		<h2>Transmission Details</h2>
	
		<table class="detail">
			<tr>
				<th>Access point:</th>
				<td><xsl:value-of select="UpdateStatus/AccessPointId"/></td>
			</tr>
			<tr>
				<th>RSSI:</th>
				<td>
					<xsl:choose>
						<xsl:when test="UpdateStatus/Rssi != ''">
							<xsl:value-of select="UpdateStatus/Rssi"/> dBm
						</xsl:when>
						<xsl:otherwise><em>Unknown</em></xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<th>LQI:</th>
				<td>
					<xsl:choose>
						<xsl:when test="UpdateStatus/Lqi != ''">
							<xsl:value-of select="UpdateStatus/Lqi"/>
						</xsl:when>
						<xsl:otherwise><em>Unknown</em></xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<th>Transmission time:</th>
				<td>
					<xsl:choose>
						<xsl:when test="UpdateStatus/TransmissionTime != ''">
							<xsl:value-of select="UpdateStatus/TransmissionTime"/> ms
						</xsl:when>
						<xsl:otherwise><em>Unknown</em></xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:if>
	
	<h2>Actions</h2>
	
	<ul>
		<li>
			<a>
				<xsl:attribute name="href">/service/updatestatus/taskhistory/<xsl:value-of select="UpdateStatus/TaskId"/>.xml</xsl:attribute>
				Show task history
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">/service/transaction/status/<xsl:value-of select="UpdateStatus/TaskRecord/TransactionId"/>.xml</xsl:attribute>
				Show transaction status
			</a>
		</li>
		<li>
			<a><xsl:attribute name="href">/service/updatestatus/transaction/<xsl:value-of select="UpdateStatus/TaskRecord/TransactionId"/>.xml?page=0</xsl:attribute>
				Show transaction log
			</a>
		</li>
	</ul>
	
</xsl:template>


<!-- TaskRecord -->

<xsl:template match="TaskRecordList">
	<h1>Tasks</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Task type</th>
					<th>Created at</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="TaskRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TaskRecord">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="TaskType"/>
		</td>
		<td>
			<xsl:value-of select="CreatedAt"/>
		</td>
		<!--
		<td class="actions">
			<a>
				<xsl:attribute name="href">/service/updatestatus/taskrecord/<xsl:value-of select="Id"/>.xml</xsl:attribute>
				Show log
			</a>
		</td>
		-->
	</tr>
</xsl:template>


<!-- TransactionRecord -->

<xsl:template match="TransactionRecordList">
	<h1>Transactions</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>ID</th>
					<th>Title</th>
					<th>Tasks</th>
					<th>Created at</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="TransactionRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TransactionRecord">
	<tr>
		<td>
			<xsl:value-of select="Id"/>
		</td>
		<td class="text">
			<xsl:value-of select="Title"/>
		</td>
		<td class="number">
			<xsl:value-of select="TaskCount"/>
		</td>
		<td>
			<xsl:value-of select="CreatedAt"/>
		</td>
		<td class="actions">
			<a><xsl:attribute name="href">/service/transaction/status/<xsl:value-of select="Id"/>.xml</xsl:attribute>Show status</a>,
			<a><xsl:attribute name="href">/service/updatestatus/transaction/<xsl:value-of select="Id"/>.xml?page=0</xsl:attribute>Show log</a>
		</td>
	</tr>
</xsl:template>


<!-- LicenceRecord -->

<xsl:template match="LicenceRecordList">
	<h1>Licences</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Import date</th>
					<th>Comment</th>
					<th>Encrypted Licence File Content</th>
				</tr>
				
				<xsl:apply-templates select="LicenceRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LicenceRecord">
	<tr>
		<td>
			<xsl:value-of select="CreatedAt"/>
		</td>
		<td>
			<xsl:value-of select="Comment"/>
		</td>
		<td class="licence">
			<xsl:value-of select="LicenceKey"/>
		</td>
	</tr>
</xsl:template>


<!-- Configuration -->

<xsl:template match="ConfigurationList">
	<h1>Configuration Entries</h1>
	
	<xsl:call-template name="paging"/>
	
	<table class="record">
		<tr>
			<th>Key</th>
			<th>Type</th>
			<th>Default</th>
			<th>Value</th>
		</tr>
		
		<xsl:for-each select="Configuration">
			<tr>
				<td>
					<xsl:value-of select="Key"/>
				</td>
				<td>
					<xsl:value-of select="Type"/>
				</td>
				<td>
					<xsl:value-of select="DefaultValue"/>
				</td>
				<td>
					<xsl:if test="Value != DefaultValue">
						<xsl:attribute name="class">modified</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="Value"/>
				</td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>


<!-- User -->

<xsl:template match="UserList">
	<h1>Users</h1>
	
	<xsl:call-template name="paging"/>
	
	<table class="record">
		<tr>
			<th>Username</th>
			<th>First name</th>
			<th>Last name</th>
			<th>Mail address</th>
			<th>Role</th>
			<th>API Access</th>
			<th>API Token</th>
		</tr>
		
		<xsl:apply-templates select="User"/>
	</table>
</xsl:template>

<xsl:template match="User">
	<tr>
		<td>
			<xsl:value-of select="Username"/>
		</td>
		<td>
			<xsl:value-of select="FirstName"/>
		</td>
		<td>
			<xsl:value-of select="LastName"/>
		</td>
		<td>
			<a>
				<xsl:attribute name="href">mailto:<xsl:value-of select="MailAddress"/></xsl:attribute>
				<xsl:value-of select="MailAddress"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="Role"/>
		</td>
		<td>
			<xsl:value-of select="ApiAccess"/>
		</td>
		<td>
			<xsl:value-of select="ApiToken"/>
		</td>
	</tr>
</xsl:template>


<!-- AccessPointInfo -->

<xsl:template match="AccessPointInfoList">
	<h1>Access Points</h1>
	
	<xsl:call-template name="paging"/>
	
	<table class="list">
		<tr>
			<th>AP ID</th>
			<th>Name</th>
			<th>Version</th>
			<th>Address</th>
			<th>Channel</th>
			<th>Auto config</th>
			<th>Last update</th>
			<th>Protocol</th>
			<th>Status</th>
		</tr>
		
		<xsl:apply-templates select="AccessPointInfo"/>
	</table>
</xsl:template>

<xsl:template match="AccessPointInfo">
	<tr>
		<td>
			<xsl:value-of select="AccessPointId"/>
		</td>
		<td>
			<xsl:value-of select="Name"/>
		</td>
		<td>
			<xsl:value-of select="Version"/>
		</td>
		<td>
			<a>
				<xsl:choose>
					<xsl:when test="(ConnectionStatus/text()='DISCOVERED') and (number(AccessPointId/text()) &gt;= 65536) and (number(AccessPointId/text()) &lt;= 131071)">
						<xsl:attribute name="href">http://<xsl:value-of select="substring-before(substring-after(Address/text(),'://'),':')"/>/</xsl:attribute>
						http://<xsl:value-of select="substring-before(substring-after(Address/text(),'://'),':')"/>/
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="href"><xsl:value-of select="Address"/>service/status.xml</xsl:attribute>
						<xsl:value-of select="Address"/>
					</xsl:otherwise>
				</xsl:choose>
			</a>
		</td>
		<td>
			<xsl:value-of select="Channel"/>
		</td>
		<td>
			<xsl:value-of select="AutoConfig"/>
		</td>
		<td>
			<xsl:value-of select="UpdateTime"/>
		</td>
		<td>
			<xsl:value-of select="Protocol"/>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="ConnectionStatus"/></xsl:attribute>
			<xsl:value-of select="ConnectionStatus"/>
		</td>
	</tr>
</xsl:template>


<!-- AccessPointConfiguration -->

<xsl:template match="AccessPointConfigurationList">
	<h1>Access Point Configurations</h1>
	
	<xsl:call-template name="paging"/>
	
	<table class="record">
		<tr>
			<th>AP ID</th>
			<th>Address</th>
			<th>Port</th>
			<th>SSL</th>
			<th>Hostname</th>
			<th>Subnet mask</th>
			<th>Gateway</th>
			<th>DNS</th>
			<th>Channel</th>
		</tr>
		
		<xsl:apply-templates select="AccessPointConfiguration"/>
	</table>
</xsl:template>

<xsl:template match="AccessPointConfiguration">
	<tr>
		<td>
			<xsl:value-of select="AccessPointId"/>
		</td>
		<td>
			<xsl:value-of select="Address"/>
		</td>
		<td>
			<xsl:if test="Port >= 0">
				<xsl:value-of select="Port"/>
			</xsl:if>
		</td>
		<td>
			<xsl:value-of select="Ssl"/>
		</td>
		<td>
			<xsl:value-of select="HostName"/>
		</td>
		<td>
			<xsl:value-of select="SubnetMask"/>
		</td>
		<td>
			<xsl:value-of select="Gateway"/>
		</td>
		<td>
			<xsl:value-of select="Dns"/>
		</td>
		<td>
			<xsl:value-of select="Channel"/>
		</td>
	</tr>
</xsl:template>


<!-- Logging -->

<xsl:template match="LoggingList">
	<h1>Logging</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table>
				<tr>
					<th>Level</th>
					<th>Date</th>
					<th>Name</th>
					<th>Message</th>
				</tr>
				
				<xsl:apply-templates select="Logging"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Label Data -->

<xsl:template match="LabelDetailList">
	<h1>Label Data</h1>
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Type</th>
					<th>Name</th>
					<th>Value</th>
					<th>Updated at</th>
				</tr>
				
				<xsl:apply-templates select="LabelDetail"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelDetail">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="Type"/>
		</td>
		<td>
			<xsl:value-of select="Name"/>
		</td>
		<td>
			<xsl:value-of select="Value"/>
		</td>
		<td>
			<xsl:value-of select="UpdatedAt"/>
		</td>
	</tr>
</xsl:template>


<xsl:template match="Logging">
	<tr>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="Level"/> centered</xsl:attribute>
			<xsl:value-of select="Level"/>
		</td>
		<td><xsl:value-of select="Time"/></td>
		<td><xsl:value-of select="Logger"/></td>
		<td><xsl:value-of select="Message"/></td>
	</tr>
</xsl:template>


<!-- LabelInfoHistoryRecord -->

<xsl:template match="LabelInfoHistoryRecordList">
	<h1>Label History</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="list">
				<tr>
					<th>Label ID</th>
					<th>Version</th>
					<th>Last seen</th>
					<th>Sync</th>
					<th>Power</th>
					<th>Page</th>
					<th>Error</th>
					<th>RSSI</th>
					<th>LQI</th>
					<th>AP</th>
					<th>Status</th>
					<th>Page</th>
					<th>Updated at</th>
					<th>Actions</th>
				</tr>
				
				<xsl:apply-templates select="LabelInfoHistoryRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelInfoHistoryRecord">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="FirmwareVersion"/>
		</td>
		<td>
			<xsl:value-of select="WakeupTime"/>
		</td>
		<td>
			<xsl:value-of select="SyncQuality"/>
		</td>
		<td>
			<xsl:value-of select="PowerStatus"/>
		</td>
		<td>
			<xsl:value-of select="CurrentPage"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="LabelErrors != '0'">
					<xsl:attribute name="class">ERROR</xsl:attribute>
					<a>
						<xsl:attribute name="href">/service/description/labelerror/code/<xsl:value-of select="LabelErrors"/>.xml</xsl:attribute>
						<xsl:value-of select="LabelErrors"/>
					</a>
				</xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:value-of select="Rssi"/>
		</td>
		<td>
			<xsl:value-of select="Lqi"/>
		</td>
		<td>
			<xsl:value-of select="AccessPointId"/>
		</td>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="ConnectionStatus"/></xsl:attribute>
			<xsl:value-of select="ConnectionStatus"/>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="CurrentPage != ''"><xsl:value-of select="CurrentPage"/></xsl:when>
				<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:value-of select="UpdatedAt"/>
		</td>
		<td class="actions">
			<a>
				<xsl:attribute name="href">/service/updatestatus/label/<xsl:value-of select="LabelIdString"/>.xml?page=0</xsl:attribute>
				Show log
			</a>
		</td>
	</tr>
</xsl:template>

<!-- Label Statistics -->

<xsl:template match="LabelStatisticsList">
	<h1>Label Statistics</h1>
	
	<div id="pagingbar">
		<p id="summary">
			Showing statistics of <xsl:value-of select="@totalLabels"/> labels
		</p>
	</div>
	
	<xsl:choose>
		<xsl:when test="@totalLabels = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Category</th>
					<th>Identifier</th>
					<th>Description</th>
					<th>Count</th>
					<th>Percentage</th>
				</tr>

				<xsl:apply-templates select="LabelStatistics"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelStatistics">
	<tr>
		<td>
			<xsl:value-of select="@category"/>
		</td>
		<td>
			<xsl:value-of select="@identifier"/>
		</td>
		<td>
			<xsl:value-of select="@description"/>
		</td>
		<td>
			<xsl:value-of select="@count"/>
		</td>
		<td>
			<xsl:value-of select="@percentage"/>
		</td>
	</tr>
</xsl:template>

<!-- LabelPageContent -->

<xsl:template match="LabelPageContentList">
	<h1>Label Page Content</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Label ID</th>
					<th>Page</th>
					<th>Image</th>
				</tr>

				<xsl:apply-templates select="LabelPageContent"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelPageContent">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="Page"/>
		</td>
		<td>
			<img><xsl:attribute name="src">/service/labelpagecontent/image/<xsl:value-of select="Id"/>.png</xsl:attribute></img>
		</td>
	</tr>
</xsl:template>

<!-- BatteryReplacementRecord -->

<xsl:template match="BatteryReplacementRecordList">
	<h1>Battery Replacements</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Label ID</th>
					<th>Timestamp</th>
				</tr>

				<xsl:apply-templates select="BatteryReplacementRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="BatteryReplacementRecord">
	<tr>
		<td>
			<a class="serial">
				<xsl:attribute name="href">/service/labelinfo/details/<xsl:value-of select="LabelIdString"/>.xml</xsl:attribute>
				<xsl:value-of select="LabelIdString"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="Timestamp"/>
		</td>
	</tr>
</xsl:template>

<!-- API Logging -->
<xsl:template match="RequestHistoryRecordList">
	<h1>API Logging</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>ID</th>
					<th>Timestamp</th>
					<th>Method</th>
					<th>URI</th>
					<th>Status</th>
					<th>Error Message</th>
					<th>Principal</th>
					<th>Auth Scheme</th>
					<th>Elapsed Time</th>
					<th>Client</th>
					<th>User-Agent</th>
				</tr>

				<xsl:for-each select="RequestHistoryRecord">
					<tr>
						<td><xsl:value-of select="Id"/></td>
						<td><xsl:value-of select="Timestamp"/></td>
						<td class="INFO" style="text-align: center;"><xsl:value-of select="Method"/></td>
						<td><xsl:value-of select="Uri"/></td>
						<td style="text-align: center;">
							<xsl:attribute name="class">
								<xsl:choose>
									<xsl:when test="Status = '200'">
										SUCCESSFUL
									</xsl:when>
									<xsl:otherwise>
										ERROR		
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						<xsl:value-of select="Status"/></td>
						<td><xsl:value-of select="ErrorMessage"/></td>
						<td><xsl:value-of select="Principal"/></td>
						<td><xsl:value-of select="AuthScheme"/></td>
						<td><xsl:value-of select="ElapsedTime"/> ms</td>
						<td><xsl:value-of select="RemoteAddress"/></td>
						<td><xsl:value-of select="UserAgent"/></td>
						
					</tr>
				</xsl:for-each>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="JerseyDetailedLogRecordList">
	<h1>API Logging Details</h1>
	
	<table class="record">
		<tr>
			<th>Type</th>
			<th>Level</th>
			<th>Timestamp</th>
			<th>Message</th>
		</tr>
		
		<xsl:for-each select="JerseyDetailedLogRecord">
		<tr>
			<td><xsl:value-of select="./Type"/></td>
			<td><xsl:attribute name="class"><xsl:value-of select="./Level"/> centered</xsl:attribute><xsl:value-of select="./Level"/></td>
			<td><xsl:value-of select="Timestamp"/></td>
			<td><pre><xsl:value-of select="./Message"/></pre></td>
		</tr>
		</xsl:for-each>
	</table>
</xsl:template>

<!-- LabelEventRecord -->

<xsl:template match="LabelEventRecordList">
	<h1>Label Events</h1>
	
	<xsl:call-template name="paging"/>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Label ID</th>
					<th>Event ID</th>
					<th>Time</th>
					<th>Type</th>
					<th>Data</th>
				</tr>

				<xsl:apply-templates select="LabelEventRecord"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelEventRecord">
	<tr>
		<td>
			<xsl:value-of select="LabelIdString"/>
		</td>
		<td>
			<a class="record">
				<xsl:attribute name="href">/service/labelevent/id/<xsl:value-of select="EventId"/>.xml</xsl:attribute>
				<xsl:value-of select="EventId"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="ReceivedTime"/>
		</td>
		<td>
			<xsl:value-of select="EventType"/>
		</td>
		<td>
			<xsl:value-of select="EventData"/>
		</td>
	</tr>
</xsl:template>

<!-- Navigation -->

<xsl:template match="PagedResult">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template name="paging">
	<xsl:if test="../@page">
		<div id="pagingbar">
			<p id="summary">
				Showing page <xsl:value-of select="number(../@page) + 1"/> of <xsl:value-of select="../@totalPages"/> with <xsl:value-of select="../@records"/> of <xsl:value-of select="../@totalRecords"/> total records
			</p>
			
			<xsl:if test="number(../@totalPages) &gt; 1">
				<p id="pagenavigation">
					<xsl:call-template name="firstPageLink">
						<xsl:with-param name="currentPageIndex" select="number(../@page)"/>
						<xsl:with-param name="pageCount" select="number(../@totalPages)"/>
						<xsl:with-param name="recordsPerPage" select="number(../@recordsPerPage)"/>
					</xsl:call-template>
					|
					<xsl:call-template name="previousPageLink">
						<xsl:with-param name="currentPageIndex" select="number(../@page)"/>
						<xsl:with-param name="pageCount" select="number(../@totalPages)"/>
						<xsl:with-param name="recordsPerPage" select="number(../@recordsPerPage)"/>
					</xsl:call-template>
					|
					<xsl:call-template name="nextPageLink">
						<xsl:with-param name="currentPageIndex" select="number(../@page)"/>
						<xsl:with-param name="pageCount" select="number(../@totalPages)"/>
						<xsl:with-param name="recordsPerPage" select="number(../@recordsPerPage)"/>
					</xsl:call-template>
					|
					<xsl:call-template name="lastPageLink">
						<xsl:with-param name="currentPageIndex" select="number(../@page)"/>
						<xsl:with-param name="pageCount" select="number(../@totalPages)"/>
						<xsl:with-param name="recordsPerPage" select="number(../@recordsPerPage)"/>
					</xsl:call-template>
				</p>
				
				<p id="directpage">
					<xsl:call-template name="directPageLink">
						<xsl:with-param name="currentPageIndex" select="number(../@page)"/>
						<xsl:with-param name="pageCount" select="number(../@totalPages)"/>
						<xsl:with-param name="recordsPerPage" select="number(../@recordsPerPage)"/>
					</xsl:call-template>
				</p>
			</xsl:if>
		</div>
	</xsl:if>
</xsl:template>

<xsl:template name="directPageLink">
	<xsl:param name="currentPageIndex"/>
	<xsl:param name="pageCount"/>
	<xsl:param name="recordsPerPage"/>
	
	<xsl:if test="$currentPageIndex - 4 &gt;= 0">
		... |
	</xsl:if>
	
	<xsl:if test="$currentPageIndex - 3 &gt;= 0">
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex - 3"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex - 2"/>
		</xsl:call-template>
		|
	</xsl:if>
	
	<xsl:if test="$currentPageIndex - 2 &gt;= 0">
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex - 2"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex - 1"/>
		</xsl:call-template>
		|
	</xsl:if>
	
	<xsl:if test="$currentPageIndex - 1 &gt;= 0">
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex - 1"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex"/>
		</xsl:call-template>
		|
	</xsl:if>
	
	<xsl:value-of select="$currentPageIndex + 1"/>
	
	<xsl:if test="$currentPageIndex + 1 &lt; $pageCount">
		|
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex + 1"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex + 2"/>
		</xsl:call-template>
	</xsl:if>
	
	<xsl:if test="$currentPageIndex + 2 &lt; $pageCount">
		|
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex + 2"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex + 3"/>
		</xsl:call-template>
	</xsl:if>
	
	<xsl:if test="$currentPageIndex + 3 &lt; $pageCount">
		|
		<xsl:call-template name="pageLink">
			<xsl:with-param name="pageIndex" select="$currentPageIndex + 3"/>
			<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
			<xsl:with-param name="caption" select="$currentPageIndex + 4"/>
		</xsl:call-template>
	</xsl:if>
	
	<xsl:if test="$currentPageIndex + 4 &lt; $pageCount">
		| ...
	</xsl:if>
	
</xsl:template>

<xsl:template name="firstPageLink">
	<xsl:param name="currentPageIndex"/>
	<xsl:param name="pageCount"/>
	<xsl:param name="recordsPerPage"/>
	
	<xsl:choose>
		<xsl:when test="$currentPageIndex = 0">
			First
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="pageLink">
				<xsl:with-param name="pageIndex" select="0"/>
				<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
				<xsl:with-param name="caption">First</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="lastPageLink">
	<xsl:param name="currentPageIndex"/>
	<xsl:param name="pageCount"/>
	<xsl:param name="recordsPerPage"/>
	
	<xsl:choose>
		<xsl:when test="$currentPageIndex = ($pageCount - 1)">
			Last
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="pageLink">
				<xsl:with-param name="pageIndex" select="$pageCount - 1"/>
				<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
				<xsl:with-param name="caption">Last</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="previousPageLink">
	<xsl:param name="currentPageIndex"/>
	<xsl:param name="pageCount"/>
	<xsl:param name="recordsPerPage"/>
	
	<xsl:choose>
		<xsl:when test="$currentPageIndex &lt;= 0">
			Previous
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="pageLink">
				<xsl:with-param name="pageIndex" select="$currentPageIndex - 1"/>
				<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
				<xsl:with-param name="caption">Previous</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="nextPageLink">
	<xsl:param name="currentPageIndex"/>
	<xsl:param name="pageCount"/>
	<xsl:param name="recordsPerPage"/>
	
	<xsl:choose>
		<xsl:when test="($currentPageIndex + 1) &gt;= $pageCount">
			Next
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="pageLink">
				<xsl:with-param name="pageIndex" select="$currentPageIndex + 1"/>
				<xsl:with-param name="recordsPerPage" select="$recordsPerPage"/>
				<xsl:with-param name="caption">Next</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="pageLink">
	<xsl:param name="pageIndex"/>
	<xsl:param name="recordsPerPage"/>
	<xsl:param name="caption"/>
	
	<a>
		<xsl:attribute name="href">?page=<xsl:value-of select="$pageIndex"/>&amp;recordsPerPage=<xsl:value-of select="$recordsPerPage"/></xsl:attribute>
		<xsl:value-of select="$caption"/>
	</a>
</xsl:template>
  
</xsl:stylesheet>
