<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- How to display an article -->

<xsl:template match="article">
	<h1>Article <xsl:value-of select="./@articleNumber"/></h1>
	
	<h2>Article Fields</h2>
	
	<table class="detail">
		<tr>
			<th>articleNumber</th>
			<td><xsl:value-of select="./@articleNumber"/></td>
		</tr>
		
		<tr>
			<th>gtin</th>
			<td>
				<xsl:for-each select="gtin">
					<xsl:value-of select="./@number"/>
					<xsl:if test="position() != last()">, </xsl:if>
				</xsl:for-each>
			</td>
		</tr>
				
		<xsl:for-each select="field">
			<tr>
				<th><xsl:value-of select="./@key"/></th>
				<td><xsl:value-of select="./@value"/></td>
			</tr>
		</xsl:for-each>
	</table>
	
</xsl:template>

</xsl:stylesheet>
