<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="Strategies">
		<h1>Data Fetch Strategy Information</h1>
	</xsl:template>
	
	<xsl:template match="Counters">
		<h2>Label Counters (<xsl:value-of select="count(Counter)"/>)</h2>
		<table>
			<th>Counter</th>
			
			<xsl:for-each select="../Strategies/Strategy">
				<th><xsl:value-of select="."/></th>
			</xsl:for-each>
			
			<xsl:for-each select="Counter">
				<tr>
					<td><xsl:value-of select="@name"/></td>
					
					<xsl:for-each select="Filters/Filter">
						<td><xsl:value-of select="."/></td>
					</xsl:for-each>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	
	<xsl:template match="Sensors">
		<h2>Label Sensors (<xsl:value-of select="count(Sensor)"/>)</h2>
		<table>
			<th>Sensor</th>
			
			<xsl:for-each select="../Strategies/Strategy">
				<th><xsl:value-of select="."/></th>
			</xsl:for-each>
			
			<xsl:for-each select="Sensor">
				<tr>
					<td><xsl:value-of select="@name"/></td>
					
					<xsl:for-each select="Filters/Filter">
						<td><xsl:value-of select="."/></td>
					</xsl:for-each>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	
	<xsl:template match="Configs">
		<h2>Label Configs (<xsl:value-of select="count(Config)"/>)</h2>
		<table>
			<th>Config</th>
			
			<xsl:for-each select="../Strategies/Strategy">
				<th><xsl:value-of select="."/></th>
			</xsl:for-each>
			
			<xsl:for-each select="Config">
				<tr>
					<td><xsl:value-of select="@name"/></td>
					
					<xsl:for-each select="Filters/Filter">
						<td><xsl:value-of select="."/></td>
					</xsl:for-each>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	
</xsl:stylesheet>