<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Backend Tasks -->
<xsl:template match="backend-tasks">
	<h1>Backend Tasks (<xsl:value-of select="count(task)"/>)</h1>

	<table class="list">
		<tr>
			<th>ID</th>
			<th>Task</th>
			<th>Arguments</th>
			<th>Create Time</th>
			<th>Start Time</th>
			<th>End Time</th>
			<th>Status</th>
		</tr>

		<xsl:for-each select="task">
			<tr>
				<td><xsl:value-of select="./@id"/></td>
				<td><xsl:value-of select="./@task"/></td>
				<td><xsl:value-of select="./@arguments"/></td>
				<td><xsl:value-of select="./@create-time"/></td>
				<td><xsl:value-of select="./@start-time"/></td>
				<td><xsl:value-of select="./@end-time"/></td>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="./@status"/></xsl:attribute>
					<xsl:value-of select="./@status"/>
				</td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>


<!-- List of Configuration Entries -->
<xsl:template match="entries">
	<h1>Configuration</h1>

	<table class="detail">
		<xsl:for-each select="entry">
			<tr>
				<th><xsl:value-of select="./@key"/>:</th>
				<td><xsl:value-of select="./@value"/></td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>

</xsl:stylesheet>
