﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  
<!-- Info Messages -->
<xsl:template match="message">
	<h1>ESL</h1>

	<p>
		<xsl:choose>
			<xsl:when test="./@code='200'">
				<xsl:attribute name="id">message</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="id">warning</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:value-of select="."/>
	</p>
</xsl:template>


<!-- Internal Server Errors (unhandled exceptions) -->
<xsl:template match="error">
	<h1>Internal Server Error</h1>
	
	<p id="error">
		<strong><xsl:value-of select="./@message"/></strong> (<xsl:value-of select="./@class"/>)
	</p>
	
	<h2>Stack Trace</h2>
	
	<table>
		<tr>
			<th>Method</th>
			<th>Source</th>
		</tr>
		
		<xsl:for-each select="stack-trace">
			<tr>
				<td><xsl:value-of select="./@class"/>.<xsl:value-of select="./@method"/></td>
				<td><xsl:value-of select="./@file"/>:<xsl:value-of select="./@line"/></td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>


<!-- Labels -->
<xsl:template match="labels">
	<h1>Registered Labels (<xsl:value-of select="count(label)"/>)</h1>
	
	<table>
		<tr>
			<th>Label ID</th>
		</tr>
		
		<xsl:for-each select="label">
			<xsl:sort select="./@id"/>
			
			<tr>
				<td class="serial"><xsl:value-of select="./@id"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<!-- Logging -->
<xsl:template match="logs">
	<h1>Logs</h1>
	
	<table>
		<tr>
			<th>Level</th>
			<th>Date</th>
			<th>Name</th>
			<th>Message</th>
		</tr>
		<xsl:for-each select="log">
			<tr>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="./@level"/> centered</xsl:attribute>
					<xsl:value-of select="@level"/>
				</td>
				<td><xsl:value-of select="@time"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@message"/></td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>

</xsl:stylesheet>
