<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" encoding="utf-8" indent="yes"/>
	<xsl:include href="default.xsl"/>
	
<xsl:template match="restore">
	<table style="width:33%">
		<xsl:apply-templates/>
	</table>
</xsl:template>

<xsl:template match="restore-form">
	<tr>
		<td colspan="2" class="form" style="text-align:left; padding:0.5em; font-weight:bold">
			<xsl:value-of select="@caption"/>
		</td>
	</tr>
	<tr style="line-height:2em">
		<td>
			<xsl:call-template name="tmpSplitString">
            	<xsl:with-param name="stringtosplit" select ="@description" />
        	</xsl:call-template>
		</td>
		<td>
			<form>
				<xsl:attribute name="id">
					<xsl:value-of select="@name" />
				</xsl:attribute>
			
				<xsl:attribute name="action">
					<xsl:value-of select="@action" />
				</xsl:attribute>
			
				<xsl:attribute name="method">
					<xsl:value-of select="@method" />
				</xsl:attribute>
				
				<xsl:if test="@enctype != ''">
					<xsl:attribute name="enctype">
						<xsl:value-of select="@enctype" />
					</xsl:attribute>	
				</xsl:if>				
				<xsl:apply-templates/> 
			</form>
		</td>
	</tr>
	<tr style=""><td colspan="2" style="background-color:transparent"></td></tr>
</xsl:template>

<xsl:template match="restore-button">
	<input type="button">
		<xsl:attribute name="onClick">
			if(confirm('<xsl:value-of select="@question" />')) document.forms["<xsl:value-of select="../@name" />"].submit();  
		</xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="@caption"/></xsl:attribute>
	</input>
</xsl:template>

<xsl:template match="forms">
	<table>
		<tr>
			<th colspan="2">Actions</th>
		</tr>
		<xsl:apply-templates/>
	</table>
</xsl:template>

<xsl:template match="form">
	<tr>
		<td>
			<xsl:value-of select="@caption"/>
		</td>
		<td>
			<form>
				<xsl:attribute name="id">
					<xsl:value-of select="@name" />
				</xsl:attribute>
			
				<xsl:attribute name="action">
					<xsl:value-of select="@action" />
				</xsl:attribute>
			
				<xsl:attribute name="method">
					<xsl:value-of select="@method" />
				</xsl:attribute>
				
				<xsl:if test="@enctype != ''">
					<xsl:attribute name="enctype">
						<xsl:value-of select="@enctype" />
					</xsl:attribute>	
				</xsl:if>				
				<xsl:apply-templates/> 
			</form>
		</td>
	</tr>
</xsl:template>

<xsl:template match="confirm-button">
	<input type="button">
		<xsl:attribute name="onClick">
			if(confirm('<xsl:value-of select="@question" />')) document.forms["<xsl:value-of select="../@name" />"].submit(); 
		</xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="@caption"/></xsl:attribute>
	</input>
</xsl:template>
	
<xsl:template match="file-upload">
	<script type="text/
	javascript">
		document.forms["<xsl:value-of select="../@name" />"].enctype = "multipart/form-data";
	</script>
	<input type="file" accept="multipart/form-data">
		<xsl:attribute name="id">
			<xsl:value-of select="@name" />
		</xsl:attribute>
		<xsl:attribute name="name">
			<xsl:value-of select="@name" />
		</xsl:attribute>
	</input>
	
	<input type="button">
		<xsl:attribute name="onClick">
			if(document.getElementById('<xsl:value-of select="@name" />').value == '') {
				alert("Please select a file to upload");
			}
			else {
				if(confirm('<xsl:value-of select="@question" />')) document.forms["<xsl:value-of select="../@name" />"].submit(); 
			}
		</xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="@caption"/></xsl:attribute>
	</input>
</xsl:template>

	<xsl:template match="configuration">
		<h1>System Settings</h1>
		
		<table>
			<tr>
				<th>Key</th>
				<th style="width: 15em;">Value</th>
			</tr>
			<xsl:if test="autoConfig/@value='true' or autoConfig/@value='false'">
				<tr>
					<td>autoConfig</td>
					<td><xsl:value-of select="@autoConfig"/></td>
				</tr>
			</xsl:if>
			<xsl:for-each select="*">
				<xsl:for-each select="@*">
					<tr>
						<td><xsl:value-of select="name(..)"/> -- <xsl:value-of select="name()"/></td>
						<td><xsl:value-of select="./."/></td>
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>
	
	</xsl:template>
	
	<xsl:template match="autoConfig-form">
		<h1>Configuration Mode Settings</h1>
		<form method="post" action="autoConfig.html">
			  
			<table>
				<tr>
					<td class="form">Centralized Configuration Enabled:</td>
					<td>
						<input type='hidden' name='autoConfig'/>
						<input type="checkbox" name="autoConfig">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
		
	</xsl:template>

	<xsl:template match="support-form">
		<h1>Remote Support Settings</h1>
		<form method="post" action="remote.html">
			  
			<table>
				<tr>
					<td class="form">Remote Support Enabled:</td>
					<td>
						<input type='hidden' name='enabled'/>
						<input type="checkbox" name="enabled">
							<xsl:if test="enabled/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	</xsl:template>
	
	<xsl:template match="multi-network-form">
		<h1>Network Settings</h1>
	
		<form method="post" action="/service/config/network.html">
			<input type='hidden' name='adapternames'><xsl:attribute name="value"><xsl:value-of select="adapternames/@value"/></xsl:attribute></input>
			<table>
				<tr>
					<td class="form">Hostname:</td>
					<td>
						<input name="hostname" type="text">
							<xsl:attribute name="value"><xsl:value-of select="hostname/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="hostname/@message!=''">
						<td><xsl:value-of select="hostname/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Default Gateway:</td>
					<td>
						<input name="gateway" id="gateway" type="text">
							<xsl:attribute name="value"><xsl:value-of select="gateway/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="gateway/@message!=''">
						<td><xsl:value-of select="gateway/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Nameserver 1:</td>
					<td>
						<input name="nameserver1" id="nameserver1" type="text">
							<xsl:attribute name="value"><xsl:value-of select="nameserver1/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="nameserver1/@message!=''">
						<td><xsl:value-of select="nameserver1/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Nameserver 2:</td>
					<td>
						<input name="nameserver2" id="nameserver2" type="text">
							<xsl:attribute name="value"><xsl:value-of select="nameserver2/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="nameserver2/@message!=''">
						<td><xsl:value-of select="nameserver2/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Network Mode:</td>
					<td>
						<select id="networkMode" name="networkMode" onchange="networkModeChanged();">
							<option>
								<xsl:if test="bridgedEnabled/@value='true'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Bridged
							</option>
							<option>
								<xsl:if test="bridgedEnabled/@value='false'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Manual
							</option>
						</select>
					</td>
				</tr>
			</table>
			
			<h1>Interface Settings</h1>
			
			<div>
				<div id="bridgedInterface" style="padding-top:5px">
					<h2>Bridge</h2>
					<table style="padding-bottom:20px;">
						<tr>
							<td class="form">DHCP:</td>
							<td>
								<input type='hidden' name='dhcp'/>
								<input type="checkbox" name="dhcp" id="dhcp" onclick="updateEnabledBridgeFields();">
									<xsl:if test="bridgedDhcp/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
								</input>
							</td>
							<xsl:if test="bridgedDhcp/@message!=''">
								<td><xsl:value-of select="bridgedDhcp/@message" /></td>
							</xsl:if>
						</tr>
				
						<tr>
							<td class="form">IP Address:</td>
							<td>
								<input name="address" id="address" type="text">
									<xsl:attribute name="value"><xsl:value-of select="bridgedAddress/@value"/></xsl:attribute>
								</input>
							</td>
							<xsl:if test="bridgedAddress/@message!=''">
								<td><xsl:value-of select="bridgedAddress/@message" /></td>
							</xsl:if>
						</tr>
						
						<tr>
							<td class="form">Subnet Mask:</td>
							<td>
								<input name="netmask" id="netmask" type="text">
									<xsl:attribute name="value"><xsl:value-of select="bridgedNetmask/@value"/></xsl:attribute>
								</input>
							</td>
							<xsl:if test="bridgedNetmask/@message!=''">
								<td><xsl:value-of select="bridgedNetmask/@message" /></td>
							</xsl:if>
						</tr>
					</table>
				</div>
				<div id="networkInterfaces" style="padding-top:5px">
					<xsl:for-each select="./*">
						<xsl:sort select="name(.)" />
						<xsl:if test="substring(name(.), string-length(name(.)) - string-length('_dhcp') +1) = '_dhcp'">
							<div name="networkInterface" style="float:left;margin-right:40px;margin-bottom:10px">
								<h2>
									<xsl:variable name="interfaceName" select="substring-before(name(.), '_dhcp')"/>
									<xsl:variable name="nameInterfaceIndex" select="concat(substring-before(name(.), '_dhcp'), '_index')"/>
									<xsl:variable name="valueInterfaceIndex" select="../node()[local-name() = $nameInterfaceIndex]"/>
									Port <xsl:value-of select="$valueInterfaceIndex/@value + 1"/> (<xsl:value-of select="$interfaceName"/>)
								</h2>
								
								<xsl:variable name="nameDhcp" select="concat(substring-before(name(.), '_dhcp'), '_dhcp')"/>
								<xsl:variable name="nameAddress" select="concat(substring-before(name(.), '_dhcp'), '_address')"/>
								<xsl:variable name="nameNetmask" select="concat(substring-before(name(.), '_dhcp'), '_netmask')"/>
								<xsl:variable name="nameGateway" select="concat(substring-before(name(.), '_dhcp'), '_gateway')"/>
								
								<xsl:variable name="valueDhcp" select="../node()[local-name() = $nameDhcp]"/>
								<xsl:variable name="valueAddress" select="../node()[local-name() = $nameAddress]"/>
								<xsl:variable name="valueNetmask" select="../node()[local-name() = $nameNetmask]"/>
								<xsl:variable name="valueGateway" select="../node()[local-name() = $nameGateway]"/>
								
								<table name="networkInterfacesTable" style="padding-bottom:20px">
									<tr>
										<td class="form">DHCP:</td>
										<td>
											<input type='hidden' name='dhcp'/>
											<input type="checkbox" class="dhcp" onclick="updateEnabledFields();">
												<xsl:attribute name="name"><xsl:value-of select="$nameDhcp"/></xsl:attribute>
												<xsl:attribute name="id"><xsl:value-of select="$nameDhcp"/></xsl:attribute>
												<xsl:if test="$valueDhcp/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
											</input>
										</td>
										<xsl:if test="$valueDhcp/@message!=''">
											<td><xsl:value-of select="$valueDhcp/@message" /></td>
										</xsl:if>
									</tr>
								
									<tr>
										<td class="form">IP Address:</td>
										<td>
											<input type="text" class="address">
												<xsl:attribute name="name"><xsl:value-of select="$nameAddress"/></xsl:attribute>
												<xsl:attribute name="id"><xsl:value-of select="$nameAddress"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="$valueAddress/@value"/></xsl:attribute>
											</input>
										</td>
										<xsl:if test="$valueAddress/@message!=''">
											<td><xsl:value-of select="$valueAddress/@message" /></td>
										</xsl:if>
									</tr>
									
									<tr>
										<td class="form">Subnet Mask:</td>
										<td>
											<input type="text" class="netmask">
												<xsl:attribute name="name"><xsl:value-of select="$nameNetmask"/></xsl:attribute>
												<xsl:attribute name="id"><xsl:value-of select="$nameNetmask"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="$valueNetmask/@value"/></xsl:attribute>
											</input>
										</td>
										<xsl:if test="$valueNetmask/@message!=''">
											<td><xsl:value-of select="$valueNetmask/@message" /></td>
										</xsl:if>
									</tr>
								</table>
							</div>
						</xsl:if>
					</xsl:for-each>
					<div style="clear:left"/>
				</div>
				
			</div>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
		
		<script type="text/javascript">
			function networkModeChanged() {
				var value = document.getElementById('networkMode').value;
				
				if (value === 'Bridged') {
					document.getElementById('networkInterfaces').style.visibility = 'hidden';
					document.getElementById('bridgedInterface').style.visibility = 'visible';
					document.getElementById('networkInterfaces').style.display = 'none';
					document.getElementById('bridgedInterface').style.display = 'block';
				
				}
				else if (value === 'Manual') {
					document.getElementById('networkInterfaces').style.visibility = 'visible';
					document.getElementById('bridgedInterface').style.visibility = 'hidden';
					document.getElementById('networkInterfaces').style.display = 'block';
					document.getElementById('bridgedInterface').style.display = 'none';
				}
			}
			
			function updateEnabledFields() {
				var value = document.getElementById('networkMode').value;
				var dhcpFields = document.getElementsByClassName('dhcp');
				var atLeastOneStatic = false;
				
				for (var i = 0; i &lt; dhcpFields.length; i++) {
					var field = dhcpFields[i];
					var enabled = true;
					
					if (field.getAttribute('type') === 'checkbox') {
						enabled = field.checked;
						field.value = enabled;
					}
					else {
						field.checked = enabled;
						field.value = enabled;
					}
					
					if (!enabled) {
						atLeastOneStatic = true;
					}
					
					var interfaceName = field.getAttribute("name").split('_dhcp')[0];
					
					document.getElementById(interfaceName + '_address').disabled = enabled;
					document.getElementById(interfaceName + '_netmask').disabled = enabled;
				}
				
				if (value === 'Manual') {
					document.getElementById('gateway').disabled = !atLeastOneStatic;
				}
			}
			
			function updateEnabledBridgeFields() {
				var value = document.getElementById('networkMode').value;
				var fields = document.getElementsByName('dhcp');
				var enabled = true;
				
				for (var j = 0; j &lt; fields.length; j++) {
					var field = fields[j];
					
					if (field.getAttribute('type') === 'checkbox') {
						enabled = field.checked;
						field.value = enabled;
					}
					else {
						field.value = enabled;
						field.checked = enabled;
					}
				}
				
				document.getElementById('address').disabled = enabled;
				document.getElementById('netmask').disabled = enabled;
					
				if (value === 'Bridged') {
					document.getElementById('gateway').disabled = enabled;
				}				
			}
			
			window.onload = updateEnabledBridgeFields();
			window.onload = updateEnabledFields();
			window.onload = networkModeChanged();
		</script>
	</xsl:template>
	
	<xsl:template match="network-form">
	
		<h1>Network Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<form method="post" action="/service/config/network.html">
			<table>
				<tr>
					<td class="form">Hostname:</td>
					<td>
						<input name="hostname" type="text">
							<xsl:attribute name="value"><xsl:value-of select="hostname/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="hostname/@message!=''">
						<td><xsl:value-of select="hostname/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">DHCP:</td>
					<td>
						<input type='hidden' name='dhcp'/>
						<xsl:choose>
							<xsl:when test="autoConfig/@value='true'">
								<input type="checkbox" name="dhcp" id="dhcp">
									<xsl:if test="dhcp/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</input>
							</xsl:when>
							<xsl:otherwise>
								<input type="checkbox" name="dhcp" id="dhcp" onclick="updateEnabledFields();">
									<xsl:if test="dhcp/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
								</input>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<xsl:if test="dhcp/@message!=''">
						<td><xsl:value-of select="dhcp/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">IP Address:</td>
					<td>
						<input name="address" id="address" type="text">
							<xsl:attribute name="value"><xsl:value-of select="address/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="address/@message!=''">
						<td><xsl:value-of select="address/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Subnet Mask:</td>
					<td>
						<input name="netmask" id="netmask" type="text">
							<xsl:attribute name="value"><xsl:value-of select="netmask/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="netmask/@message!=''">
						<td><xsl:value-of select="netmask/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Default Gateway:</td>
					<td>
						<input name="gateway" id="gateway" type="text">
							<xsl:attribute name="value"><xsl:value-of select="gateway/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="gateway/@message!=''">
						<td><xsl:value-of select="gateway/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Nameserver 1:</td>
					<td>
						<input name="nameserver1" id="nameserver1" type="text">
							<xsl:attribute name="value"><xsl:value-of select="nameserver1/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="nameserver1/@message!=''">
						<td><xsl:value-of select="nameserver1/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Nameserver 2:</td>
					<td>
						<input name="nameserver2" id="nameserver2" type="text">
							<xsl:attribute name="value"><xsl:value-of select="nameserver2/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="nameserver2/@message!=''">
						<td><xsl:value-of select="nameserver2/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
			<xsl:if test="autoConfig/@value='false'">
				<script type="text/javascript">
					function updateEnabledFields() {
						var fields = document.getElementsByName('dhcp');
						var enabled = true;
						
						for (var j = 0; j &lt; fields.length; j++) {
							var field = fields[j];
							
							if (field.getAttribute('type') === 'checkbox') {
								enabled = field.checked;
							}
						}
						
						document.getElementById('address').disabled = enabled;
						document.getElementById('netmask').disabled = enabled;
						document.getElementById('gateway').disabled = enabled;
						document.getElementById('nameserver1').disabled = enabled;
						document.getElementById('nameserver2').disabled = enabled;			
					}
					
					window.onload = updateEnabledFields();
				</script>
			</xsl:if>
	</xsl:template>
	
	<xsl:template match="comm-daemon-form">
		<h1>Communication Daemon Settings</h1>
		<!-- <xsl:variable name="settings-disabled" select="thinMode/@value='false' or 
			outboundMode/@value='false'"></xsl:variable> <xsl:if test="$settings-disabled"> <p 
			id="warning">Warning: Thin mode and outbound mode both need to be set before these 
			settings can be changed.</p> </xsl:if> -->

		<form method="post" action="/service/config/communicationDaemon.html" onsubmit="updateHiddenFields();">
			<table>
					<tr>
						<td class="form">Use Thin Mode:</td>
						<td>
							<input type='hidden' name='thinMode' />
							<input type="checkbox" name="thinMode" id="thinMode"
								onclick="updateThinModeFields();">
								<xsl:if test="thinMode/@value='true'">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
				<tr>
					<td class="form">TLS enabled:</td>
					<td>
						<input type='hidden' name='tlsEnabled'/>
						<input type="checkbox" name="tlsEnabled">
							<xsl:if test="tlsEnabled/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
				<tr>
					<td class="form">TLS strict verification:</td>
					<td>
						<input type='hidden' name='tlsStrictVerificationEnabled'/>
						<input type="checkbox" name="tlsStrictVerificationEnabled">
							<xsl:if test="tlsStrictVerificationEnabled/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
				<tr>
					<td class="form">Connection Mode:</td>
					<td>
						<select id="outboundMode" name="outboundMode"
							onchange="updateOutboundFields();">
							<option value="false">
								<xsl:if test="outboundMode/@value = 'false'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Inbound
							</option>
							<option value="true">
								<xsl:if test="outboundMode/@value = 'true'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Outbound
							</option>
						</select>
					</td>
				</tr>
				<tr>
					<td class="form">Apc Address:</td>
					<td>
						<input type='hidden' name='apc-address' />
						<input id="disabled-apc-address" name="disabled-apc-address" type="text">
							<xsl:attribute name="value">
								<xsl:value-of select="apc-address/@value" />
							</xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td class="form">Apc Port:</td>
					<td>
						<input type='hidden' name='apc-port' />
						<input id="disabled-apc-port" name="disabled-apc-port" type="text">
							<xsl:attribute name="value">
								<xsl:value-of select="apc-port/@value" />
							</xsl:attribute>
						</input>
					</td>
				</tr>
			</table>
			<div id="submit">
				<input type="submit" value="Save" />
			</div>

		</form>
		<script type="text/javascript">
			function updateThinModeFields() {
				var thinModeCheckBox = document.getElementById('thinMode');
				var enabled = thinModeCheckBox.checked;
	
				document.getElementById('outboundMode').disabled = !enabled;
				if(!enabled){
					document.getElementById('disabled-apc-port').disabled = !enabled;
					document.getElementById('disabled-apc-address').disabled = !enabled;
				}else{
					updateOutboundFields();
				}
			}

			function updateOutboundFields() {
			var connectionMode = document.getElementById('outboundMode');
			var disabled = (outboundMode.options[connectionMode.selectedIndex].value ==
			'false');

			document.getElementById('disabled-apc-port').disabled = disabled;
			document.getElementById('disabled-apc-address').disabled = disabled;
			}
			
			function updateHiddenFields(){
				document.getElementsByName('apc-address')[0].value = document.getElementById('disabled-apc-address').value;
				document.getElementsByName('apc-port')[0].value = document.getElementById('disabled-apc-port').value;
				return true;
			}

			window.onload = updateThinModeFields();
			window.onload = updateOutboundFields();
		</script>
	</xsl:template>
	
	<xsl:template match="msp-form">
		<h1>MSP Integration Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<form method="post" action="/service/config/msp.html">
			<table>
				<tr>
					<td class="form">Enabled:</td>
					<td>
						<input type='hidden' name='enabled'/>
						<input type="checkbox" name="enabled">
							<xsl:if test="enabled/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="enabled/@message!=''">
						<td><xsl:value-of select="enabled/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">Relay Host:</td>
					<td>
						<input name="relayHostname" type="text">
							<xsl:attribute name="value"><xsl:value-of select="relayHostname/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="relayHostname/@message!=''">
						<td><xsl:value-of select="relayHostname/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Relay Port:</td>
					<td>
						<input type="text" name="port">
							<xsl:attribute name="value"><xsl:value-of select="port/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="port/@message!=''">
						<td><xsl:value-of select="port/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">Username:</td>
					<td>
						<input name="username" type="text">
							<xsl:attribute name="value"><xsl:value-of select="username/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="username/@message!=''">
						<td><xsl:value-of select="username/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Password:</td>
					<td>
						<input name="password" type="password">
							<xsl:attribute name="value"><xsl:value-of select="password/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="password/@message!=''">
						<td><xsl:value-of select="password/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Upload Interval [Minutes]:</td>
					<td>
						<input name="uploadInterval" type="text">
							<xsl:attribute name="value"><xsl:value-of select="uploadInterval/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="uploadInterval/@message!=''">
						<td><xsl:value-of select="uploadInterval/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Discovery Path:</td>
					<td>
						<input name="path" type="text">
							<xsl:attribute name="value"><xsl:value-of select="path/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="path/@message!=''">
						<td><xsl:value-of select="path/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
		
		</xsl:template>
			
	<xsl:template match="datetime-form">
		<script type="text/javascript">
			function updateEnabledFields() {
				if (document.getElementById('enabled').checked) {
					document.getElementById('day').disabled = true;
					document.getElementById('month').disabled = true;
					document.getElementById('year').disabled = true;
					document.getElementById('hours').disabled = true;
					document.getElementById('minutes').disabled = true;
					
					document.getElementsByName('timeServerWarning')[0].style.display = "block";
				}
				else {
					document.getElementById('day').disabled = false;
					document.getElementById('month').disabled = false;
					document.getElementById('year').disabled = false;
					document.getElementById('hours').disabled = false;
					document.getElementById('minutes').disabled = false;
					
					document.getElementsByName('timeServerWarning')[0].style.display = "none";
				}	
			}
		</script>
		<h1>Time Server and Timezone Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<h2>Time Server Settings</h2>
		
		<form method="post" action="/service/config/datetime.html">
			<table>
				<tr>
					<td class="form">Enabled:</td>
					<td>
						<input type='hidden' name='enabled'/>
						<input type="checkbox" name="enabled" id="enabled" onclick="updateEnabledFields();">
							<xsl:if test="enabled/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="enabled/@message!=''">
						<td><xsl:value-of select="enabled/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">NTP Server:</td>
					<td>
						<input name="timeServer" type="text">
							<xsl:attribute name="value"><xsl:value-of select="timeServer/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="timeServer/@message!=''">
						<td><xsl:value-of select="timeServer/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Update Interval [Minutes]:</td>
					<td>
						<input type="text" name="updateInterval">
							<xsl:attribute name="value"><xsl:value-of select="updateInterval/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="updateInterval/@message!=''">
						<td><xsl:value-of select="updateInterval/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			<h2>Time zone</h2>
			<table>
				<tr>
					<td class="form">Time zone:</td>
					<td>
						<select id="ap_timezone" name="timeZone">
							<xsl:if test="autoConfig/@value = 'true'">
								<xsl:attribute name="disabled">true</xsl:attribute>
							</xsl:if>
							<xsl:for-each select="timeZones/timeZone">
							<xsl:sort select="@rawOffset" data-type="number"/>
							
								<option>
									<xsl:if test="@value = ../../timeZone/@value">
										<xsl:attribute name="selected">true</xsl:attribute>
									</xsl:if>
									<xsl:attribute name="name"><xsl:value-of select="@offset"/>;<xsl:value-of select="@dst"/></xsl:attribute>
									<xsl:value-of select="@value"/>
								</option>
							</xsl:for-each>
						</select>
					</td>
				</tr>				
			</table>
			
			<!--<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		-->
			

			
			<h1>Manual Date/Time Settings <span><a href="/service/config/datetime.xml">(Refresh)</a></span></h1>
			
			<p id="warning" name="timeServerWarning">
				<xsl:if test="enabled/@value='false'">
					<xsl:attribute name="style">display:none</xsl:attribute>
				</xsl:if>
				Warning: Time server is enabled. In order to manually update date/time settings, disable time server first.
			</p>
			
			<h2>Date</h2>

			<table>
				<tr>
					<td class="form">Day:</td>
					<td>
						<select id="day" name="day">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="disabled">
									true
								</xsl:attribute>
							</xsl:if>
							
							<xsl:call-template name="repeatable">
								<xsl:with-param name="index" select="1"/>
								<xsl:with-param name="total" select="31"/>
								<xsl:with-param name="current" select="day/@value"/>
							</xsl:call-template>
						</select>
					</td>
					<td class="form">Month:</td>
					<td>
						<select id="month" name="month">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="disabled">
									true
								</xsl:attribute>
							</xsl:if>
							
							<xsl:call-template name="repeatable">
								<xsl:with-param name="index" select="1"/>
								<xsl:with-param name="total" select="12"/>
								<xsl:with-param name="current" select="month/@value"/>
							</xsl:call-template>						
						</select>
					</td>
					<td class="form">Year:</td>
					<td>
						<select id="year" name="year">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="disabled">
									true
								</xsl:attribute>
							</xsl:if>
							
							<xsl:call-template name="repeatable">
								<xsl:with-param name="index" select="year/@value - 40"/>
								<xsl:with-param name="total" select="year/@value + 40"/>
								<xsl:with-param name="current" select="year/@value"/>
							</xsl:call-template>						
						</select>
					</td>
					
					<xsl:if test="day/@message!=''">
						<td><xsl:value-of select="day/@message" /></td>
					</xsl:if>

				</tr>
			</table>
			<h2>Time</h2>
			<table>	
				<tr>
					<td class="form">Hours:</td>
					<td>
						<select id="hours" name="hours">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="disabled">
									true
								</xsl:attribute>
							</xsl:if>
							
							<xsl:call-template name="repeatable">
								<xsl:with-param name="index" select="0"/>
								<xsl:with-param name="total" select="23"/>
								<xsl:with-param name="current" select="hours/@value"/>
							</xsl:call-template>
						</select>
					</td>
					<td class="form">Minutes:</td>
					<td>
						<select id="minutes" name="minutes">
							<xsl:if test="autoConfig/@value='true'">
								<xsl:attribute name="disabled">
									true
								</xsl:attribute>
							</xsl:if>
							
							<xsl:call-template name="repeatable">
								<xsl:with-param name="index" select="0"/>
								<xsl:with-param name="total" select="59"/>
								<xsl:with-param name="current" select="minutes/@value"/>
							</xsl:call-template>
						</select>
					</td>					
				</tr>
			</table>
			<h2>Local Date/Time</h2>
			<table>
				<tr>
					<td class="form">Date:</td>
					<td id="localDate"></td>
				</tr>
				<tr>
					<td class="form">Time:</td>
					<td id="localTime"></td>
				</tr>
			</table>
			
			<script type="text/javascript">
				function onWindowLoad() {
					updateEnabledFields();
					var currentDate = new Date();
					var day = currentDate.getDate();
				
					if (10 > day) {
						day = "0" + day;
					}
					
					var month = currentDate.getMonth() + 1;
					
					if (10 > month) {
						month = "0" + month;
					}
					
					var year = currentDate.getFullYear();
					var hours = currentDate.getHours();
					
					if (10 > hours) {
						hours = "0" + hours;
					}
					
					var minutes = currentDate.getMinutes();
					
					if (10 > minutes) {
						minutes = "0" + minutes;
					}
					
					document.getElementById('localDate').textContent = day + "." + month + "." + year;
					document.getElementById('localTime').textContent = hours + ":" + minutes;
				}
			
				window.onload = onWindowLoad();

			</script>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save">
						<xsl:if test="autoConfig/@value='true'">
							<xsl:attribute name="disabled">
								true
							</xsl:attribute>
						</xsl:if>					
					</input>
				</div>
			</xsl:if>
			<br/>
			
				<input type="hidden" name="fixedDateTime"><xsl:attribute name="value"><xsl:value-of select="fixedDateTime/@value" /></xsl:attribute></input>
			
		</form>
	</xsl:template>
	
	<xsl:template name="repeatable">
		<xsl:param name="index"/>
		<xsl:param name="total"/>
		<xsl:param name="current"/>
			<option>
				<xsl:attribute name="name"><xsl:value-of select="$index"/></xsl:attribute>
				
				<xsl:if test="$current = $index">
					<xsl:attribute name="selected">true</xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="string-length($index) = 1">
						<xsl:attribute name="value">0<xsl:value-of select="$index"/></xsl:attribute>
						0<xsl:value-of select="$index"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$index"/></xsl:attribute>
						<xsl:value-of select="$index"/>
					</xsl:otherwise>
				</xsl:choose>
				
			</option>

		<xsl:if test="not($index = $total)">
			<xsl:call-template name="repeatable">
				<xsl:with-param name="index" select="$index + 1" />
				<xsl:with-param name="total" select="$total" />
				<xsl:with-param name="current" select="$current" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="broadcast-form">
		<h1>Discovery Broadcast Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<form method="post" action="/service/config/broadcast.html">
			<table>
				<tr>
					<td class="form">Enabled:</td>
					<td>
						<input type='hidden' name='enabled'/>
						<input type="checkbox" name="enabled">
							<xsl:if test="enabled/@value='true'">
								<xsl:attribute name="checked">checked</xsl:attribute>
								<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
							</xsl:if>
						</input>
					</td>
					<xsl:if test="enabled/@message!=''">
						<td><xsl:value-of select="enabled/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">Broadcast Port:</td>
					<td>
						<input name="broadcastPort" type="text">
							<xsl:attribute name="value"><xsl:value-of select="broadcastPort/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="broadcastPort/@message!=''">
						<td><xsl:value-of select="broadcastPort/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Broadcast Interval [Minutes]:</td>
					<td>
						<input type="text" name="broadcastIntervalInMinutes">
							<xsl:attribute name="value"><xsl:value-of select="broadcastIntervalInMinutes/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="broadcastIntervalInMinutes/@message!=''">
						<td><xsl:value-of select="broadcastIntervalInMinutes/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
			
	</xsl:template>
	
	<xsl:template match="wireless-form">
		<h1>Wireless Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<h2>Wireless Channel Selection</h2>
	
		<form method="post" action="/service/config/wireless.html">
			<table>
				<tr>
					<th colspan="2">Name</th>
					<th>Peak Frequency</th>
				</tr>
			
				<xsl:for-each select="channels/channel">
					<tr>
						<td>
							<xsl:if test="../../wirelessChannel/@value=@id">
								<xsl:attribute name="class">selected</xsl:attribute>
							</xsl:if>
							<input name="wirelessChannel" type="radio">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:if test="../../wirelessChannel/@value=@id"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
								<xsl:if test="../../autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
							</input>
						</td>
						<td class="centered">
							<xsl:if test="../../wirelessChannel/@value=@id"><xsl:attribute name="class">centered selected</xsl:attribute></xsl:if>
							ESL Channel <xsl:value-of select="@caption"/>
						</td>
						<td class="centered">
							<xsl:if test="../../wirelessChannel/@value=@id"><xsl:attribute name="class">centered selected</xsl:attribute></xsl:if>
							<xsl:value-of select="@frequency"/> MHz
						</td>
					</tr>
				</xsl:for-each>
				
				<tr>
					<td>
						<xsl:if test="wirelessChannel/@value=''">
							<xsl:attribute name="class">selected</xsl:attribute>
						</xsl:if>
						<input name="wirelessChannel" type="radio">
							<xsl:attribute name="value"></xsl:attribute>
							<xsl:if test="wirelessChannel/@value=''"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<td class="centered" colspan="2">
						<xsl:if test="wirelessChannel/@value=''"><xsl:attribute name="class">centered selected</xsl:attribute></xsl:if>
						Disable radio interface
					</td>
				</tr>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
	</xsl:template>
	
	<xsl:template match="rf-power-form">
		<h1>Output Power Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<h2>Radio Output Power Selection</h2>
	
		<form method="post" action="/service/config/outputPower.html">
			<table>
				<tr>
					<th colspan="2">Output Power</th>
				</tr>
			
				<xsl:for-each select="rf-settings/rf-setting">
					<xsl:sort select="@dbm" order="descending" data-type="number" />
					<tr>
						<td>
							<xsl:if test="../../rfPower/@value=@id">
								<xsl:attribute name="class">selected</xsl:attribute>
							</xsl:if>
							<input name="rfPower" type="radio">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:if test="../../rfPower/@value=@id"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
								<xsl:if test="../../autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
							</input>
						</td>
						<td class="centered">
							<xsl:if test="../../rfPower/@value=@id"><xsl:attribute name="class">centered selected</xsl:attribute></xsl:if>
							<xsl:value-of select="@caption"/>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
	</xsl:template>
	
	<xsl:template match="logging-form">
		<h1>Logging Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<form method="post" action="/service/config/logging.html">
			<table>
				<tr>
					<td class="form">Logging Level:</td>
					<td>
						<select name="logLevel">
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
							<xsl:for-each select="logLevels/logLevel">
								<option>
									<xsl:if test="@id=../../logLevel/@value"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
									<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
									<xsl:value-of select="@caption"/>
								</option>
							</xsl:for-each>
						</select>
					</td>
					<xsl:if test="logLevel/@message!=''">
						<td><xsl:value-of select="logLevel/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">Remote Logging Enabled:</td>
					<td>
						<input type='hidden' name='socketAppenderEnabled'/>
						<input type="checkbox" name="socketAppenderEnabled">
							<xsl:if test="socketAppenderEnabled/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="socketAppenderEnabled/@message!=''">
						<td><xsl:value-of select="socketAppenderEnabled/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Remote Logging Host:</td>
					<td>
						<input name="socketRemoteAddress" type="text">
							<xsl:attribute name="value"><xsl:value-of select="socketRemoteAddress/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="socketRemoteAddress/@message!=''">
						<td><xsl:value-of select="socketRemoteAddress/@message" /></td>
					</xsl:if>
				</tr>
			
				<tr>
					<td class="form">Remote Logging Port:</td>
					<td>
						<input name="socketPort" type="text">
							<xsl:attribute name="value"><xsl:value-of select="socketPort/@value"/></xsl:attribute>
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="socketPort/@message!=''">
						<td><xsl:value-of select="socketPort/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			
			<xsl:if test="autoConfig/@value!='true'">
				<div id="submit">
					<input type="submit" value="Save"/>
				</div>
			</xsl:if>
		</form>
			
	</xsl:template>
	
	<xsl:template match="certificate-signing-request">
		<h1>Certificate Signing Request (CSR)</h1>
		
		<pre>
			<xsl:value-of select="."/>
		</pre>
	</xsl:template>
	
	<xsl:template match="certificate">
		<h1>Certificate</h1>
		
		<h2>Details</h2>
		
		<table>
			<tr>
				<td class="form">Version:</td>
				<td><xsl:value-of select="version"/></td>
			</tr>
			<tr>
				<td class="form">Serial Number:</td>
				<td><xsl:value-of select="serialNumber"/></td>
			</tr>
			<tr>
				<td class="form">Subject DN:</td>
				<td><xsl:value-of select="subjectDN"/></td>
			</tr>
			<tr>
				<td class="form">Issuer DN:</td>
				<td><xsl:value-of select="issuerDN"/></td>
			</tr>
			<tr>
				<td class="form">Valid until:</td>
				<td><xsl:value-of select="notAfter"/></td>
			</tr>
		</table>
		
		<h2>Download</h2>
		<table>
			<tr>
				<td class="form" style="font-weight:bold;text-align:left">Certificate</td>
				<xsl:if test="@protocol='SSL'" >
					<td style="text-align:center">
						<a href="/service/config/certificate/certificate.pem">PEM</a>, 
						<a href="/service/config/certificate/certificate.der">DER</a>
					</td>
				</xsl:if>
				<xsl:if test="@protocol='TLS'" >
					<td style="text-align:center">
						<a href="/service/config/certificate/thinap/certificate.pem">PEM</a>, 
						<a href="/service/config/certificate/thinap/certificate.der">DER</a>
					</td>
				</xsl:if>
			</tr>
			<xsl:if test="@protocol='SSL'" >
				<tr>
					<td class="form" style="font-weight:bold;text-align:left">Certificate Signing Request (CSR)</td>
					<td style="text-align:center">
						<a href="/service/config/certificate/csr.pem">PEM</a>, 
						<a href="/service/config/certificate/csr.der">DER</a>
					</td>
				</tr>
			</xsl:if>
		</table>
		<xsl:if test="@protocol='SSL'" >
			<form method="post" action="generateCertificate.html">
				<div id="submit">
					<input style="margin-left:5px;" type="submit" value="Generate Self-Signed-Certificate"/>
				</div>
			</form>
		</xsl:if>
		<xsl:if test="@protocol='TLS'" >
			<form method="post" action="restoreCertificate.html">
				<div id="submit">
					<input style="margin-left:5px;" type="submit" value="Restore Default-Certificate"/>
				</div>
			</form>
		</xsl:if>
	</xsl:template>

	<xsl:template match="changePassword">
	<xsl:apply-templates select="../root"/>
		<h1>Change Password</h1>
		
		<form action="/service/config/password.html" method="POST">
			<table>
				<tr>
					<td class="form">Old Password:</td>
					<td><input type="password" name="oldPassword"/></td>
				</tr>
				<tr>
					<td class="form">New Password:</td>
					<td><input type="password" name="newPassword"/></td>
				</tr>
				<tr>
					<td class="form">Confirm New Password:</td>
					<td><input type="password" name="newPasswordConfirm"/></td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Apply"/>
			</div>
		</form>
	</xsl:template>
	
	<xsl:template match="textarea">
		<tr>
			<th><xsl:value-of select="@caption"/></th>
			<td>
				<textarea>
					<xsl:attribute name="caption"><xsl:value-of select="@caption"/></xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
					<xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
					<xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute>
					<xsl:attribute name="caption"><xsl:value-of select="@caption"/></xsl:attribute>
					<xsl:value-of select="."/>
				</textarea>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="certificate-file-upload">
		<script type="text/javascript">
			document.forms["<xsl:value-of select="../@name" />"].enctype = "multipart/form-data";
		</script>
		<input type="file" accept="multipart/form-data">
			<xsl:attribute name="id">
				<xsl:value-of select="@name" />
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name" />
			</xsl:attribute>
		</input>
		
		<input type="button">
			<xsl:attribute name="onClick">
				if(document.getElementById('<xsl:value-of select="@name" />').value == '') {
					alert("Please select a file to upload");
				}
				else {
					if(confirm('<xsl:value-of select="@question" />')) {
						if (document.getElementById("file").value.endsWith('.p12')) {
							var password = prompt('Please enter password for the certificate container:');
							
							if (password !== null) {
								document.forms["<xsl:value-of select="../@name" />"].action += "?password=" + password;
								document.forms["<xsl:value-of select="../@name" />"].submit();
							}
						}
						else {
							document.forms["<xsl:value-of select="../@name" />"].submit();
						}
					} 
				}
			</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@caption"/></xsl:attribute>
		</input>
	</xsl:template>
	
	<xsl:template match="keypair-form">
		<table>
			<xsl:apply-templates/>
		</table>
	</xsl:template>
	
	<xsl:template match="subform">
		<form>
			<xsl:attribute name="id">
				<xsl:value-of select="@name" />
			</xsl:attribute>
		
			<xsl:attribute name="action">
				<xsl:value-of select="@action" />
			</xsl:attribute>
		
			<xsl:attribute name="method">
				<xsl:value-of select="@method" />
			</xsl:attribute>
			
			<xsl:if test="@enctype != ''">
				<xsl:attribute name="enctype">
					<xsl:value-of select="@enctype" />
				</xsl:attribute>	
			</xsl:if>				
			<xsl:apply-templates/>
		</form>
	</xsl:template>
	
	<xsl:template match="serial-form">
		<h1>Serial Settings</h1>
		<h2>WiSpy Settings</h2>
	
		<form method="post" action="/service/serial/serialConfiguration.html">
			<table>
				<tr>
					<td class="form">WiSpy enabled:</td>
					<td>
						<input type='hidden' name='wiSpyEnabled'/>
						<input type="checkbox" name="wiSpyEnabled" id="wiSpyEnabled" onclick="updateEnabledFields();">
							<xsl:if test="wiSpyEnabled/@value='true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
						</input>
					</td>
					<xsl:if test="wiSpyEnabled/@message!=''">
						<td><xsl:value-of select="wiSpyEnabled/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Start frequency [Hz]:</td>
					<td>
						<input name="startFrequency" id="startFrequency" type="text">
							<xsl:attribute name="value"><xsl:value-of select="startFrequency/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="startFrequency/@message!=''">
						<td><xsl:value-of select="startFrequency/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">End frequency [Hz]:</td>
					<td>
						<input name="endFrequency" id="endFrequency" type="text">
							<xsl:attribute name="value"><xsl:value-of select="endFrequency/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="endFrequency/@message!=''">
						<td><xsl:value-of select="endFrequency/@message" /></td>
					</xsl:if>
				</tr>
				
				<tr>
					<td class="form">Number of sweeps:</td>
					<td>
						<input name="numberOfSweeps" id="numberOfSweeps" type="text">
							<xsl:attribute name="value"><xsl:value-of select="numberOfSweeps/@value"/></xsl:attribute>
						</input>
					</td>
					<xsl:if test="numberOfSweeps/@message!=''">
						<td><xsl:value-of select="numberOfSweeps/@message" /></td>
					</xsl:if>
				</tr>
			</table>
			
			<h3>Channel Filter Bandwidths</h3>
			
			<xsl:if test="channelFilterBandwidth/@message!=''">
					<p id="error"><xsl:value-of select="channelFilterBandwidth/@message" /></p>
			</xsl:if>
			
			<table>
				<tr>
					<th colspan="2">Bandwidth</th>
				</tr>
				<xsl:for-each select="ChannelFilterBandwidthList/ChannelFilterBandwidth">
					<tr>
						<td>
							<xsl:if test="../../channelFilterBandwidth/@value=@name">
								<xsl:attribute name="class">selected</xsl:attribute>
							</xsl:if>
							<input name="channelFilterBandwidth" type="radio">
								<xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
								<xsl:if test="../../channelFilterBandwidth/@value=@name"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
							</input>
						</td>
						<td class="centered">
							<xsl:if test="../../channelFilterBandwidth/@value=@name">
								<xsl:attribute name="class">selected selected</xsl:attribute>
							</xsl:if>
							Bandwidth <xsl:value-of select="@bandwidth"/> kHz
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<script type="text/javascript">
			
				function updateEnabledFields() {
					var fields = document.getElementsByName('wiSpyEnabled');
					var enabled = true;
					
					for (var j = 0; j &lt; fields.length; j++) {
						var field = fields[j];
						
						if (field.getAttribute('type') === 'checkbox') {
							enabled = field.checked;
						}
					}
					
					if (enabled) {
						document.getElementById('startFrequency').removeAttribute('disabled');
						document.getElementById('endFrequency').removeAttribute('disabled');
						document.getElementById('numberOfSweeps').removeAttribute('disabled');
						var elements = document.getElementsByName('channelFilterBandwidth');
						
						for (var i = 0; i &lt; elements.length; i++) {
							elements[i].removeAttribute('disabled');
						}
										
					}
					else {
						document.getElementById('startFrequency').setAttribute('disabled', 'true');
						document.getElementById('endFrequency').setAttribute('disabled', 'true');
						document.getElementById('numberOfSweeps').setAttribute('disabled', 'true');
						var elements = document.getElementsByName('channelFilterBandwidth');
						
						for (var i = 0; i &lt; elements.length; i++) {
							elements[i].setAttribute('disabled', 'true');
						}		
					}	
				}
				
				window.onload = updateEnabledFields();
			</script>
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	</xsl:template>
	
	<xsl:template match="lf-form">
		<h1>Low-Frequency Driver Settings</h1>
		
		<form method="post" action="lfConfig.html">
			  
			<table>
				<tr>
					<td class="form">Low-Frequency Driver Enabled:</td>
					<td>
						<input type='hidden' name='lfEnabled'/>
						<input type="checkbox" name="lfEnabled">
							<xsl:if test="enabled/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	
	</xsl:template>
	
	<xsl:template match="ssl-form">
		<h1>SSL Settings</h1>
		
		<form method="post" action="ssl.html">
			  
			<table>
				<xsl:if test="strictVerification/@value">
					<tr>
						<td class="form">Use strict verification:</td>
						<td>
							<input type='hidden' name='strictVerification'/>
							<input type="checkbox" name="strictVerification" id="strictVerification">
								<xsl:if test="strictVerification/@value='true'">
									<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
				</xsl:if>
				
				<xsl:if test="hostnameVerification/@value">
					<tr>
						<td class="form">Use hostname verification:</td>
						<td>
							<input type='hidden' name='hostnameVerification'/>
							<input type="checkbox" name="hostnameVerification" id="hostnameVerification">
								<xsl:if test="hostnameVerification/@value='true'">
									<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="form">Use client certificate verfication:</td>
					<td>
						<input type='hidden' name='verifyClientCertificates'/>
						<input type="checkbox" name="verifyClientCertificates" id="verifyClientCertificates">
							<xsl:if test="verifyClientCertificates/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	
	</xsl:template>
	
	<xsl:template match="ws-form">
		<h1>Webserver Settings</h1>
		
		<form method="post" action="webservice.html">
			<h2>Web UI</h2>	  
			<table>
					<tr>
						<td class="form">Web server on Port 80 (HTTP):</td>
						<td>
							<select name="portHttp">
	    						<option><xsl:if test="httpPortEnabled/@value='false'"><xsl:attribute name="selected"/></xsl:if>deactivated</option>
	    						<option><xsl:if test="httpPortEnabled/@value='true'"><xsl:attribute name="selected"/></xsl:if>activated</option>
	   						</select>
						</td>
					</tr>
				<tr>
					<td class="form">Web server on Port 443 (HTTPS):</td>
					<td>
						<select name="portHttps">
    						<option><xsl:if test="httpsPortEnabled/@value='false'"><xsl:attribute name="selected"/></xsl:if>deactivated</option>
    						<option><xsl:if test="httpsPortEnabled/@value='true'"><xsl:attribute name="selected"/></xsl:if>activated</option>
   						</select>
					</td>
				</tr>
				
				<tr>
					<td class="form">Web server on default port (<xsl:value-of select="defaultPort/@value"/>):</td>
					<td>
						<select name="serviceDefault">
    						<option><xsl:if test="defaultServicePortSSL/@value='ENABLED_NORMAL'"><xsl:attribute name="selected"/></xsl:if>HTTP</option>
    						<option><xsl:if test="defaultServicePortSSL/@value='ENABLED_SSL'"><xsl:attribute name="selected"/></xsl:if>HTTPS</option>
    						<option><xsl:if test="defaultServicePortSSL/@value='DISABLED'"><xsl:attribute name="selected"/></xsl:if>deactivated</option>
   						</select>
					</td>
				</tr>
			</table>
			<xsl:if test="jerseyPortSSL">
				<h2>Webservice</h2>
				<table>
					<tr>
						<td class="form">Webservice (<xsl:value-of select="jerseyPort/@value"/>):</td>
						<td>
							<select name="serviceJersey">
	    						<option><xsl:if test="jerseyPortSSL/@value='ENABLED_NORMAL'"><xsl:attribute name="selected"/></xsl:if>HTTP</option>
	    						<option><xsl:if test="jerseyPortSSL/@value='ENABLED_SSL'"><xsl:attribute name="selected"/></xsl:if>HTTPS</option>
	    						<option><xsl:if test="jerseyPortSSL/@value='DISABLED'"><xsl:attribute name="selected"/></xsl:if>deactivated</option>
	   						</select>
						</td>
					</tr>
				</table>
			</xsl:if>
			
			<xsl:if test="interfaces/@value">
				<h2>Enabled/Disabled Interfaces</h2>
				<input type='hidden' name='interfaces'><xsl:attribute name="value"><xsl:value-of select="interfaces/@value"/></xsl:attribute></input>
				
				<table>
					<tr>
						<th>Interfaces</th>
						<th></th>
					</tr>
					<xsl:for-each select="./*">
						<xsl:sort select="name(.)" />
							<xsl:if test="substring(name(.), string-length(name(.)) - string-length('_interface') +1) = '_interface'">
								<xsl:variable name="interfaceName" select="substring-before(name(.), '_interface')"/>
								<tr>
									<td><xsl:value-of select="$interfaceName"/></td>
									<td>
										<select>
											<xsl:attribute name="name"><xsl:value-of select="$interfaceName"/>_interface</xsl:attribute>
											<xsl:attribute name="id"><xsl:value-of select="$interfaceName"/>_interface</xsl:attribute>
											<option>
												<xsl:if test="./@value = 'true'">
													<xsl:attribute name="selected">true</xsl:attribute>
												</xsl:if>
											Enabled
											</option>
											<option>
												<xsl:if test="./@value = 'false'">
													<xsl:attribute name="selected">true</xsl:attribute>
												</xsl:if>
											Disabled
											</option>
										</select>
									</td>
								</tr>
							</xsl:if>
					</xsl:for-each>
				</table>
			</xsl:if>
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	
	</xsl:template>
	
		<xsl:template match="vpn-form">
		<h1>VPN Configuration</h1>
		
			<table>
			<tr>
				<th>Key</th>
				<th>Value</th>
			</tr>
			<tr>
				<td>Enabled</td>
				<td>
					<xsl:value-of select="enabled/@value" />
				</td>
			</tr>
			<tr>
				<td>Device</td>
				<td>
					<xsl:value-of select="dev/@value" />
				</td>
			</tr>
			<tr>
				<td>Protocol</td>
				<td>
					<xsl:value-of select="proto/@value" />
				</td>
			</tr>
			<tr>
				<td>Log Level</td>
				<td>
					<xsl:value-of select="verb/@value" />
				</td>
			</tr>
			<tr>
				<td>Remote Address</td>
				<td>
					<xsl:value-of select="remoteaddress/@value" />
				</td>
			</tr>
			<tr>
				<td>Remote Port</td>
				<td>
					<xsl:value-of select="remoteport/@value" />
				</td>
			</tr>
			<tr>
				<td>CA</td>
				<td>
					<xsl:value-of select="ca/@value" />
				</td>
			</tr>
			<tr>
				<td>Certificate</td>
				<td>
					<xsl:value-of select="cert/@value" />
				</td>
			</tr>
			<tr>
				<td>Key</td>
				<td>
					<xsl:value-of select="key/@value" />
				</td>
			</tr>
			<tr>
				<td>Additional Options</td>
				<td>
					<xsl:value-of select="additionaloptions/@value" />
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="certificate-properties">
		<h1>Generate CSR/Certificate</h1>

		<form id="cert-form" method="post" action="csr.pem">
			  
			<table>
				<tr>
					<td class="form">Country (C):</td>
					<td>
						<input name="c" type="text">
							<xsl:attribute name="value"><xsl:value-of select="@c" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">Common Name (CN):</td>
					<td>
						<input name="cn" type="text">
							<xsl:attribute name="value"><xsl:value-of select="./@cn" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">Organization (O):</td>
					<td>
						<input name="o" type="text">
							<xsl:attribute name="value"><xsl:value-of select="./@o" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">Organizational Unit (OU):</td>
					<td>
						<input name="ou" type="text">
							<xsl:attribute name="value"><xsl:value-of select="./@ou" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">Locality (L):</td>
					<td>
						<input name="l" type="text">
							<xsl:attribute name="value"><xsl:value-of select="./@l" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">State (ST):</td>
					<td>
						<input name="st" type="text">
							<xsl:attribute name="value"><xsl:value-of select="./@st" /></xsl:attribute>
						</input>
					</td>
				</tr>
				
				<tr>
					<td class="form">Certificate valid for [years]:</td>
					<td>
					<select name="valid">
    						<option><xsl:if test="./@valid = '1'"><xsl:attribute name="selected"/></xsl:if>1</option>
    						<option><xsl:if test="./@valid = '2'"><xsl:attribute name="selected"/></xsl:if>2</option>
    						<option><xsl:if test="./@valid = '3'"><xsl:attribute name="selected"/></xsl:if>3</option>
    						<option><xsl:if test="./@valid = '4'"><xsl:attribute name="selected"/></xsl:if>4</option>
    						<option><xsl:if test="./@valid = '5'"><xsl:attribute name="selected"/></xsl:if>5</option>
    						<option><xsl:if test="./@valid = '6'"><xsl:attribute name="selected"/></xsl:if>6</option>
    						<option><xsl:if test="./@valid = '7'"><xsl:attribute name="selected"/></xsl:if>7</option>
    						<option><xsl:if test="./@valid = '8'"><xsl:attribute name="selected"/></xsl:if>8</option>
    						<option><xsl:if test="./@valid = '9'"><xsl:attribute name="selected"/></xsl:if>9</option>
    						<option><xsl:if test="./@valid = '10'"><xsl:attribute name="selected"/></xsl:if>10</option>
    						<option><xsl:if test="./@valid = '11'"><xsl:attribute name="selected"/></xsl:if>11</option>
    						<option><xsl:if test="./@valid = '12'"><xsl:attribute name="selected"/></xsl:if>12</option>
    						<option><xsl:if test="./@valid = '13'"><xsl:attribute name="selected"/></xsl:if>13</option>
    						<option><xsl:if test="./@valid = '14'"><xsl:attribute name="selected"/></xsl:if>14</option>
    						<option><xsl:if test="./@valid = '15'"><xsl:attribute name="selected"/></xsl:if>15</option>
    						<option><xsl:if test="./@valid = '16'"><xsl:attribute name="selected"/></xsl:if>16</option>
    						<option><xsl:if test="./@valid = '17'"><xsl:attribute name="selected"/></xsl:if>17</option>
    						<option><xsl:if test="./@valid = '18'"><xsl:attribute name="selected"/></xsl:if>18</option>
    						<option><xsl:if test="./@valid = '19'"><xsl:attribute name="selected"/></xsl:if>19</option>
    						<option><xsl:if test="./@valid = '20'"><xsl:attribute name="selected"/></xsl:if>20</option>
   						</select>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Generate CSR"/>
				<input style="margin-left:5px;" type="submit" value="Generate Self-Signed-Certificate" onclick="document.getElementById('cert-form').setAttribute('action', 'generateCertificate.html')"/>
			</div>
		</form>
	
	</xsl:template>
	 
	<xsl:template match="header">
		<h1><xsl:value-of select="."/></h1>
	</xsl:template>
	
	<xsl:template match="truststore-form">
		<h1>Truststore Settings</h1>
		
		<xsl:if test="autoConfig/@value='true'">
			<p id="warning">Warning: Centralized configuration is enabled. It must be disabled first to change these settings.</p>
		</xsl:if>
		
		<form id="truststore-form" method="post" action="/service/config/truststore.html">
		
			<table>
				<tr>
					<td class="form">Use default truststore:</td>
					
					<td>
						<input type='hidden' name='useDefaultTrustStore'/>
						<input type="checkbox" name="useDefaultTrustStore" id="useDefaultTrustStore">
							<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
							<xsl:if test="useDefaultTrustStore/@value='true'">
								<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save">
					<xsl:if test="autoConfig/@value='true'"><xsl:attribute name="disabled">disabled</xsl:attribute></xsl:if>
				</input>
			</div>
		</form>
		
		<xsl:if test="useDefaultTrustStore/@value='false' and not(autoConfig/@value='true')">
			<h2>Upload Trusted Certificate</h2>
			<xsl:apply-templates select="document('../admin/uploadTrustedCertificate.xml')/root/forms"/>
		</xsl:if>
		
		<xsl:apply-templates />
	
	</xsl:template>
	
	<xsl:template match="trusted-certificates">
		<h2>Trusted Certificates</h2>
		
		<xsl:if test="count(./certificate) = 0">
			<p>No trusted certificates found</p>
		</xsl:if>
		
		<xsl:if test="count(./certificate) != 0">
			<table>
				<tr>
					<th>Alias</th>
					<th>Subject</th>
					<th>Issuer</th>
					<th>Not valid before</th>
					<th>Not valid after</th>
					<th>Action</th>
				</tr>
				<xsl:for-each select="certificate">
					<tr>
						<td>
							<xsl:value-of select="@alias" />
						</td>
						<td>
							<xsl:value-of select="./subject" />
						</td>
						<td>
							<xsl:value-of select="./issuer" />
						</td>
						<td>
							<xsl:value-of select="@not-before" />
						</td>
						<td>
							<xsl:value-of select="@not-after" />
						</td>
						
						<td>
							<xsl:if test="@alias != 'imagotag'">
								<form method="post" action="certificate/deleteTrustedCertificate.html">
									<xsl:attribute name="id">form_<xsl:value-of select="@alias"/></xsl:attribute>
									<input type="hidden" name="alias" id="alias">
										<xsl:attribute name="value"><xsl:value-of select="@alias"/></xsl:attribute>
										<xsl:value-of select="@alias"/>
									</input>
									<input type="button">
										<xsl:attribute name="onClick">
											if(confirm('Do you really want to delete this certificate?')) document.forms["form_<xsl:value-of select="@alias" />"].submit(); 
										</xsl:attribute>
										<xsl:attribute name="value">Delete</xsl:attribute>
									</input>
								</form>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
	
	</xsl:template>
	
	<xsl:template match="service-level-form">
		<h1>Integration Level Settings</h1>
		<form method="post" action="/service/config/servicelevel.html">
			<table>
				<tr>
					<td class="form">Integration Level:</td>
					<td>
						<select id="serviceLevel" name="serviceLevel">
							<option>
								<xsl:if test="serviceLevel/@value='1'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Level 1
							</option>
							<option>
								<xsl:if test="serviceLevel/@value='2'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Level 2
							</option>
							<option>
								<xsl:if test="serviceLevel/@value='3'">
									<xsl:attribute name="selected">true</xsl:attribute>
								</xsl:if>
								Level 3
							</option>
						</select>
					</td>
				</tr>
			</table>
			
			<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>
	</xsl:template>
	
	<xsl:template match="provisioning-form">
		<h1>Provisioning Settings</h1>		
		<form action="/service/config/provisioning.html" method="GET">
			<table>
				<tr>
					<td class="form">Provisioning:</td>
					<td>
						<select name="enabled">
						    <option value="true">
						    	<xsl:if test="./@enabled = 'true'">
						    		<xsl:attribute name="selected">true</xsl:attribute>
						    	</xsl:if>
						    Enabled</option>
						    <option value="false">
						    	<xsl:if test="./@enabled = 'false'">
						    		<xsl:attribute name="selected">true</xsl:attribute>
						    	</xsl:if>
						    Disabled</option>
	 					</select>
					</td>					 
				</tr>
			</table>
			<br />
	 		<div id="submit">
				<input type="submit" value="Save"/>
			</div>
		</form>		
	</xsl:template>
	
 <xsl:template name="tmpSplitString">
	<xsl:param name="stringtosplit" />
	<xsl:variable name="first" select="substring-before($stringtosplit, '#newline')" />
	<xsl:variable name="remaining" select="substring-after($stringtosplit, '#newline')" />
	<xsl:value-of select="$first" />
	<xsl:if test="$remaining">
    	<br/>
		<xsl:call-template name="tmpSplitString">
			<xsl:with-param name="stringtosplit" select="$remaining" />
		</xsl:call-template>
	</xsl:if>
</xsl:template>
  
</xsl:stylesheet>
