<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xalan/java" exclude-result-prefixes="java" version="1.0">

<xsl:template match="Record">
<xsl:variable name="color">
	<xsl:choose>
		<xsl:when test="Label/DisplayColors = 'BLACK_WHITE_YELLOW'">yellow</xsl:when>
		<xsl:otherwise>red</xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<xsl:choose>

<!-- 
============================
Render image for CD-Label
============================
-->
<xsl:when test="Label/DisplayWidth = 256 and Label/DisplayHeight = 1 and starts-with(Label/Id, 'F2FF')">
	<image width="256" height="1">
		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 3, 1)"/>
			<xsl:with-param name="offset" select="1"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 4, 1)"/>
			<xsl:with-param name="offset" select="2"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 5, 1)"/>
			<xsl:with-param name="offset" select="3"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 6, 1)"/>
			<xsl:with-param name="offset" select="4"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 7, 1)"/>
			<xsl:with-param name="offset" select="5"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 8, 1)"/>
			<xsl:with-param name="offset" select="6"/>
		</xsl:call-template>
		
		<!-- Show star on registration page -->
		<xsl:if test="LabelInfo/RegistrationCode">
			<rect x="116" y="0" width="1" height="1" color="black"/>
		</xsl:if>
	</image>
</xsl:when>

<!-- 
=================================
Render image for S-tag 256
=================================
-->
<xsl:when test="Label/DisplayWidth = 256 and Label/DisplayHeight = 1">
	<image width="256" height="1">
		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 1, 1)"/>
			<xsl:with-param name="offset" select="10"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 2, 1)"/>
			<xsl:with-param name="offset" select="11"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 3, 1)"/>
			<xsl:with-param name="offset" select="12"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 4, 1)"/>
			<xsl:with-param name="offset" select="13"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 5, 1)"/>
			<xsl:with-param name="offset" select="14"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 6, 1)"/>
			<xsl:with-param name="offset" select="15"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 7, 1)"/>
			<xsl:with-param name="offset" select="16"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="substring(Label/Id, 8, 1)"/>
			<xsl:with-param name="offset" select="17"/>
		</xsl:call-template>
		
		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="'-'"/>
			<xsl:with-param name="offset" select="18"/>
		</xsl:call-template>

		<xsl:call-template name="digit">
			<xsl:with-param name="D1" select="LabelInfo/Checksum"/>
			<xsl:with-param name="offset" select="19"/>
		</xsl:call-template>
		
		<!-- PASS -->
		<xsl:if test="LabelInfo/RegistrationCode">
			
			<xsl:call-template name="digit">
				<xsl:with-param name="D1" select="'P'"/>
				<xsl:with-param name="offset" select="2"/>
			</xsl:call-template>
			<xsl:call-template name="digit">
				<xsl:with-param name="D1" select="'A'"/>
				<xsl:with-param name="offset" select="3"/>
			</xsl:call-template>
			<xsl:call-template name="digit">
				<xsl:with-param name="D1" select="'S'"/>
				<xsl:with-param name="offset" select="4"/>
			</xsl:call-template>
			<xsl:call-template name="digit">
				<xsl:with-param name="D1" select="'S'"/>
				<xsl:with-param name="offset" select="5"/>
			</xsl:call-template>
		</xsl:if>
	</image>
</xsl:when>

<!-- 
=================================
Render image for 1.6 inch display
=================================
-->
<xsl:when test="Label/DisplayWidth = 152 and Label/DisplayHeight = 152">
	<image width="152" height="152">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
		
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!--<rect x="0" y="0" width="152" height="152" border="4" color="white"/>-->
				
				<!-- imagotag CI brackets -->
				<line x-from="16" x-to="22" y-from="26" y-to="26" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				<line x-from="16" x-to="16" y-from="26" y-to="119" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="16" x-to="22" y-from="119" y-to="119" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				<line x-from="130" x-to="136" y-from="26" y-to="26" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="136" x-to="136" y-from="26" y-to="119" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="130" x-to="136" y-from="119" y-to="119" thickness="4">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="31" width="152" height="64" align="center">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="102" width="152" height="32">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="5" y="130" width="140" height="17" align="left">
					<text font-family="Verdana" font-size="13" font-weight="bold">
						<xsl:value-of select="Label/Id"/>
					</text>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="60" height="27" width="152" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="90" height="15" width="152">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>

		<!-- SES-imagotag -->
		<field x="2" y="4" height="13" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				SES-imagotag
			</label>
		</field>

		<!-- Label type as text -->
		<field x="5" y="4" height="13" width="145">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>

	</image>
</xsl:when>



<!-- 
=================================
Render image for 2.0 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 200 and Label/DisplayHeight = 96">
	<image width="200" height="96">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!--<rect x="0" y="0" width="200" height="96" border="4" color="white"/>-->
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="0" width="200" height="96" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="120" width="264" height="32">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="0" y="82" width="200" height="8" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="32" height="27" width="200" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="62" height="15" width="200">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>

		<!-- SES-imagotag -->
		<field x="5" y="4" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				SES-imagotag
			</label>
		</field>

		<!-- Label type as text -->
		<field x="5" y="4" height="14" width="190">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>

	</image>
</xsl:when>



<!-- 
=================================
Render image for 2.2 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 212 and Label/DisplayHeight = 104">
	<image width="212" height="104">
		
		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>
		
		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="212" height="104" border="4" color="white"/> -->
				
				<field x="85" y="10" width="120" height="70">
				
					<!-- SES-imagotag -->
					<label font-family="Verdana" font-weight="bold" font-size="10">
						<xsl:attribute name="color">
							<xsl:value-of select="$color"/>
						</xsl:attribute>
						<span>SES-imagotag</span>
					</label>

					<!-- Label type as text -->
					<xsl:choose>
					 	<!-- Bossard explicit -->
						<xsl:when test="starts-with(Label/Id, 'A4')">
							<text font-family="Verdana" font-weight="bold" font-size="10">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="Label/LabelType"/>
							</text>
						</xsl:when>
						<xsl:when test="LabelInfo/Type">
							<label font-family="Verdana" font-weight="bold" font-size="10" padding-bottom="10">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="LabelInfo/Type"/>
							</label>
						</xsl:when>
						<xsl:otherwise>
							<label font-family="Verdana" font-weight="bold" font-size="10" padding-bottom="10">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="Label/LabelType"/>
							</label>
						</xsl:otherwise>
					</xsl:choose>
					

					<!-- Label ID as text -->
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>

					<!-- Registration code as text -->
					<label font-family="Verdana">
						<span font-size="13" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Registration code as 2D barcode -->
				<field x="10" y="10" width="70" height="70" align="left" valign="top">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<xsl:if test="not (starts-with(Label/Id, 'A4'))">
					<line x-from="0" y-from="80" x-to="212" y-to="80" color="black"/>
				</xsl:if>
				
				<!-- Registration code as 1D barcode -->
				<xsl:if test=" not (starts-with(Label/Id, 'A4'))">
					<field x="0" y="86" width="212" height="12" align="center">
						<barcode humanReadableEnabled="false" type="code128">
							<xsl:value-of select="LabelInfo/RegistrationCode"/>
						</barcode>
					</field>
				</xsl:if>
				
			</xsl:when>
			<xsl:otherwise>

				<!-- SES-imagotag -->
				<field x="5" y="4" height="14" width="85">
					<label font-family="Verdana" font-weight="bold" font-size="10">
						<xsl:attribute name="color">
							<xsl:value-of select="$color"/>
						</xsl:attribute>
						SES-imagotag
					</label>
				</field>
		
				<!-- Label type as text -->
				<field x="75" y="4" height="24" width="132">
					<xsl:choose>
						<xsl:when test="starts-with(Label/Id, 'A4')">
							<text font-family="Verdana" font-weight="bold" font-size="10" align="right">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="Label/LabelType"/>
							</text>
						</xsl:when>
						<xsl:when test="LabelInfo/Type">
							<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="LabelInfo/Type"/>
							</label>
						</xsl:when>
						<xsl:otherwise>
							<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
								<xsl:attribute name="color">
									<xsl:value-of select="$color"/>
								</xsl:attribute>
								<xsl:value-of select="Label/LabelType"/>
							</label>
						</xsl:otherwise>
					</xsl:choose>
				</field>
				
				<!-- Label ID as barcode -->
				<field x="0" y="32" width="212" height="27" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="62" width="212" height="15">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>
		
	</image>
</xsl:when>



<!-- 
===========================
Render image for G-tag 6 HF
===========================
-->

<xsl:when test="Label/DisplayWidth = 256 and Label/DisplayHeight = 128">
	<image width="256" height="128">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<!--
				<line x-from="30" x-to="38" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="30" x-to="30" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="30" x-to="38" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="234" x-to="226" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="234" x-to="234" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="234" x-to="226" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				-->
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="20" width="256" height="60" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="80" width="256" height="18">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="5" y="110" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="54" y="112" width="196" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="45" height="27" width="256" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="75" height="15" width="256">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="5" y="4" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="5" y="4" height="14" width="246">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>

	</image>
</xsl:when>



<!-- 
====================================
Render image for Billa Refurbishment
====================================
-->

<xsl:when test="starts-with(Label/Id, 'B2')">
	<image width="264" height="176">

		<!-- Border to detect display breakage -->
		<rect x="0" y="0" width="264" height="176" border="8" color="white"/>
		
		<!-- Label ID as 1D barcode -->
		<field x="0" y="60" height="45" width="264" align="center">
			<barcode humanReadableEnabled="false" type="code128">
				<xsl:value-of select="Label/Id"/>
			</barcode>
		</field>
		
		<!-- Label ID as text -->
		<field x="0" y="110" height="15" width="264">
			<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
				<xsl:value-of select="Label/Id"/>
			</label>
		</field>
		
		<!-- imagotag -->
		<field x="8" y="8" height="14" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				BILLA
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="124" y="8" height="50" width="132" align="right">
			<!--
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			-->
			<label font-family="Verdana" font-size="10" align="right">
				Bestpreis 2.7
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 2.7 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 264 and Label/DisplayHeight = 176">
	<xsl:choose>
	
		<!-- Special handling for LANCOM OEM versions -->
		<xsl:when test="LabelInfo/Type = 'LANCOM WDG-2 2.7'">
		
			<image width="264" height="176" colors="false">
				
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<!--<rect x="0" y="0" width="480" height="800" border="8" color="white"/>-->
	
						<!-- Registration code as 2D barcode -->
						<field x="10" y="85" width="244" height="42" align="center" valign="top">
							<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="10" y="45" width="244" height="34" align="center" valign="bottom">
							<label font-family="Tahoma" align="center">
								<span font-size="11">Registration code</span>
							</label>
							<label font-family="Tahoma" align="center">
								<span font-size="13" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="10" y="154" width="244" height="12" align="center" valign="bottom">
							<label font-family="Tahoma" font-size="22">
								<span font-size="11">Label ID </span><span font-size="11" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="10" y="128" width="244" height="8" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="10" y="106" width="244" height="30" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="10" y="74" width="244" height="20" align="center" valign="center">
							<label font-family="Tahoma" align="center" font-size="30">
								<span font-size="18">Label ID </span><span font-size="18" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- LANCOM -->
				<field x="8" y="8" height="38" width="138">
					<img autoscale="false" data="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"/>
				</field>
				
				
				<!-- Label type as text -->
				<field x="104" y="8" width="144" height="12">
					<label font-family="Tahoma" font-weight="bold" font-size="10" align="right" padding-top="-2">
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Tahoma" font-size="8" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>
				
			</image>
		</xsl:when>
	
		<xsl:otherwise>
			<image width="264" height="176">
		
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
		
				<!-- Set orientation -->
				<xsl:if test="LabelInfo/Orientation != ''">
					<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						
						<!-- Border to detect display breakage -->
						<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->
		
						<!-- imagotag CI brackets -->
						<line x-from="30" x-to="38" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="30" x-to="30" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="30" x-to="38" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="234" x-to="226" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="234" x-to="234" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="234" x-to="226" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						
						<!-- Registration code as 2D barcode -->
						<field x="0" y="42" width="264" height="80" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="0" y="120" width="264" height="32">
							<label font-family="Verdana" align="center" >
								<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="8" y="158" height="15" width="70">
							<label font-family="Verdana" font-size="10" font-weight="normal">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="54" y="160" width="200" height="9" align="right">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
						<!-- Label ID as 1D barcode -->
						<field x="0" y="60" height="45" width="264" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="0" y="110" height="15" width="264">
							<label font-family="Verdana" font-weight="bold" font-size="12" align="center" >
								<xsl:value-of select="Label/Id" />
							</label>
						</field>
						
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- SES-imagotag -->
				<field x="8" y="8" height="14" width="85">
					<label font-family="Verdana" font-weight="bold" font-size="10" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						SES-imagotag
					</label>
				</field>
				
				<!-- Label type as text -->
				<field x="124" y="8" height="50" width="132" align="right">
					<label font-family="Verdana" font-weight="bold" font-size="10" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>&#160;<xsl:value-of select="LabelInfo/Edition"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>&#160;<xsl:value-of select="LabelInfo/Edition"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
				</field>
				
			</image>
		</xsl:otherwise>
	</xsl:choose>
</xsl:when>



<!-- 
=================================
Render image for 2.6 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 296 and Label/DisplayHeight = 152">
	<image width="296" height="152">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="30" x-to="38" y-from="29" y-to="29" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="30" x-to="30" y-from="29" y-to="122" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="30" x-to="38" y-from="122" y-to="122" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="264" x-to="256" y-from="29" y-to="29" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="264" x-to="264" y-from="29" y-to="122" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="264" x-to="256" y-from="122" y-to="122" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="26" width="296" height="80" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="104" width="296" height="32">
					<label font-family="Verdana" align="center" >
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="8" y="137" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="86" y="138" width="200" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as 1D barcode -->
				<field x="0" y="60" height="45" width="296" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="110" height="15" width="296">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center" >
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="4" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="154" y="4" height="50" width="132" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 2.9 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 296 and Label/DisplayHeight = 128">
	<image width="296" height="128">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="55" x-to="58" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="50" x-to="50" y-from="35" y-to="93" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="50" x-to="58" y-from="93" y-to="93" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="246" x-to="238" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="246" x-to="246" y-from="35" y-to="93" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="246" x-to="238" y-from="93" y-to="93" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="20" width="296" height="80" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="82" width="296" height="20">
					<label font-family="Verdana" align="center" >
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="8" y="108" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="88" y="108" width="200" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as 1D barcode -->
				<field x="0" y="40" height="45" width="296" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="90" height="15" width="296">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center" >
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="156" y="8" height="50" width="132" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 4.4 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 400 and Label/DisplayHeight = 300">
	<xsl:choose>
	
		<!-- Special handling for LANCOM OEM versions -->
		<xsl:when test="LabelInfo/Type = 'LANCOM WDG-2 4.2'">
		
			<image width="400" height="300" colors="false">

				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
	
						<!-- Registration code as 2D barcode -->
						<field x="15" y="130" width="370" height="63" align="center" valign="top">
							<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="15" y="72" width="370" height="48" align="center" valign="center">
							<label font-family="Tahoma" align="center">
								<span font-size="16">Registration code</span>
							</label>
							<label padding-top="4" font-family="Tahoma" align="center">
								<span font-size="18" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="270" width="370" height="20" align="center" valign="bottom">
							<label font-family="Tahoma">
								<span font-size="16">Label ID </span><span font-size="16" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="15" y="220" width="370" height="12" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="15" y="160" width="370" height="34" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="125" width="370" height="24" align="center" valign="center">
							<label font-family="Tahoma" align="center" font-size="30">
								<span font-size="18">Label ID </span><span font-size="18" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- LANCOM -->
				<field x="15" y="15" height="38" width="138">
					<img autoscale="false" data="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"/>
				</field>
				
				<!-- Label type as text -->
				<field x="200" y="15" width="180" height="20">
					<label font-family="Tahoma" font-weight="bold" font-size="13" align="right" padding-top="-4">
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Tahoma" font-size="11" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>
				
			</image>
		</xsl:when>
	
		<xsl:otherwise>
			<image width="400" height="300">
		
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
		
				<!-- Set orientation -->
				<xsl:if test="LabelInfo/Orientation != ''">
					<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
	
						<!-- Border to detect display breakage -->
						<!-- <rect x="0" y="0" width="400" height="300" border="8" color="white"/> -->
		
						<!-- imagotag CI brackets -->
						<line x-from="50" x-to="60" y-from="65" y-to="65" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<line x-from="50" x-to="50" y-from="65" y-to="235" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<line x-from="50" x-to="60" y-from="235" y-to="235" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<line x-from="350" x-to="340" y-from="65" y-to="65" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<line x-from="350" x-to="350" y-from="65" y-to="235" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<line x-from="350" x-to="340" y-from="235" y-to="235" thickness="6">
							<xsl:attribute name="color">
								<xsl:value-of select="$color"/>
							</xsl:attribute>
						</line>
						
						<!-- Registration code as 2D barcode -->
						<field x="0" y="90" height="100" width="400" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="qr" scale="4">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="0" y="200" height="20" width="400">
							<label font-family="Verdana" font-weight="bold" font-size="16" align="center">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="10" y="276" height="15" width="100">
							<label font-family="Verdana" font-weight="bold" font-size="12">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="100" y="276" height="12" width="290" align="right">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
						
						<!-- Label ID as barcode -->
						<field x="0" y="120" height="45" width="400" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="0" y="170" height="20" width="400">
							<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- SES-imagotag -->
				<field x="8" y="8" height="15" width="100">
					<label font-family="Verdana" font-weight="bold" font-size="12">
						<xsl:attribute name="color">
							<xsl:value-of select="$color"/>
						</xsl:attribute>
						SES-imagotag
					</label>
				</field>
				
				<!-- Label type as text -->
				<field x="210" y="10" height="30" width="180">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="right">
						<xsl:attribute name="color">
							<xsl:value-of select="$color"/>
						</xsl:attribute>
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<label font-family="Verdana" font-size="10" align="right">
						<xsl:value-of select="LabelInfo/Edition"/>
					</label>
				</field>
				
			</image>
		</xsl:otherwise>
		
	</xsl:choose>
</xsl:when>


<!-- 
=================================
Render image for 4.5 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 480 and Label/DisplayHeight = 176">

	<image width="480" height="176">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="138" x-to="146" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="138" x-to="138" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="138" x-to="146" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="334" x-to="342" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="342" x-to="342" y-from="35" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="334" x-to="342" y-from="141" y-to="141" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="42" width="480" height="80" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="120" width="480" height="32">
					<label font-family="Verdana" align="center" >
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="8" y="158" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="272" y="160" width="200" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as 1D barcode -->
				<field x="0" y="60" height="45" width="480" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="110" height="15" width="480">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center" >
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="322" y="8" height="50" width="150" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
		
	</image>
</xsl:when>

<!-- 
=================================
Render image for 6.0 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 600 and Label/DisplayHeight = 448">

	<image width="600" height="448">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="138" x-to="148" y-from="130" y-to="130" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="138" x-to="138" y-from="130" y-to="320" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="138" x-to="148" y-from="320" y-to="320" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="452" x-to="462" y-from="130" y-to="130" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="462" x-to="462" y-from="130" y-to="320" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="452" x-to="462" y-from="320" y-to="320" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="160" width="600" height="120" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="5" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="279" width="600" height="32">
					<label font-family="Verdana" align="center" >
						<span font-size="14" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="8" y="423" height="18" width="80">
					<label font-family="Verdana" font-size="12" font-weight="bold">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="392" y="423" width="200" height="12" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as 1D barcode -->
				<field x="0" y="196" width="600" height="45" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="246" height="20" width="600">
					<label font-family="Verdana" font-weight="bold" font-size="14" align="center" >
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="20" width="115">
			<label font-family="Verdana" font-weight="bold" font-size="14" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="342" y="8" height="50" width="250" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="14" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 7.4 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 480 and Label/DisplayHeight = 800">
	<xsl:choose>
		
		<!-- Special handling for prototype 6.6 versions -->
		<xsl:when test="LabelInfo/Type = 'Prototype 6.6'">
		
			<image width="800" height="480" colors="false" rotation="90">
				<!-- <line x-from="0" x-to="800" y-from="240" y-to="240"/> -->
				
				<field width="800" height="240" x="0" y="240">
				
					<!-- Label ID as barcode -->
					<field x="0" y="90" width="800" height="45" align="center">
						<barcode humanReadableEnabled="false" type="code128">
							<xsl:value-of select="Label/Id"/>
						</barcode>
					</field>
					
					<!-- Label ID as text -->
					<field x="0" y="140" width="800" height="15">
						<label font-family="Verdana" font-weight="bold" align="center" font-size="12">
							<xsl:value-of select="Label/Id"/>
						</label>
					</field>
					
					<!-- SES-imagotag -->
					<field x="15" y="15" height="25" width="200">
						<label font-family="Verdana" font-weight="bold" font-size="18">
							SES-imagotag
						</label>
					</field>
					
					<!-- Label type as text -->
					<field x="605" y="15" width="180" height="50">
						<label font-family="Verdana" font-weight="bold" font-size="18" align="right">
							<xsl:choose>
								<xsl:when test="LabelInfo/Type">
									<xsl:value-of select="LabelInfo/Type"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Label/LabelType"/>
								</xsl:otherwise>
							</xsl:choose>
						</label>
						<xsl:if test="LabelInfo/Edition">
							<label font-family="Verdana" font-size="12" align="right" padding-top="2">
								<xsl:value-of select="LabelInfo/Edition"/>
							</label>
						</xsl:if>
					</field>
				</field>
			</image>
			
		</xsl:when>

		<!-- Special handling for LANCOM OEM versions -->
		<xsl:when test="LabelInfo/Type = 'LANCOM WDG-2 7.4'">
		
			<image width="800" height="480" colors="false" rotation="90">

				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<!--<rect x="0" y="0" width="480" height="800" border="8" color="white"/>-->

						<!-- Registration code as 2D barcode -->
						<field x="15" y="210" width="770" height="150" align="center" valign="top">
							<barcode humanReadableEnabled="false" type="qr" scale="5" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="15" y="130" width="770" height="75" align="center" valign="center">
							<label font-family="Tahoma" align="center">
								<span font-size="20">Registration code</span>
							</label>
							<label font-family="Tahoma" align="center">
								<span font-size="30" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="425" width="770" height="40" align="center" valign="bottom">
							<label font-family="Tahoma" font-size="22">
								<span font-size="22">Label ID </span><span font-size="22" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="15" y="355" width="770" height="20" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="15" y="240" width="770" height="50" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="180" width="770" height="60" align="center" valign="center">
							<label font-family="Tahoma" align="center" font-size="30">
								<span font-size="30">Label ID </span><span font-size="30" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- LANCOM -->
				<field x="20" y="20" height="55" width="200">
					<img data="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"/>
				</field>
				
				<!-- Label type as text -->
				<field x="600" y="20" width="180" height="30">
					<label font-family="Tahoma" font-weight="bold" font-size="18" align="right">
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Tahoma" font-size="12" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>
				
			</image>
		</xsl:when>
		
		<xsl:otherwise>
			<image width="480" height="800">
				
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
		
				<!-- Set orientation -->
				<xsl:if test="LabelInfo/Orientation != ''">
					<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<!--<rect x="0" y="0" width="480" height="800" border="8" color="white"/>-->

						<!-- imagotag CI brackets -->
						<line x-from="60" x-to="75" y-from="200" y-to="200" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="60" x-to="60" y-from="200" y-to="600" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="60" x-to="75" y-from="600" y-to="600" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="420" x-to="405" y-from="200" y-to="200" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="420" x-to="420" y-from="200" y-to="600" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="420" x-to="405" y-from="600" y-to="600" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						
						<!-- Registration code as 2D barcode -->
						<field x="0" y="200" width="480" height="400" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="qr" scale="5" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="0" y="460" width="480" height="32">
							<label font-family="Verdana" align="center" >
								<span font-size="16" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="770" height="25" width="200">
							<label font-family="Verdana" font-size="14" font-weight="bold">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="65" y="770" width="400" height="16" align="right">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="0" y="380" width="480" height="45" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="0" y="430" width="480" height="15">
							<label font-family="Verdana" font-weight="bold" align="center" font-size="12" >
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- SES-imagotag -->
				<field x="15" y="15" height="25" width="200">
					<label font-family="Verdana" font-weight="bold" font-size="18" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						SES-imagotag
					</label>
				</field>
				
				<!-- Label type as text -->
				<field x="220" y="15" width="245" height="30">
					<label font-family="Verdana" font-weight="bold" font-size="18" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Verdana" font-size="12" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>

			</image>
		</xsl:otherwise>
	</xsl:choose>
</xsl:when>



<!-- 
==================================
Render image for 10.2 inch display
==================================
-->

<xsl:when test="Label/DisplayWidth = 1024 and Label/DisplayHeight = 1280">
	<image width="1024" height="1280">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">

				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="1024" height="1280" border="8" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="200" x-to="220" y-from="440" y-to="440" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="200" x-to="200" y-from="440" y-to="840" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="200" x-to="220" y-from="840" y-to="840" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="824" x-to="804" y-from="440" y-to="440" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="824" x-to="824" y-from="440" y-to="840" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="824" x-to="804" y-from="840" y-to="840" thickness="16"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="500" width="1024" height="250" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="10" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="750" width="1024" height="44">
					<label font-family="Verdana" align="center">
						<span font-size="30" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="15" y="1246" height="28" width="200">
					<label font-family="Verdana" font-size="20" font-weight="bold">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="609" y="1246" width="400" height="20" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as barcode -->
				<field x="0" y="520" width="1024" height="110" align="center">
					<barcode humanReadableEnabled="false" type="code128" scale="3">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="640" width="1024" height="44">
					<label font-family="Verdana" font-weight="bold" align="center" font-size="32">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="15" y="15" height="44" width="285">
			<label font-family="Verdana" font-weight="bold" font-size="36">
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="609" y="15" width="400" height="80">
			<label font-family="Verdana" font-weight="bold" font-size="36" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			<xsl:if test="LabelInfo/Edition">
				<label font-family="Verdana" font-size="12" align="right">
					<xsl:value-of select="LabelInfo/Edition"/>
				</label>
			</xsl:if>
		</field>
		
	</image>
</xsl:when>

<!-- 
==================================
Render image for 12 inch display
==================================
-->

<xsl:when test="Label/DisplayWidth = 768 and Label/DisplayHeight = 960">
	<image width="768" height="960">
		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>
		
		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
		
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="400" height="300" border="8" color="white"/> -->
		
				<!-- imagotag CI brackets -->
				<line x-from="234" x-to="244" y-from="713" y-to="713" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="234" x-to="234" y-from="713" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="234" x-to="244" y-from="883" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="534" x-to="524" y-from="713" y-to="713" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="534" x-to="534" y-from="713" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="534" x-to="524" y-from="883" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="738" height="100" width="768" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="4">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="848" height="20" width="768">
					<label font-family="Verdana" font-weight="bold" font-size="16" align="center">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="10" y="924" height="15" width="100">
					<label font-family="Verdana" font-weight="bold" font-size="12">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="468" y="924" height="12" width="290" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="738" height="45" width="768" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="788" height="20" width="768">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="15" width="100">
			<label font-family="Verdana" font-weight="bold" font-size="12">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="580" y="10" height="30" width="180">
			<label font-family="Verdana" font-weight="bold" font-size="12" align="right">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			<label font-family="Verdana" font-size="10" align="right">
				<xsl:value-of select="LabelInfo/Edition"/>
			</label>
		</field>
		</image>
</xsl:when>


<!-- 
==================================
Render image for SES segmented
==================================
-->

<xsl:when test="Label/DisplayWidth = 128 and Label/DisplayHeight = 1">
	<image height="1" width="128" rotation="180">
		<xsl:choose>
			<xsl:when test="starts-with(Label/Id, '1F') or starts-with(Label/Id, '1E') or starts-with(Label/Id, '1D')">
				<rect x="0" y="0" width="128" height="1"/>
				<rect x="90" y="0" width="1" height="1" color="white"/>
			</xsl:when>
		</xsl:choose>
	</image>
</xsl:when>

<!-- 
=================================
Render image for 3.7 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 416 and Label/DisplayHeight = 240">
			<image width="416" height="240">
		
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
		
				<!-- Set orientation -->
				<xsl:if test="LabelInfo/Orientation != ''">
					<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<field x="0" y="22" width="416" height="200" align="center" valign="center">
						
						<!-- Border to detect display breakage -->
						<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->
		
						<!-- imagotag CI brackets -->
						<line x-from="100" x-to="108" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="100" x-to="100" y-from="35" y-to="155" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="100" x-to="108" y-from="160" y-to="160" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="316" x-to="308" y-from="35" y-to="35" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="316" x-to="316" y-from="35" y-to="160" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
						<line x-from="316" x-to="308" y-from="160" y-to="160" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>

						<!-- Registration code as 2D barcode -->
						<field x="0" width="416" height="80" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="0" width="416" height="20">
							<label font-family="Verdana" align="center">
								<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						</field>
						<!-- Label ID as text -->
						<field x="8" y="222" height="10" width="70">
							<label font-family="Verdana" font-size="10" font-weight="normal">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="208" y="223" width="200" height="9" align="right">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					<field x="8" y="58" height="170" width="400" align="center" valign="center">
						<!-- Label ID as 1D barcode -->
						<field x="0" height="45" width="400" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="0" height="15" width="400">
							<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
					</field>
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- SES-imagotag -->
				<field x="8" y="8" height="14" width="85">
					<label font-family="Verdana" font-weight="bold" font-size="10"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						SES-imagotag
					</label>
				</field>
				
				<!-- Label type as text -->
				<field x="276" y="8" height="50" width="132" align="right">
					<label font-family="Verdana" font-weight="bold" font-size="10" align="right"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/> <xsl:value-of select="LabelInfo/Edition"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/> <xsl:value-of select="LabelInfo/Edition"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
				</field>
			</image>
</xsl:when>

<!-- 
=================================
Render image for 5.9 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 720 and Label/DisplayHeight = 256">

	<image width="720" height="256">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="243" x-to="251" y-from="55" y-to="55" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="243" x-to="243" y-from="55" y-to="191" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="243" x-to="251" y-from="191" y-to="191" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="469" x-to="477" y-from="55" y-to="55" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="477" x-to="477" y-from="55" y-to="191" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>
				<line x-from="469" x-to="477" y-from="191" y-to="191" thickness="6"><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute></line>

				<field x="0" y="22" width="720" height="215" align="center" valign="center">
				
				<!-- Registration code as 2D barcode -->
				<field x="0"  width="720" height="80" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0"  width="720" height="20">
					<label font-family="Verdana" align="center" >
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				</field>
				<!-- Label ID as text -->
				<field x="8" y="238" height="12" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="512" y="239" width="200" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				<field x="0" y="22" width="720" height="230" align="center" valign="center">
				<!-- Label ID as 1D barcode -->
				<field x="0" height="45" width="720" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" height="15" width="720">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center" >
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				</field>
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="14" width="85">
			<label font-family="Verdana" font-weight="bold" font-size="10" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="562" y="8" height="50" width="150" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right" ><xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
	</image>
</xsl:when>

<!-- 
=================================
Render image for 9.7 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 672 and Label/DisplayHeight = 960">
		<image width="672" height="960">
		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED' or Label/DisplayColors = 'BLACK_WHITE_YELLOW'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>
		
		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
		
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="400" height="300" border="8" color="white"/> -->
		
				<!-- imagotag CI brackets -->
				<line x-from="195" x-to="205" y-from="713" y-to="713" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="195" x-to="195" y-from="713" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="195" x-to="205" y-from="883" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="477" x-to="467" y-from="713" y-to="713" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="477" x-to="477" y-from="713" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<line x-from="477" x-to="467" y-from="883" y-to="883" thickness="6">
					<xsl:attribute name="color">
						<xsl:value-of select="$color"/>
					</xsl:attribute>
				</line>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="738" height="100" width="672" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="4">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="848" height="20" width="672">
					<label font-family="Verdana" font-weight="bold" font-size="16" align="center">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="10" y="924" height="15" width="100">
					<label font-family="Verdana" font-weight="bold" font-size="12">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="374" y="924" height="12" width="290" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="738" height="45" width="672" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="788" height="20" width="672" align="center">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- SES-imagotag -->
		<field x="8" y="8" height="15" width="100">
			<label font-family="Verdana" font-weight="bold" font-size="12">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				SES-imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="484" y="10" height="30" width="180">
			<label font-family="Verdana" font-weight="bold" font-size="12" align="right">
				<xsl:attribute name="color">
					<xsl:value-of select="$color"/>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			<label font-family="Verdana" font-size="10" align="right">
				<xsl:value-of select="LabelInfo/Edition"/>
			</label>
		</field>
				
			</image>
</xsl:when>


</xsl:choose>
</xsl:template>

<xsl:template name="digit">
	<xsl:param name="D1"/>
	<xsl:param name="offset"/>
	
	<xsl:variable name="D1f"><xsl:value-of select="number($offset) * 8 + 7"/></xsl:variable>
	<xsl:variable name="D1b"><xsl:value-of select="number($offset) * 8 + 6"/></xsl:variable>
	<xsl:variable name="D1a"><xsl:value-of select="number($offset) * 8 + 5"/></xsl:variable>
	<xsl:variable name="D1d"><xsl:value-of select="number($offset) * 8 + 3"/></xsl:variable>
	<xsl:variable name="D1e"><xsl:value-of select="number($offset) * 8 + 2"/></xsl:variable>
	<xsl:variable name="D1c"><xsl:value-of select="number($offset) * 8 + 1"/></xsl:variable>
	<xsl:variable name="D1g"><xsl:value-of select="number($offset) * 8"/></xsl:variable>

	<xsl:variable name="foreground">black</xsl:variable>
	<xsl:if test="$D1">
		<xsl:choose>
		<xsl:when test="$D1 = '0'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '1'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '2'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '3'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '4'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '5'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '6'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '7'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '8'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '9'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'A' or $D1 ='a'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'B' or $D1 ='b'">
			
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'C' or $D1 ='c'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'D' or $D1 ='d'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
	
		</xsl:when>
		<xsl:when test="$D1 = 'E' or $D1 ='e'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'F' or $D1 ='f'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'P' or $D1 ='p'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1b"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1e"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = 'S' or $D1 ='s'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1a"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1f"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1c"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1d"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		<xsl:when test="$D1 = '-'">
			<rect y="0" width="1" height="1"><xsl:attribute name="x"><xsl:value-of select="$D1g"/></xsl:attribute><xsl:attribute name="color"><xsl:value-of select="$foreground"/></xsl:attribute></rect>
		</xsl:when>
		</xsl:choose>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>