<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- Transaction Status -->

<xsl:template match="TransactionStatusInfo">
	<xsl:variable name="progress">
		<xsl:choose>
			<xsl:when test="number(TaskCount) &gt; 0">
				<xsl:value-of select="round((number(FinishedUpdates) div number(TaskCount)) * 100)"/>
			</xsl:when>
			<xsl:otherwise>100</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<h1>Status of Transaction <xsl:value-of select="Id"/></h1>
	
	<h2>Transaction Summary</h2>
	
	<table class="detail">

		<tr>
			<th>Status:</th>
			<xsl:choose>
				<xsl:when test="number(TaskCount) = number(FinishedUpdates) and number(ErrorUpdates) = 0">
					<td class="SUCCESSFUL">All tasks finished successfully</td>
				</xsl:when>
				<xsl:when test="number(TaskCount) = number(FinishedUpdates) and number(ErrorUpdates) &gt; 0">
					<td class="ERROR"><xsl:value-of select="ErrorUpdates"/> task(s) failed</td>
				</xsl:when>
				<xsl:otherwise>
					<td class="WAITING">Running</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		
		<tr>
			<th>Progress:</th>
			<td>
				<div style="position: relative; width: 100%; height: 2em; background-color: gray;">
					<div>
						<xsl:attribute name="style">height: 100%; background-color: green; width: <xsl:value-of select="$progress"/>%;</xsl:attribute>
						<div style="position: absolute; top: 4px; left: 0; width: 100%; height: 100%; color: white; font-weight: bold; text-align: center; vertical-align: middle;">
							<xsl:value-of select="$progress"/> %
						</div>
					</div>
				</div>
			</td>
		</tr>
		
		<tr>
			<th>Title:</th>
			<td><xsl:value-of select="Title"/></td>
		</tr>
		
		<tr>
			<th>External ID:</th>
			<td><xsl:value-of select="ExternalId"/></td>
		</tr>
		
		<tr>
			<th>Started at:</th>
			<td><xsl:value-of select="StartedTime"/></td>
		</tr>
		
		<tr>
			<xsl:choose>
				<xsl:when test="number(TaskCount) = number(FinishedUpdates)">
					<th>Finished at:</th>
				</xsl:when>
				<xsl:otherwise>
					<th>Last task update at:</th>
				</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="LastUpdateTime"/></td>
		</tr>
		
		<tr>
			<th>Task count:</th>
			<td><xsl:value-of select="TaskCount"/></td>
		</tr>
	
		<tr>
			<th>Total tasks:</th>
			<td><xsl:value-of select="TotalUpdates"/></td>
		</tr>

		<tr>
			<th>Finished tasks:</th>
			<td><xsl:value-of select="FinishedUpdates"/></td>
		</tr>
		
		<tr>
			<th>Successful tasks:</th>
			<td><xsl:value-of select="number(FinishedUpdates) - number(ErrorUpdates)"/></td>
		</tr>
		
		<tr>
			<th>Failed tasks:</th>
			<td><xsl:value-of select="ErrorUpdates"/></td>
		</tr>
		
		<tr>
			<th>Waiting tasks:</th>
			<td><xsl:value-of select="number(TaskCount) - number(FinishedUpdates)"/></td>
		</tr>
		
	</table>
	
	<h2>Actions</h2>
	
	<ul>
		<li>
			<a>
				<xsl:attribute name="href">/service/updatestatus/transaction/<xsl:value-of select="Id"/>.xml?page=0</xsl:attribute>
				Show update log
			</a>
		</li>
	</ul>
</xsl:template>


<!-- Query -->

<xsl:template match="QueryList">
	<h1>Query Summary</h1>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>URL</th>
					<th>Record Type</th>
					<th>Parameter Type</th>
				</tr>
				
				<xsl:apply-templates select="Query"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="Query">
	<tr>
		<td>
			<xsl:choose>
				<xsl:when test="ParameterClass = 'Void'">
					<a>
						<xsl:attribute name="href">/service/<xsl:value-of select="Url"/>.xml</xsl:attribute>
						/service/<xsl:value-of select="Url"/>.xml
					</a>
				</xsl:when>
				<xsl:otherwise>
					/service/<xsl:value-of select="Url"/>/&lt;parameter&gt;.xml
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:value-of select="RecordClass"/>
		</td>
		<td>
			<xsl:value-of select="ParameterClass"/>
		</td>
	</tr>
</xsl:template>


<!-- UpdateErrorDescription -->

<xsl:template match="UpdateErrorDescriptionList">
	<h1>Update Errors</h1>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table class="record">
				<tr>
					<th>Error Code</th>
					<th>Description</th>
				</tr>
				
				<xsl:apply-templates select="UpdateErrorDescription"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="UpdateErrorDescriptionEntry">
	<h1>Update Errors</h1>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table>
				<tr>
					<th>Error Code</th>
					<th>Description</th>
				</tr>
				
				<xsl:apply-templates select="UpdateErrorDescription"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="UpdateErrorDescription">
	<tr>
		<td>
			<xsl:value-of select="ErrorCode"/>
		</td>
		<td>
			<xsl:value-of select="Description"/>
		</td>
	</tr>
</xsl:template>


<!-- LabelErrorDescription -->

<xsl:template match="LabelErrorDescriptionList">
	<h1>Label Errors</h1>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table>
				<tr>
					<th>Error Code</th>
					<th>Description</th>
				</tr>
				
				<xsl:apply-templates select="LabelErrorDescription"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelErrorDescription">
	<tr>
		<td>
			<xsl:value-of select="ErrorCode"/>
		</td>
		<td>
			<xsl:value-of select="Description"/>
		</td>
	</tr>
</xsl:template>


<!-- EnumDescriptionList -->

<xsl:template match="EnumDescriptionList">
	<h1><xsl:value-of select="EnumDescription[1]/Type"/></h1>
	
	<table>
		<tr>
			<th>Name</th>
			<th>Description</th>
		</tr>
		
		<xsl:apply-templates select="EnumDescription"/>
	</table>
</xsl:template>

<xsl:template match="EnumDescription">
	<tr>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="Name"/> centered</xsl:attribute>
			<xsl:value-of select="Name"/>
		</td>
		<td>
			<xsl:value-of select="Description"/>
		</td>
	</tr>
</xsl:template>


<!-- LabelTypeDescriptionList -->

<xsl:template match="LabelTypeDescriptionList">
	<h1>Label Types</h1>
	
	<xsl:choose>
		<xsl:when test="@count = 0">
			<p id="message">No records found</p>
		</xsl:when>
		<xsl:otherwise>
			<table>
				<tr>
					<th>Name</th>
					<th>Display</th>
					<th>Colors</th>
					<th>Mappings</th>
				</tr>
				
				<xsl:apply-templates select="LabelTypeDescription"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="LabelTypeDescription">
	<tr>
		<td>
			<xsl:value-of select="Name"/>
		</td>
		<td>
			<xsl:value-of select="DisplayWidth"/> × <xsl:value-of select="DisplayHeight"/>, <xsl:value-of select="DisplayDpi"/> dpi
		</td>
		<td>
			<xsl:value-of select="DisplayColors"/>
		</td>
		<td>
			<xsl:for-each select="Mappings/Item">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">, </xsl:if>
			</xsl:for-each>
		</td>
	</tr>
</xsl:template>

<xsl:template match="ProvisioningStatus">
	<h1>Provisioning Status</h1>
	<table>
		<tr>
			<th>Provisioning enabled:</th>
			<td><xsl:value-of select="./@enabled"/></td>
		</tr>
		<xsl:if test="./@last-update">
			<tr>
				<th>Last update:</th>
				<td><xsl:value-of select="./@last-update"/></td>
			</tr>		
		</xsl:if>
	</table>
	<xsl:choose>
		<xsl:when test="count(ProvisioningProblems/ProvisioningProblem) = 0">
			<p id="message">No provisioning problems detected</p>
		</xsl:when>
		<xsl:otherwise>
			<table>
				<tr>
					<th>Configuration ID</th>
					<th>Message</th>
				</tr>
				
				<xsl:for-each select="ProvisioningProblems/ProvisioningProblem">
					<tr>
						<td><xsl:value-of select="./@configuration-id"/></td>
						<td><xsl:value-of select="."/></td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:otherwise>
	</xsl:choose>		
</xsl:template>

<xsl:template match="JobRuntimeConfiguration">
	<h1><xsl:value-of select="./@name"/></h1>
	
	<h2>Configuration</h2>
	<xsl:if test="./@configKey">
		<table>
			<tr>
				<th>Config Key</th>
				<th>Config Value</th>
			</tr>
			<tr>
				<td><xsl:value-of select="./@configKey"/></td>
				<td><xsl:value-of select="./@configValue"/></td>
			</tr>
		</table>
		<br />
	</xsl:if>
	<table>
		<tr>
			<th>Type</th>
			<xsl:if test="./@enabledKey"><th>Config Key</th></xsl:if>
			<xsl:if test="./@scheduleDefault"><th>Default value</th></xsl:if>
			<th>Value</th>
		</tr>
		<tr>
			<td>Enabled/disabled</td>
			<xsl:if test="./@enabledKey"><td><xsl:value-of select="./@enabledKey"/></td></xsl:if>
			<xsl:if test="./@scheduleDefault"><td><xsl:value-of select="./@enabledDefault"/></td></xsl:if>
			<td><xsl:value-of select="./@enabled"/></td>
		</tr>
		<tr>
			<td>Schedule</td>
			<xsl:if test="./@enabledKey"><td><xsl:value-of select="./@scheduleKey"/></td></xsl:if>
			<xsl:if test="./@scheduleDefault"><td><xsl:value-of select="./@scheduleDefault"/></td></xsl:if>
			<td><xsl:value-of select="./@schedule"/></td>
		</tr>
	</table>
	<br />
	<table>
		<tr><th>Cron expression:</th></tr>
		<xsl:for-each select="./CronExpressions/CronExpression">
			<tr><td><xsl:value-of select="."/></td></tr>
		</xsl:for-each>
	</table>
</xsl:template>

<xsl:template match="JobStatistics">
	<h1>Service Scheduling</h1>
	<table>
		<tr><th>Server time:</th><td><xsl:value-of select="./@currentDateTime"/></td></tr>
	</table>
	<xsl:variable name="executingJobs" select="./JobStatistic[@running='true']"/>
	
	<xsl:if test="count($executingJobs) &gt; 0">
		<h2>Running job(s)</h2>
		<table>
			<tr>
				<th>Job name</th>
				<th>Duration (ms)</th>
				<th>Action</th>
			</tr>
			<xsl:for-each select="$executingJobs">
				<tr>
					<td>
						<a>
							<xsl:attribute name="href">/service/scheduler/details/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
							<xsl:choose>
								<xsl:when test="./@configKey">
									ConfigJob [<xsl:value-of select="./@configKey"/>=<xsl:value-of select="substring(./@configValue, 1, 100)"/>]
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="./@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</td>
					<td><xsl:value-of select="./@currentExecutionMillis"/></td>
					<td>
						<a>
							<xsl:attribute name="href">/service/scheduler/cancel/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
							Cancel
						</a>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<br />
	</xsl:if>
	
	<h2>Next job(s)</h2>
	<table>
		<tr>
			<th>Job name</th>
			<th>Previous execution</th>
			<th>Next execution</th>
			<th>Execution count</th>
			<th>Last duration (ms)</th>
			<th>Action</th>
		</tr>
		<xsl:for-each select="JobStatistic[@enabled='true']">
			<tr>
				<td>
					<a>
						<xsl:attribute name="href">/service/scheduler/details/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
						<xsl:choose>
							<xsl:when test="./@configKey">
								ConfigJob [<xsl:value-of select="./@configKey"/>=<xsl:value-of select="substring(./@configValue, 1, 100)"/>]
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="./@name"/>
							</xsl:otherwise>
						</xsl:choose>
					</a>
				</td>
				<td><xsl:value-of select="./@previous"/></td>
				<td>
					<xsl:value-of select="./@next"/>
					<xsl:if test="./@manuallyTriggered = 'true'"> (Manual execution)</xsl:if>
				</td>
				<td><xsl:value-of select="./@executionCount"/></td>
				<td><xsl:value-of select="./@executionMillis"/></td>
				<td>
					<xsl:choose>
						<xsl:when test="./@manuallyTriggered = 'true' or ./@enabled = 'false'">
						</xsl:when>
						<xsl:otherwise>
							<a>
								<xsl:attribute name="href">/service/scheduler/trigger/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
								Run now
							</a>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:for-each>
	</table>
	
	<br />
	<h2>Disabled job(s)</h2>
	<table>
		<tr>
			<th>Job name</th>
			<th>Previous execution</th>
			<th>Next execution</th>
			<th>Execution count</th>
			<th>Last duration (ms)</th>
			<th>Action</th>
		</tr>
		<xsl:for-each select="JobStatistic[@enabled='false']">
			<tr>
				<td>
					<a>
						<xsl:attribute name="href">/service/scheduler/details/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
						<xsl:choose>
							<xsl:when test="./@configKey">
								ConfigJob [<xsl:value-of select="./@configKey"/>=<xsl:value-of select="substring(./@configValue, 1, 100)"/>]
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="./@name"/>
							</xsl:otherwise>
						</xsl:choose>
					</a>
				</td>
				<td><xsl:value-of select="./@previous"/></td>
				<td>
					<xsl:value-of select="./@next"/>
					<xsl:if test="./@manuallyTriggered = 'true'"> (Manual execution)</xsl:if>
				</td>
				<td><xsl:value-of select="./@executionCount"/></td>
				<td><xsl:value-of select="./@executionMillis"/></td>
				<td>
					<a>
						<xsl:attribute name="href">/service/scheduler/trigger/<xsl:value-of select="./@name"/>.xml</xsl:attribute>
						Run now
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</table>
	<br />
	
	<xsl:if test="count(./LoggingEvents/LoggingEvent) &gt; 0">
		<h2>Logging</h2>
		<table>
			<tr>
				<th>Level</th>
				<th>Timestamp</th>
				<th>Message</th>
			</tr>
			
			<xsl:for-each select="./LoggingEvents/LoggingEvent">
				<tr>
					<td>
						<xsl:attribute name="class"><xsl:value-of select="./@level"/></xsl:attribute>
						<xsl:value-of select="./@level"/>
					</td>
					<td><xsl:value-of select="./@timestamp"/></td>
					<td><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
