﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- How to display the service status -->

<xsl:template match="service-status">
	<h1><xsl:value-of select="./@name"/> Status</h1>
	
	<xsl:if test="property[@key='device-mode'] and property[@key='id']">
		<h2>Device Status</h2>
		
		<table class="detail">
			<tr>
				<th>Device ID:</th>
				<td><xsl:value-of select="property[@key='id']"/></td>
			</tr>
			<tr>
				<th>Device Mode:</th>
				<td><xsl:value-of select="property[@key='device-mode']"/></td>
			</tr>
			<tr>
				<th>Serial Number:</th>
				<td><xsl:value-of select="property[@key='serial']"/></td>
			</tr>
			<tr>
				<th>Hardware Revision:</th>
				<td><xsl:value-of select="property[@key='hardware-version']"/></td>
			</tr>
			<tr>
				<th>BIOS Version:</th>
				<td><xsl:value-of select="property[@key='bios-version']"/></td>
			</tr>
		</table>
	</xsl:if>
	
	<h2>Service Status</h2>
	
	<table class="detail">
		<tr>
			<th>Status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="property[@key='status']"/></xsl:attribute>
				<xsl:value-of select="property[@key='status']"/>
			</td>
		</tr>
		<tr>
			<th>Software Version:</th>
			<td><xsl:value-of select="property[@key='version']"/></td>
		</tr>
		<tr>
			<th>Build:</th>
			<td><xsl:value-of select="property[@key='build']"/></td>
		</tr>
		<tr>
			<th>Uptime:</th>
			<td><xsl:value-of select="property[@key='service-uptime']"/></td>
		</tr>
		<tr>
			<th>Time:</th>
			<td><xsl:value-of select="property[@key='server-time']"/></td>
		</tr>
		<xsl:if test="property[@key='provisioning-enabled'] and property[@key='id']">
			<tr>
				<th>Provisioning Enabled:</th>
				<td><xsl:value-of select="property[@key='provisioning-enabled']"/></td>
			</tr>
		</xsl:if>
	</table>
	
	<h2>Site Status</h2>
	
	<table class="detail">
		<tr>
			<th>Store ID:</th>
			<td><xsl:value-of select="property[@key='store-id']"/></td>
		</tr>
		<tr>
			<th>Access Points:</th>
			<td><xsl:value-of select="property[@key='access-points']"/></td>
		</tr>
		<tr>
			<th>Registered Labels:</th>
			<td><xsl:value-of select="property[@key='labels']"/></td>
		</tr>
		<tr>
			<th>Waiting Tasks:</th>
			<td><xsl:value-of select="property[@key='waiting-tasks']"/></td>
		</tr>
		<tr>
			<th>Unsuccessful Tasks:</th>
			<td><xsl:value-of select="property[@key='error-tasks']"/></td>
		</tr>
	</table>
	
	<h2>Plugins</h2>

	<table class="detail">
		<tr>
			<th>Level 1 Plugins:</th>
			<td><xsl:value-of select="property[@key='plugins-level1']"/></td>
		</tr>
		<tr>
			<th>Level 2 Plugins:</th>
			<td><xsl:value-of select="property[@key='plugins-level2']"/></td>
		</tr>
		<tr>
			<th>Level 3 Plugins:</th>
			<td><xsl:value-of select="property[@key='plugins-level3']"/></td>
		</tr>
	</table>
	
	<xsl:if test="property[@key='rendering-engine-name'] and property[@key='rendering-engine-name'] != 'default'">
		<h2>Image Rendering Engine</h2>

		<table class="detail">
			<tr>
				<th>Engine Name:</th>
				<td><xsl:value-of select="property[@key='rendering-engine-name']"/></td>
			</tr>
			<tr>
				<th>Engine Version:</th>
				<td><xsl:value-of select="property[@key='rendering-engine-version']"/></td>
			</tr>
		</table>
	</xsl:if>
	
	<h2>Network Status</h2>
	
	<table class="detail">
		<tr>
			<th>Hostname:</th>
			<td><xsl:value-of select="property[@key='hostname']"/></td>
		</tr>
		<tr>
			<th>IP Address:</th>
			<td><xsl:value-of select="property[@key='ip-address']"/></td>
		</tr>
		<tr>
			<th>MAC Address:</th>
			<td><xsl:value-of select="property[@key='mac-address']"/></td>
		</tr>
	</table>
	
	
	<h2>Ressources</h2>
	
	<table class="detail">
		<tr>
			<th>JVM Used Memory:</th>
			<td><xsl:value-of select="property[@key='used-memory']"/></td>
		</tr>
		<tr>
			<th>JVM Total Memory:</th>
			<td><xsl:value-of select="property[@key='total-memory']"/></td>
		</tr>
		<tr>
			<th>JVM Free Memory:</th>
			<td><xsl:value-of select="property[@key='free-memory']"/></td>
		</tr>
		<tr>
			<th>JVM Max Memory:</th>
			<td><xsl:value-of select="property[@key='max-memory']"/></td>
		</tr>
		<tr>
			<th>Threads:</th>
			<td><xsl:value-of select="property[@key='threads']"/></td>
		</tr>
	</table>
	
	
	<h2>System Status</h2>
	
	<table class="detail">
		<tr>
			<th>Java Runtime:</th>
			<td><xsl:value-of select="property[@key='java-runtime-name']"/></td>
		</tr>
		<tr>
			<th>Java Runtime Version:</th>
			<td><xsl:value-of select="property[@key='java-runtime-version']"/></td>
		</tr>
		<tr>
			<th>Java Virtual Machine:</th>
			<td><xsl:value-of select="property[@key='java-vm-name']"/></td>
		</tr>
		<tr>
			<th>Java GC:</th>
			<td><xsl:value-of select="property[@key='java-gc']"/></td>
		</tr>
		<tr>
			<th>Java Home:</th>
			<td><xsl:value-of select="property[@key='java-home']"/></td>
		</tr>
		<tr>
			<th>Operating System:</th>
			<td><xsl:value-of select="property[@key='os-name']"/> (Version <xsl:value-of select="property[@key='os-version']"/>, <xsl:value-of select="property[@key='os-arch']"/>)</td>
		</tr>
		<tr>
			<th>Core Service Path:</th>
			<td><xsl:value-of select="property[@key='installation-path']"/></td>
		</tr>
		<tr>
			<th>Working Directory:</th>
			<td><xsl:value-of select="property[@key='cwd']"/></td>
		</tr>
	</table>
	
	
	<h2>Session Status</h2>
	
	<table class="detail">
		<tr>
			<th>Username:</th>
			<td><xsl:value-of select="property[@key='username']"/></td>
		</tr>
		<tr>
			<th>Role:</th>
			<td><xsl:value-of select="property[@key='role']"/></td>
		</tr>
	</table>
	
	
	<h2>License Status</h2>
	
	<table class="detail">
		<tr>
			<th>License:</th>
			<td><xsl:value-of select="property[@key='licensed-mode']"/></td>
		</tr>
		<tr>
			<th>Licensed To:</th>
			<td><xsl:value-of select="property[@key='licensed-customer']"/></td>
		</tr>
		<tr>
			<th>System Serial:</th>
			<td><xsl:value-of select="property[@key='system-serial']"/></td>
		</tr>
		<tr>
			<th>Access Points Allowed:</th>
			<td><xsl:value-of select="property[@key='licensed-access-points']"/></td>
		</tr>
		<tr>
			<th>Labels Allowed:</th>
			<td><xsl:value-of select="property[@key='licensed-labels']"/></td>
		</tr>
	</table>
	
</xsl:template>

<xsl:template match="problems">
	<h1>Problems</h1>
	
	<table>
		<tr>
			<th>Severity</th>
			<th>Message</th>
			<th>Query</th>
		</tr>
		
		<xsl:apply-templates select="problem"/>
	</table>
</xsl:template>

<xsl:template match="problem">
	<tr>
		<td>
			<xsl:attribute name="class"><xsl:value-of select="./@severity"/> centered</xsl:attribute>
			<xsl:value-of select="./@severity"/>
		</td>
		<td>
			<xsl:value-of select="./@message"/>
		</td>
		<td class="centered">
			<xsl:choose>
				<xsl:when test="./@query-url != ''">
					<a>
						<xsl:attribute name="href">/service/<xsl:value-of select="./@query-url"/>.xml</xsl:attribute>
						Query
					</a>
				</xsl:when>
				<xsl:otherwise>
					-
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</tr>
</xsl:template>


</xsl:stylesheet>
