<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" encoding="utf-8" indent="yes"/>
	<xsl:include href="server-includes.xsl"/>

<xsl:template match="/">
	<html xmlns="http://www.w3.org/1999/xhtml">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css" media="screen, print" href="/default.css"/>
			<link rel="icon" href="/images/imagotag_32_green_on_black.png" type="image/png"/>
			<script type="text/javascript" src="/rewrite.js"></script>
			<title>imagotag Core Service</title>
		</head>
		<body onload="rewrite();">
			<div id="navigation">
				<h2>Labels</h2>
				<ul>
					<li><a href="/service/labelinfo/index.xml?page=0">All Labels</a></li>
					<li><a href="/service/labelinfo/status/online.xml?page=0">Online Labels</a></li>
					<li><a href="/service/labelinfo/status/offline.xml?page=0">Offline Labels</a></li>
					<li><a href="/service/labelinfo/unsuccessful.xml?page=0">Unsuccessful Updates</a></li>
					<li><a href="/service/labelinfo/error.xml?page=0">Hardware Errors</a></li>
					<li><a href="/service/labelinfo/powerstatus/low.xml?page=0">Low Battery</a></li>
					<li><a href="/service/labelinfo/powerstatus/bad.xml?page=0">Bad Battery</a></li>
					<li><a href="/service/labels/registered.xml">Registered Labels</a></li>
					<li><a href="/service/history/labelinfo/all.xml?page=0">Label History</a></li>
				</ul>
				<h2>Articles</h2>
				<ul>
					<li><a href="/service/articlerecord/index.xml?page=0">All Articles</a></li>
				</ul>
				<h2>Matchings</h2>
				<ul>
					<li><a href="/service/matchingrecord/index.xml?page=0">All Matchings</a></li>
				</ul>
				<h2>Templates</h2>
				<ul>
					<li><a href="/service/template/index.xml?page=0">All Templates</a></li>
					<li><a href="/service/fontrecord/index.xml?page=0">All Fonts</a></li>
				</ul>
				<h2>Update Log</h2>
				<ul>
					<li><a href="/service/updatestatus/all.xml?page=0">All Updates</a></li>
					<li><a href="/service/updatestatus/waiting.xml?page=0">Waiting Updates</a></li>
					<li><a href="/service/updatestatus/unsuccessful.xml?page=0">Failed Updates</a></li>
					<li><a href="/service/transactionrecord/index.xml?page=0">Transactions</a></li>
				</ul>
				
				<h2>Access Points</h2>
				<ul>
					<li><a href="/service/accesspointconfiguration/index.xml?page=0">Configuration</a></li>
					<li><a href="/service/accesspointinfo/status/discovered.xml?page=0">Discovered</a></li>
					<li><a href="/service/accesspointinfo/index.xml?page=0">Status</a></li>
					<li><a href="/service/accesspointupdatepackagerecord/index.xml?page=0">Update Packages</a></li>
					<li><a href="/uploadUpdatePackage.xml">Upload Update Package</a></li>
				</ul>
				<h2>Maintenance</h2>
				<ul>
					<li><a href="/service/dashboard.xml">Dashboard</a></li>
					<li><a href="/service/licencerecord/index.xml?page=0">Licences</a></li>
					<li><a href="/service/uploadLicence.xml">Upload Licence</a></li>
					<li><a href="/service/configuration/index.xml?page=0">Configuration</a></li>
					<li><a href="/service/user/index.xml?page=0">Users</a></li>
					<li><a href="/service/labels/registered.xml">Registered Labels</a></li>
					<li><a href="/service/problems.xml">Problems</a></li>
					<li><a href="/service/status.xml">Status</a></li>
					<li><a href="/service/scheduler/scheduling.xml">Job Scheduling</a></li>
					<li><a href="/logging.xml">Logging</a></li>
					<li><a href="/export.xml">Export</a></li>
					<li><a href="/documentation.xml">Documentation</a></li>
				</ul>
			</div>
			<div id="content">
				<xsl:apply-templates/>
			</div>
			
			<div id="footer">
				© SES-imagotag GmbH
			</div>
		</body>
	</html>
</xsl:template>

</xsl:stylesheet>
