<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- How to display the network status -->

<xsl:template match="network-status">
	<h1>Network Status</h1>
	
	<xsl:for-each select="network-property">
	
		<h2><xsl:value-of select="@adapter-name"/> (<xsl:value-of select="@interface-name"/>)</h2>
		<table class="detail">
			<tr>
				<th>Address:</th>
				<td>
					<xsl:value-of select="@address"/>
				</td>
			</tr>
			<tr>
				<th>Subnet Mask:</th>
				<td>
					<xsl:value-of select="@subnet"/>
				</td>
			</tr>
			<tr>
				<th>Broadcast Address:</th>
				<td>
					<xsl:value-of select="@broadcast"/>
				</td>
			</tr>
			<xsl:if test="@hardware-address != ''">
			<tr>
				<th>MAC Address:</th>
				<td>
					<xsl:value-of select="@hardware-address"/>
				</td>
			</tr>
			</xsl:if>
		</table>
	</xsl:for-each>
</xsl:template>


</xsl:stylesheet>
