<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="widgets">
		<h1 id="dashboardHeader">Dashboard</h1>
		<img id="dashboardLogo" src="/images/imagotag.png" width="230px"/>
		<hr id="dashboardSeparator" noshade="" height="3"/>
		
		<div class="widgets">
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<xsl:template match="pie-widget">
		<div class="pie-widget">
			<h2><xsl:value-of select="@title"/></h2>
			<xsl:choose>
				<xsl:when test="@total = '0'">
					<div class="no-data-pie">
						No data available.
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div style="display:inline-flex">
						<div class="pieContainer">
			 				<div style="height:100%;float:left;">
								<img style="height:100%"><xsl:attribute name="src"><xsl:text>data:image/png;base64,</xsl:text><xsl:value-of select="@image" /></xsl:attribute></img>
							</div>
							
							<div style="padding-left:260px">
								<ul>
									<xsl:for-each select="./field">
										<xsl:if test="@value != 0">
											<li>
												<div class="legend-box">
													<xsl:attribute name="style">background-color:<xsl:value-of select="@color"/>;</xsl:attribute>
												</div>
												<strong><xsl:value-of select="@name"/></strong> : <xsl:value-of select="@description"/> (<xsl:value-of select="@percentage"/>&#160;%&#160;/&#160;<xsl:value-of select="@value"/>)
											</li>
										</xsl:if>
									</xsl:for-each>
								</ul>
							</div>
						</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	
	<xsl:template match="bar-widget">
		<div class="bar-widget">
			<dl>
				<dt><xsl:value-of select="@title"/></dt>
				<xsl:choose>
					<xsl:when test="@total = '0'">
						<div class="no-data-bar">
							No data available.
						</div>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="widgetId"><xsl:value-of select="@id"/></xsl:variable>
						<xsl:for-each select="./field">
							<style>
								.percentage-<xsl:value-of select="$widgetId"/>-<xsl:value-of select="@id"/>:after {
								width: <xsl:value-of select="number(substring-before(@percentage, '.')) + 1"/>%;
								content:"\A \00a0 <xsl:value-of select="@percentage"/> % (<xsl:value-of select="@value"/>)";
								background-color: <xsl:value-of select="@color"/>;
								}
							</style>
							<dd>
								<xsl:if test="@url != ''">
									<xsl:attribute name="onclick">location.href='<xsl:value-of select="@url"/>';</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="class">
									percentage percentage-<xsl:value-of select="$widgetId"/>-<xsl:value-of select="@id"/>
								</xsl:attribute>
								<span class="widget-text" style="background-color:#faa;">
									<xsl:choose>
										<xsl:when test="@url != ''">
											<u><xsl:value-of select="@name"/></u><xsl:text>&#160;&#160;&#160;</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@name"/><xsl:text>&#160;&#160;&#160;</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</span>
							</dd>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</dl>
		</div>
	</xsl:template>
	
	<xsl:template match="text-widget">
		<div class="text-widget">
			<h2><xsl:value-of select="@title"/></h2>
			<table>
			<xsl:for-each select="./field">
				<tr>
					<xsl:attribute name="style">
						margin-left: solid 20px #faa;margin-right: solid 20px #faa;
						<xsl:choose>
							<xsl:when test="position() != last()">
								border-bottom: solid 1px black;
							</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<th>
						<xsl:attribute name="style">
							color:black;background-color:#faa;text-align:left;
						</xsl:attribute>	
						<xsl:choose>
							<xsl:when test="./@url">
								<a style="color:black"><xsl:attribute name="href"><xsl:value-of select="./@url"/></xsl:attribute><xsl:value-of select="./@key"/></a>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="./@key"/>
							</xsl:otherwise>
						</xsl:choose>
					</th>
					<td style="background-color:#faa;color:black;text-align:right">
						<xsl:value-of select="./@value"/>
					</td>
				</tr>
			</xsl:for-each>
			</table>
		</div>
	</xsl:template>
	
	<xsl:template match="separator-widget">
		<div style="clear:both" />
	</xsl:template>
	
</xsl:stylesheet>