 var jQT = new $.jQTouch();
 var statusData;
 
 var user = "";
 var password = "";
 
 var isDefaultTemplate = false;
 var templatesArray;
 var defaultTemplate;
 
 var deleteIconUrl = 'url("apple/img/cancel.png")';
 var webAppUrl = "/webapp/index.html";
 var templateUrl = "/service/template/index.xml";
 var statusUrl = "/service/status.xml";
 var modifyUrl = "/service/matching/modify.xml";
 var baseUrl;
 var db;
 
 
 $(document).ready(function(){
		 
	 
    var delay = 50;
    var hovertime = null;
    var hoverdelay = null;
    $(".form .submit").bind('touchstart mouseover', function(){
        clearTimeout(hoverdelay);
        hovertime = new Date().getTime();
        var $el = $(this).add("*", this);
        hoverdelay = setTimeout(function(){
            $el.addClass("activeButton");
        }, delay);
    });
    $(".form .submit").bind('touchend mouseup', function() {
        clearTimeout(hoverdelay);
        var now = new Date().getTime();
        var $el = $(this).add("*", this);
        if(now < hovertime + delay) {
            $el.addClass("activeButton");
            setTimeout(function(){
                $el.removeClass("activeButton");
            }, delay);
        } else {
            $el.removeClass("activeButton");
        }
    });
    
    $(".form .submit").bind('touchmove touchcancel mouseout', function() {
        clearTimeout(hoverdelay);
        var $el = $(this).add("*", this);
        $el.removeClass("active");
    });
	 
	 //GetUser();
	 	 
	 baseUrl = window.location.protocol + "//" + window.location.host;
	 $('input.deletable').wrap('<span class="deleteicon" >');//.after($('<span/>'));
	 
	 $('.deleteicon input').bind('textchange', function (event, previousText) {
		 if($(this).val().length == 0) {
			 $(this).next('span').remove();
		 }
		 else {
			 if($(this).next('span').length == 0) {
				 $(this).after($('<span/>'));
				 $(this).next('span').bind('tap', function(){
					 $(this).prev().val('');
					 $(this).remove();
				 });
			 }
		 
			 
		 }
	 });

	 
	 $('#modifyMatching').bind('tap', ModifyMatching);
	 $('#removeMatching').bind('tap', RemoveMatching);
	 $('#homeStatus').bind('tap', LoadStatus);
	 $('#settingsSave').bind('tap', SaveSettings);
	 $('#homeStatistic').bind('tap', LoadStatistic);
	 $('#settingsCancel').bind('tap', function(){
		 $('#settingsDefaultTemplate').text(defaultTemplate);
	 });
	 $('#settingsDefaultTemplate').bind('tap', function(){
		 isDefaultTemplate = true;
	 });
	 $('#templatesBack').bind('tap', function(){
		 if(isDefaultTemplate == true) {
			 isDefaultTemplate = false; 
		 }
	 });
	 
	 LoadTemplates();
	 
	// InitializeSettings();
	 
	 
	 	var shortName = 'ESL_Webapp';
		var version = '1.0';
		var displayName = 'ESL_Webapp';
		var maxSize = 65536;
		db = openDatabase(shortName, version, displayName, maxSize);
		db.transaction(
				function(transaction) {
					transaction.executeSql(
					'CREATE TABLE IF NOT EXISTS operations ' +
					'  (id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, ' +
					'   date DATE NOT NULL, labelCode TEXT NOT NULL, eanCode TEXT, operation TEXT NOT NULL)', [], function(){}, ErrorHandler);
				}
			);
		
		ClearOldDatasets();
	
	});

 function LoadStatistic() {
	 
	 $('#statistic ul li').remove();

	 db.transaction( 
			 function(transaction) {
				 transaction.executeSql("SELECT * FROM operations ORDER BY date DESC;", 
						 [], 
						 function(transaction,result){
					 
					 		for (var i=0; i < result.rows.length; i++) {
		                        var row = result.rows.item(i);
		                        var date = new Date();
		                        date.setDate(date.getDate() - 30);
		                        var entryDate;
		                        var arr = row.date.split(/[- :]/),
		                        entryDate = new Date(arr[0], arr[1]-1, arr[2], arr[3], arr[4], arr[5]);

		                        if(entryDate > date ) {
		                        	var oldSep = $('[date=' + entryDate.getDate() + ']');
		                        	if(oldSep.length == 0) {

				                        var newEntryRow = $('#dummySep').clone();
				                        newEntryRow.removeAttr('id');
				                        newEntryRow.removeAttr('style');
				                        newEntryRow.appendTo('#statistic ul');
				                        newEntryRow.attr("date", entryDate.getDate());
				                        var month = entryDate.getMonth() + 1;
				                        newEntryRow.text(entryDate.getFullYear() + "-" + month + "-" + entryDate.getDate());
				                        oldSep = newEntryRow;
		                        	}
			                        var newEntry = $('#dummyEntry').clone();
			                        newEntry.removeAttr('id');
			                        newEntry.removeAttr('style');
			                        if(row.eanCode.length > 0) {
			                        	newEntry.append('<span>Operation: ' + row.operation + '</span><br>');
			                        	newEntry.append('<span>Label code: ' + row.labelCode + '</span><br>');
			                        	newEntry.append('<span>Product code: ' + row.eanCode + '</span>');
			                        }
			                        else {
			                        	newEntry.append('<span>Operation: ' + row.operation + '</span><br>');
			                        	newEntry.append('<span>Label code: ' + row.labelCode + '</span>');
			                        }
			                        oldSep.after(newEntry);
			                    }
					 		}
					 }, 
					 function(transaction, error){
						 alert(error.message);}
					 );
				 }
			 );
	 
 }
 
 function ClearOldDatasets() {
	 db.transaction(
		        function(transaction) {
		            transaction.executeSql(
		                'DELETE * FROM operations WHERE date < (datetime("now", "-30 day");', 
		                function(){
		                    //success handler
		                }, 
		                ErrorHandler
		            );
		        }
		    );
 }
 
 function StoreDataSet(labelCode, eanCode, operation) {
	 db.transaction(
		        function(transaction) {
		            transaction.executeSql(
		                'INSERT INTO operations (date, labelCode, eanCode, operation) VALUES (datetime("now"), ?, ?, ?);', 
		                [labelCode, eanCode, operation], 
		                function(){
		                    //success handler
		                }, 
		                ErrorHandler
		            );
		        }
		    );
 }
 
 function ErrorHandler(transaction ,error) {
	 alert(error.message);
 }
 
 function GetUser() {
	 user = window.location.href.replace(window.location.protocol + "//", "");
	 user = user.replace(window.location.host + window.location.pathname, "");
	 user = user.split(":");
	 if(user.length == 2) {
		 password = user[1].split("@")[0];
		 user = user[0];
	 }
	 else {
		 if(user.indexOf("@") >= 0) {
			 user = user.split("@")[0];
		 }
		 else {
			 user = "";
		 }
	 }
 }
 
 function GetCurrentView() {
	 var currentView = $('div.current').attr('id');
	 if(typeof currentView === 'undefined') {
		 currentView = $('.form.current').attr('id');
	 }
	 return currentView;
 }
 
 function LoadStatus() {
	  
	 $.ajax({
		  url: baseUrl + statusUrl,
		 
          error: function(jqXHR, textStatus, errorThrown) {alert(textStatus + " " + errorThrown);},
		  withCredentials: true,
		  dataType: 'xml',
          encoding: "UTF-8",
		  contentType: 'text/xml; charset=utf-8',
		  //username: user,
		  //password: password,
		  
		  success: function(data){
			 parseStatusXml(data);
			 jQT.goTo('#status');
		  }
		});
 }
 
 function parseStatusXml(xml)
 {
	$('.entry.newStatusEntry').remove();
   //find every Tutorial and print the author
	$(xml).find("property").each(function()
	{
		var newEntryRow = $('#dummyStatus').clone();
		newEntryRow.removeAttr('style');
		newEntryRow.attr('class', 'entry newStatusEntry');
		newEntryRow.appendTo('#status ul');
		newEntryRow.find('.statusEntry').text($(this).attr("key") + ": " + $(this).text() );
	});
 }
 
 function InitializeSettings() {
	 //host = localStorage.host;
	 //port = localStorage.port;
	 if(user.length == 0) {
		 user = localStorage.user;
	 }
	 if(password.length == 0) {
		 password = localStorage.password;
	 }
	 //useSSL = localStorage.usessl;
	 //$('#settingsHost').val(host);
	 //$('#settingsPort').val(port);
	 $('#settingsUser').val(user);
	 $('#settingsPassword').val(password);
	/* if(typeof host != 'undefined') {
		 if(host.length > 0) {
			 AddClearButton('settingsHost');
		 }
	 }
	 
	 if(typeof port != 'undefined') {
		 
		 if(port.length > 0) {
			 AddClearButton('settingsPort');
		 }
	 }
	 */
	 if(typeof user != 'undefined') {
		
		 if(user.length > 0) {
			 AddClearButton('settingsUser');
		 }
	 }
	 
	 if(typeof password != 'undefined') {
		 
		 if(password.length > 0) {
			 AddClearButton('settingsPassword');
		 }
	 }
	 /*
	 $('#settingsUseSSL').attr("checked", useSSL === "true");
	 */
	 if(templatesArray != null) {
		 var templateId = templatesArray.indexOf(localStorage.defaulttemplate);
		 if(templateId >= 0) {
			 SetDefaultTemplate(templatesArray[templateId]);
		 }
		 else {
			 SetDefaultTemplate(templatesArray[0]);
		 }
		 
	 }
	 
	 
 }
 
 function SaveSettings() {
	 //localStorage.host = $('#settingsHost').val();
	 //localStorage.port = $('#settingsPort').val();
	 //localStorage.user = $('#settingsUser').val();
	 //localStorage.password = $('#settingsPassword').val();
	 //localStorage.usessl = $('#settingsUseSSL').attr("checked");
	
	 SetDefaultTemplate( $('#settingsDefaultTemplate').text());
 }
	 
 
 function LoadTemplates() {
	 //request
	 $.ajax({
		  url: baseUrl + templateUrl,
		 
          error: function(jqXHR, textStatus, errorThrown) {
        	  alert(textStatus + " " + errorThrown);
        	  },
		  withCredentials: true,
		  dataType: 'xml',
          encoding: "UTF-8",
		  contentType: 'text/xml; charset=utf-8',
		  //username: user,
		  //password: password,
		  
		  success: function(data){
			  ParseTemplates(data);
		  }
		});
 }
	 
function ParseTemplates(data) {
	
	templatesArray = new Array();
	 
	$(data).find("TemplateFilename").each(function()
			{
				templatesArray[templatesArray.length] = $(this).text();
			});
	
	
	
	 $('#settingsTemplateCount').text(templatesArray.length);
	 $('#matchTemplateCount').text(templatesArray.length);
	 
	 for(var i = 0; i < templatesArray.length; i++) {
		var newEntryRow = $('#dummyTemplate').clone();
		newEntryRow.attr('id', "template_" + i);
		newEntryRow.removeAttr('style');
		newEntryRow.appendTo('#templates ul');
		newEntryRow.data('templateName', templatesArray[i]);
		newEntryRow.find('.templateEntry').text(templatesArray[i]);
		
		if(typeof localStorage.defaulttemplate === 'undefined') {
			$('#matchTemplates').text(templatesArray[0]);
			$('#settingsDefaultTemplate').text(templatesArray[0]);
			defaultTemplate = templatesArray[0];
		}
		else {
			$('#matchTemplates').text(localStorage.defaulttemplate);
			$('#settingsDefaultTemplate').text(localStorage.defaulttemplate);
			defaultTemplate = localStorage.defaulttemplate;
		}
		
		newEntryRow.find('.templateEntry').bind('tap', function(e){
			 var clickedEntry = $(this).parent();
			 var template = clickedEntry.data('templateName');
			 if(isDefaultTemplate == true) {
				 $('#settingsDefaultTemplate').text(template);
				 isDefaultTemplate = false;
			 }
			 else {
				 SetActiveTemplate(template);
				 
			 }
			 Back();
		 });
	 }
 }
 
 function SetActiveTemplate(template) {
	 $('#matchTemplates').text(template);
 }
 
 function SetDefaultTemplate(template) {
	 $('#matchTemplates').text(template);
	 $('#settingsDefaultTemplate').text(template);
	 localStorage.defaulttemplate = template;
	 defaultTemplate = template;
 }
	 
 //use timeout to prevent ghost double clicks
 function Back() {
	 setTimeout(jQT.goBack, 100);
 }
	 
 
 function ModifyMatching() {
	
	 if(ValidateLabelCode($('#matchLabelCode').val()) &&
			 ValidateProductCode($('#matchEanCode').val())) {
		 		 
		 $.ajax({
			  url: baseUrl + modifyUrl,
			 type: "POST",
	          error: function(jqXHR, textStatus, errorThrown) {alert(textStatus + " " + errorThrown);},
			  withCredentials: true,
			  dataType: 'xml',
	          encoding: "UTF-8",
			  contentType: 'text/xml; charset=utf-8',
			  //username: user,
			  //password: password,
			  data: CreateModifyXml($('#matchLabelCode').val(), $('#matchEanCode').val(), $('#matchTemplates').text()),
			  success: function(data){
				  StoreDataSet($('#matchLabelCode').val(), $('#matchEanCode').val(), "Modify");
				  $('#matchTemplates').text(defaultTemplate);
				  $('#matchLabelCode').val('');
				  $('#matchEanCode').val('');
				  $('#matchLabelCode').next('span').remove();
				  $('#matchEanCode').next('span').remove();
			  }
			});
		 
	 }
 }
 
 function CreateModifyXml(labelCode, eanCode, template) {
	 return "<?xml version='1.0' encoding='utf-8'?>" +
	 		"<matchings xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' " +
	 		"xmlns:xsd='http://www.w3.org/2001/XMLSchema'><matching label='" + labelCode + "' article='gtin" + eanCode + "' template='" + template + "'/></matchings>";
	 		
 }
 
 function RemoveMatching() {
	 if(ValidateLabelCode($('#unmatchLabelCode').val())) {
		 $.ajax({
			  url: baseUrl + modifyUrl,
			 type: "POST",
	          error: function(jqXHR, textStatus, errorThrown) {alert(textStatus + " " + errorThrown);},
			  withCredentials: true,
			  dataType: 'xml',
	          encoding: "UTF-8",
			  contentType: 'text/xml; charset=utf-8',
			  //username: user,
			  //password: password,
			  data: CreateRemoveXml($('#unmatchLabelCode').val()),
			  success: function(data){
				  StoreDataSet($('#unmatchLabelCode').val(), "", "Remove");
				  $('#unmatchLabelCode').val('');
				  $('#unmatchLabelCode').next('span').remove();
			  }
			});
	 }
 }
 
 function CreateRemoveXml(labelCode) {
	 return "<?xml version='1.0' encoding='utf-8'?>" +
		"<matchings xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' " +
		"xmlns:xsd='http://www.w3.org/2001/XMLSchema'><matching label='" + labelCode + "' /></matchings>";

 }
 
 function AddClearButton(inputName) {
	 if($('#' + inputName).next('span').length == 0) {
		 $('#' + inputName).after($('<span/>'));
		 $('#' + inputName).next('span').bind('tap', function(){
			 $(this).prev().val('');
			 $(this).remove();
		 });
	 }
 }
 
 function ScannedBarcode() {
	 var barcode = $('#barcode').val();
	 if(ValidateLabelCode(barcode)) {
		 if(GetCurrentView() === 'match') {
			 
			 if($('#matchLabelCode').val().length == 8 && 
					 ValidateProductCode(barcode)) {
				//occurs when ean-8 is scanned and labelcode already filled out
				 $('#matchEanCode').val(barcode);
				 AddClearButton('matchEanCode');
				 return;
			 }
			 $('#matchLabelCode').val(barcode);
			 AddClearButton('matchLabelCode');
		 }
		 else if(GetCurrentView() === 'unmatch') {
			 $('#unmatchLabelCode').val(barcode);
			 AddClearButton('unmatchLabelCode');
		 }
	 }
	 else if(ValidateProductCode(barcode)) {
		 if(GetCurrentView() === 'match') {
			 $('#matchEanCode').val(barcode);
			 AddClearButton('matchEanCode');
		 }
	 }
	 else {
		 if(GetCurrentView() === 'settings') {
			 ValidateSettingsBarcode(barcode);
		 }
	 }
 }
 
 function ValidateLabelCode(code)
 {
	 return /^#?(([a-fA-F0-9]){8}){1,2}$/i.test(code); 
 }
 
 function ValidateProductCode(code) {
		// Check if only digits
		var ValidChars = "0123456789";
		for (var i = 0; i < code.length; i++) {
			digit = code.charAt(i);
			if (ValidChars.indexOf(digit) == -1) {
				return false;
			}
		}

		// Add five 0 if the code has only 8 digits
		if (code.length == 8 ) {
			code = "00000" + code;
		}
		
		//Add one 0 if the code has only 12 digits
		if(code.length == 12) {
			code = "0" + code;
		}
		
		// Check for 13 digits otherwise
		else if (code.length != 13) {
			return false;
		}

		// Get the check number
		originalCheck = code.substring(code.length - 1);
		code = code.substring(0, code.length - 1);

		// Add even numbers together
		even = Number(code.charAt(1)) +
		       Number(code.charAt(3)) +
		       Number(code.charAt(5)) +
		       Number(code.charAt(7)) +
		       Number(code.charAt(9)) +
		       Number(code.charAt(11));
		// Multiply this result by 3
		even *= 3;

		// Add odd numbers together
		odd = Number(code.charAt(0)) +
		      Number(code.charAt(2)) +
		      Number(code.charAt(4)) +
		      Number(code.charAt(6)) +
		      Number(code.charAt(8)) +
		      Number(code.charAt(10));

		// Add two totals together
		total = even + odd;

		// Calculate the checksum
	    // Divide total by 10 and store the remainder
	    checksum = total % 10;
	    // If result is not 0 then take away 10
	    if (checksum != 0) {
	        checksum = 10 - checksum;
	    }

		// Return the result
		if (checksum != originalCheck) {
			return false;
		}

	    return true;
	}
 
 function ValidateSettingsBarcode(code) {
	 
/*	 if(code.startsWith("host:")) {
		 $('#settingsHost').val(code.replace("host:", ""));
		 AddClearButton('settingsHost');
	 }
	 else if(code.startsWith("port:")) {
		 $('#settingsPort').val(code.replace("port:", ""));
		 AddClearButton('settingsPort');
	 }
	 else if(code.startsWith("usessl:")) {
		 $('#settingsUseSSL').attr("checked", code.replace("usessl:", "") === "true");
	 }*/
	 if(code.startsWith("user:")) {
		 $('#settingsUser').val(code.replace("user:", ""));
		 AddClearButton('settingsUser');
	 }
	 else if(code.startsWith("password:")) {
		 $('#settingsPassword').val(code.replace("password:", ""));
		 AddClearButton('settingsPassword');
	 }
	 else if(code.endsWith(".xsl")) {
		 if(templatesArray != null) {
			 var templateId = templatesArray.indexOf(code);
			 if(templateId >= 0) {
				 SetDefaultTemplate(code);
			 }
		 }
	 }
 }
 
 String.prototype.startsWith = function(str) 
 {return (this.match("^"+str)==str);}
 
 String.prototype.endsWith = function(str) 
 {return (this.match(str+"$")==str);}
 
