/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.xml.ParserType;
import at.mrdevelopment.esl.xml.RoamingTableXMLSerializerPerformanceTest;
import at.mrdevelopment.esl.xml.TaskIdXMLSerializerPerformanceTest;
import at.mrdevelopment.esl.xml.UpdateTaskXMLSerializerPerformanceTest;
import java.io.File;
import java.io.OutputStream;
import javax.xml.parsers.SAXParserFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;

public class XMLSerializerPerformanceTest {
    public static File DEFAULT_ROAMING_FILE = new File("roamingtable.xml");
    public static File DEFAULT_TASKID_FILE = new File("taskid.xml");
    public static File DEFAULT_TASK_FILE = new File("task.xml");

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionType = parser.accepts("type", "Test type (roaming|taskid|task|all)").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec optionParser = parser.accepts("parser", "Parser type (dom|sax|all)").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec optionRoamingFile = parser.accepts("roaming-file", "Roaming xml file").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionTaskIdFile = parser.accepts("taskid-file", "TaskID xml file").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionUpdateTaskFile = parser.accepts("task-file", "Task xml file").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionTestCount = parser.accepts("testcount", "Test run count").withOptionalArg().ofType(Integer.class);
        OptionSpecBuilder optionHelp = parser.accepts("help", "Show this help");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)optionHelp)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        String testType = options.has((OptionSpec)optionType) ? (String)options.valueOf((OptionSpec)optionType) : "all";
        String parserTypeString = options.has((OptionSpec)optionParser) ? (String)options.valueOf((OptionSpec)optionParser) : "all";
        File roamingFile = options.has((OptionSpec)optionRoamingFile) ? (File)options.valueOf((OptionSpec)optionRoamingFile) : DEFAULT_ROAMING_FILE;
        File taskIdFile = options.has((OptionSpec)optionTaskIdFile) ? (File)options.valueOf((OptionSpec)optionTaskIdFile) : DEFAULT_TASKID_FILE;
        File updateTaskFile = options.has((OptionSpec)optionUpdateTaskFile) ? (File)options.valueOf((OptionSpec)optionUpdateTaskFile) : DEFAULT_TASK_FILE;
        int testCount = options.has((OptionSpec)optionTestCount) ? (Integer)options.valueOf((OptionSpec)optionTestCount) : 20;
        ParserType parserType = ParserType.valueOf(parserTypeString.toUpperCase());
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        System.out.println(String.format("Installed SAX parser: %s", parserFactory != null ? parserFactory.getClass().getName() : "none"));
        if (testType.toLowerCase().equals("roaming")) {
            new RoamingTableXMLSerializerPerformanceTest(roamingFile, parserType, testCount).startTest();
        } else if (testType.toLowerCase().equals("taskid")) {
            new TaskIdXMLSerializerPerformanceTest(taskIdFile, parserType, testCount).startTest();
        } else if (testType.toLowerCase().equals("task")) {
            new UpdateTaskXMLSerializerPerformanceTest(updateTaskFile, parserType, testCount).startTest();
        } else if (testType.toLowerCase().equals("all")) {
            new RoamingTableXMLSerializerPerformanceTest(roamingFile, parserType, testCount).startTest();
            new TaskIdXMLSerializerPerformanceTest(taskIdFile, parserType, testCount).startTest();
            new UpdateTaskXMLSerializerPerformanceTest(updateTaskFile, parserType, testCount).startTest();
        }
    }
}

