/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.xml.ParserType;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractXMLSerializerPerformanceTest {
    private final File xmlFile;
    private final ParserType parserType;
    private final int testCount;

    public AbstractXMLSerializerPerformanceTest(File xmlFile, ParserType parserType, int testCount) throws FileNotFoundException, SerializeException {
        this.xmlFile = xmlFile;
        this.parserType = parserType;
        this.testCount = testCount;
    }

    public void startTest() throws FileNotFoundException, SerializeException {
        System.out.format("Starting Test %s", this.getTestName());
        if (this.parserType == ParserType.DOM) {
            this.evaluate(this.runDOMTest());
        } else if (this.parserType == ParserType.SAX) {
            this.evaluate(this.runSAXTest());
        } else {
            this.evaluate(this.runDOMTest());
            this.evaluate(this.runSAXTest());
        }
    }

    public abstract String getTestName();

    private List<Long> runSAXTest() throws FileNotFoundException, SerializeException {
        ArrayList<Long> parsingTimes = new ArrayList<Long>();
        System.out.println("Parsing with SAX parser..");
        for (int index = 0; index < this.testCount; ++index) {
            long start = System.nanoTime();
            this.executeSAXTestRun(index);
            long parsingTime = (System.nanoTime() - start) / 1000000L;
            System.out.format("Parsing time (%d): %d ms%n", index + 1, parsingTime);
            parsingTimes.add(parsingTime);
        }
        return parsingTimes;
    }

    private void evaluate(List<Long> parsingTimes) {
        long sum = 0L;
        for (Long time : parsingTimes) {
            sum += time.longValue();
        }
        System.out.format("Average parsing time: %d ms%n", sum / (long)parsingTimes.size());
    }

    protected abstract void executeSAXTestRun(int var1) throws FileNotFoundException, SerializeException;

    protected List<Long> runDOMTest() throws FileNotFoundException, SerializeException {
        ArrayList<Long> parsingTimes = new ArrayList<Long>();
        System.out.println("Parsing with DOM parser..");
        for (int index = 0; index < this.testCount; ++index) {
            long start = System.nanoTime();
            this.executeDOMTestRun(index);
            long parsingTime = (System.nanoTime() - start) / 1000000L;
            System.out.format("Parsing time (%d): %d ms%n", index + 1, parsingTime);
            parsingTimes.add(parsingTime);
        }
        return parsingTimes;
    }

    protected abstract void executeDOMTestRun(int var1) throws FileNotFoundException, SerializeException;

    public File getXmlFile() {
        return this.xmlFile;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public int getTestCount() {
        return this.testCount;
    }
}

