/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.thinap;

import at.mrdevelopment.toolkit.Version;

public class ThinAPConfig {
    private int apId;
    private short protocolVersion;
    private Version firmwareVersion;
    private Version softwareVersion;
    private long lcosSoftwareVersion;
    private byte eslChannel;

    private ThinAPConfig(Builder builder) {
        this.apId = builder.apId;
        this.protocolVersion = builder.protocolVersion;
        this.firmwareVersion = builder.firmwareVersion;
        this.softwareVersion = builder.softwareVersion;
        this.lcosSoftwareVersion = builder.lcosSoftwareVersion;
        this.eslChannel = builder.eslChannel;
    }

    public int getApId() {
        return this.apId;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public Version getSoftwareVersion() {
        return this.softwareVersion;
    }

    public long getLcosSoftwareVersion() {
        return this.lcosSoftwareVersion;
    }

    public byte getEslChannel() {
        return this.eslChannel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThinAPConfig [apId=");
        builder.append(this.apId);
        builder.append(", protocolVersion=");
        builder.append(this.protocolVersion);
        builder.append(", firmwareVersion=");
        builder.append(this.firmwareVersion);
        builder.append(", softwareVersion=");
        builder.append(this.softwareVersion);
        builder.append(", lcosSoftwareVersion=");
        builder.append(this.lcosSoftwareVersion);
        builder.append(", eslChannel=");
        builder.append(this.eslChannel);
        builder.append("]");
        return builder.toString();
    }

    public static class Builder {
        private int apId;
        private short protocolVersion;
        private Version firmwareVersion;
        private Version softwareVersion;
        private long lcosSoftwareVersion;
        private byte eslChannel;

        public Builder(int apId) {
            this.apId = apId;
        }

        public Builder protocolVersion(short protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder firmwareVersion(Version firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder softwareVersion(Version softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public Builder lcosSoftwareVersion(long lcosSoftwareVersion) {
            this.lcosSoftwareVersion = lcosSoftwareVersion;
            return this;
        }

        public Builder eslChannel(byte eslChannel) {
            this.eslChannel = eslChannel;
            return this;
        }

        public ThinAPConfig build() {
            return new ThinAPConfig(this);
        }
    }
}

