/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.statistic;

import at.mrdevelopment.esl.statistic.UtilizationSource;
import org.apache.commons.collections15.buffer.BoundedFifoBuffer;
import org.apache.commons.collections15.buffer.CircularFifoBuffer;

public class BaseUtilizationSource
implements UtilizationSource {
    private final String name;
    private final BoundedFifoBuffer<Integer> currentUsedQueue;
    private final BoundedFifoBuffer<Integer> currentQueue;
    private long currentUsed;
    private long current;
    private long totalUsed;
    private long total;

    public BaseUtilizationSource(String name) {
        this(name, 64);
    }

    public BaseUtilizationSource(String name, int currentSampleSize) {
        this.name = name;
        this.currentUsedQueue = new CircularFifoBuffer(currentSampleSize);
        this.currentQueue = new CircularFifoBuffer(currentSampleSize);
    }

    public String getName() {
        return this.name;
    }

    public synchronized double getCurrentUtilization() {
        return this.current != 0L ? (double)this.currentUsed / (double)this.current : 0.0;
    }

    public synchronized double getAverageUtilization() {
        return this.total != 0L ? (double)this.totalUsed / (double)this.total : 0.0;
    }

    public synchronized void clearCurrentUtilization() {
        this.currentUsedQueue.clear();
        this.currentQueue.clear();
    }

    public synchronized void clearAverageUtilization() {
        this.totalUsed = 0L;
        this.total = 0L;
    }

    protected synchronized void addSample(int sampleUsed, int sampleSize) {
        if (sampleUsed > sampleSize) {
            throw new IllegalArgumentException("Illegal sample: sampleUsed larger than sampleSize");
        }
        if (this.currentUsedQueue.isFull()) {
            this.currentUsed -= (long)((Integer)this.currentUsedQueue.get()).intValue();
            this.current -= (long)((Integer)this.currentQueue.get()).intValue();
        }
        this.currentUsedQueue.add((Object)sampleUsed);
        this.currentQueue.add((Object)sampleSize);
        this.currentUsed += (long)sampleUsed;
        this.current += (long)sampleSize;
        this.totalUsed += (long)sampleUsed;
        this.total += (long)sampleSize;
    }
}

