/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.tcp.DefaultBinaryPacketHandling;
import at.mrdevelopment.esl.accesspoint.tcp.DefaultTextPacketHandling;
import at.mrdevelopment.esl.accesspoint.tcp.ThinAPProtocolV20Handling;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.TCPEventReceiver;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionRequestPacket;
import java.util.Set;

public class ThinAPProtocolV20Strategy
implements TCPEventStrategy {
    private volatile TCPEventReceiver eventReceiver;
    private final ThinAPProtocolV20Handling handling;
    private final DefaultTextPacketHandling textHandling;
    private final DefaultBinaryPacketHandling binaryHandling;
    private final CommunicationChannelType channelType;
    private final int apId;

    public ThinAPProtocolV20Strategy(int inputBufferSize, int apId) {
        this.handling = new ThinAPProtocolV20Handling(inputBufferSize);
        this.channelType = CommunicationChannelType.SLOT;
        this.textHandling = new DefaultTextPacketHandling(this.channelType);
        this.binaryHandling = new DefaultBinaryPacketHandling();
        this.handling.setTextPacketHandling(this.textHandling);
        this.handling.setBinaryPacketHandling(this.binaryHandling);
        this.apId = apId;
    }

    public ThinAPProtocolV20Strategy(int inputBufferSize, CommunicationChannelType channelType, int apId) {
        this.handling = new ThinAPProtocolV20Handling(inputBufferSize, channelType);
        this.channelType = channelType;
        this.textHandling = new DefaultTextPacketHandling(channelType);
        this.binaryHandling = new DefaultBinaryPacketHandling();
        this.handling.setTextPacketHandling(this.textHandling);
        this.handling.setBinaryPacketHandling(this.binaryHandling);
        this.apId = apId;
    }

    public void setBinaryPacketDestinationStrategy(PacketDestinationStrategy destination) {
        this.binaryHandling.setPacketDestinationStrategy(destination);
    }

    public void setTextPacketDestinationStrategy(PacketDestinationStrategy destination) {
        this.textHandling.setPacketDestinationStrategy(destination);
    }

    public void set(TCPEventReceiver receiver) {
        this.eventReceiver = receiver;
    }

    public boolean readAndDecode(TCPSource source) {
        return this.handling.readAndDecode(source);
    }

    public void doAfterSuccesfullyConnected(TCPSource source) {
        byte[] initPacket = IntroductionRequestPacket.create((CommunicationChannelType)this.channelType, (int)this.apId);
        source.getCore().submit(new WriteTask(source.getChannel(), initPacket, initPacket.length));
    }

    public void doAfterWasAccepted(TCPSource source) {
    }

    public void detectedDisconnect(TCPCommunicationChannel comChannel) {
        TCPEventReceiver temp = this.eventReceiver;
        if (temp != null) {
            temp.channelDisconnectNotice(comChannel);
        }
    }

    public void doAfterConnectAttemptFailed(TCPSource source) {
    }

    public int getApId() {
        return this.apId;
    }

    public void setFeatures(Set<Feature> features) {
        this.handling.setFeatures(features);
    }

    public void switchToBinary() {
        this.handling.switchToBinary();
    }
}

