/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.tcp.BinaryPacketHandling;
import at.mrdevelopment.esl.accesspoint.tcp.TextPacketHandling;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.IOLogicEndpoint;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import at.mrdevelopment.toolkit.tcp.thinap.text.RawTextPacket;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Set;

public class ThinAPProtocolV20Handling {
    private static ESLLogger logger = ESLLogger.getLogger(ThinAPProtocolV20Handling.class);
    private static final int PACKET_LENGTH_FIELD_SIZE = 4;
    private ByteBuffer inputBuffer;
    private volatile ProtocolType type = ProtocolType.TEXT;
    private TextProtocolPhase currentPhase;
    private StringBuilder textBuffer = new StringBuilder(2048);
    private RawTextPacket currentTextPacket;
    private int unprocessedBytes = 0;
    private int bytesToProcessInBulk = 4;
    private boolean readLength = true;
    private LengthBasedPacketHandling binaryPacketHandlingBehaviour;
    private BinaryPacketHandling binaryPacketHandling;
    private TextPacketHandling textPacketHandling;
    private Set<Feature> features;

    public ThinAPProtocolV20Handling(int inputBufferSize) {
        this.inputBuffer = ByteBuffer.allocate(inputBufferSize);
        this.inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.currentPhase = TextProtocolPhase.FIRST_LINE;
        this.binaryPacketHandlingBehaviour = LengthBasedPacketHandling.DEFAULT_HANDLING;
        this.resetTextPacketContext();
    }

    public ThinAPProtocolV20Handling(int inputBufferSize, CommunicationChannelType channelType) {
        this.inputBuffer = ByteBuffer.allocate(inputBufferSize);
        this.inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.currentPhase = TextProtocolPhase.FIRST_LINE;
        this.binaryPacketHandlingBehaviour = LengthBasedPacketHandling.DEFAULT_HANDLING;
        this.resetTextPacketContext();
    }

    public void setBinaryPacketHandling(BinaryPacketHandling binaryPacketHandling) {
        this.binaryPacketHandling = binaryPacketHandling;
    }

    public void setTextPacketHandling(TextPacketHandling textPacketHandling) {
        this.textPacketHandling = textPacketHandling;
    }

    public void switchToBinary() {
        this.type = ProtocolType.BINARY;
    }

    private boolean innerReadAndDecode(TCPSource source) {
        ReadableByteChannel channel = source.getChannel().getReadableChannel();
        boolean noError = true;
        try {
            int bytesRead;
            do {
                bytesRead = channel.read(this.inputBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug("Read %d bytes (common), protocolType = %s.", new Object[]{bytesRead, this.type.name()});
                }
                if (bytesRead >= 0) {
                    if (this.type == ProtocolType.TEXT) {
                        this.inputBuffer.flip();
                        byte[] temp = new byte[this.inputBuffer.remaining()];
                        this.inputBuffer.get(temp);
                        this.textBuffer.append(new String(temp, "US-ASCII"));
                        this.handleTextContents(source);
                        this.inputBuffer.compact();
                        if (this.type != ProtocolType.BINARY) continue;
                        this.inputBuffer.clear();
                        this.unprocessedBytes = 0;
                        this.bytesToProcessInBulk = 4;
                        this.readLength = true;
                        continue;
                    }
                    this.unprocessedBytes += bytesRead;
                    this.inputBuffer.flip();
                    while (this.unprocessedBytes >= this.bytesToProcessInBulk) {
                        if (this.readLength) {
                            this.unprocessedBytes -= this.bytesToProcessInBulk;
                            this.bytesToProcessInBulk = this.inputBuffer.getInt();
                        }
                        if (this.unprocessedBytes >= this.bytesToProcessInBulk) {
                            this.unprocessedBytes -= this.bytesToProcessInBulk;
                            logger.debug("handlingPacket ====");
                            this.handlePacketContents(source, this.inputBuffer, this.bytesToProcessInBulk);
                            this.bytesToProcessInBulk = 4;
                            this.readLength = true;
                            continue;
                        }
                        this.readLength = false;
                    }
                    this.inputBuffer.compact();
                    continue;
                }
                noError = false;
            } while (bytesRead > 0);
        }
        catch (NonReadableChannelException nrce) {
            logger.error("Channel was not opened for reading. Programming error.");
            noError = false;
        }
        catch (AsynchronousCloseException ace) {
            logger.info("Connection was closed by another thread.");
            noError = false;
        }
        catch (ClosedChannelException cce) {
            logger.info("Trying to operate on a closed channel.");
            noError = false;
        }
        catch (IOException ioe) {
            logger.error("Got I/O exception when reading from channel. Details: %s", new Object[]{ioe.getMessage()});
            logger.logException((Throwable)ioe);
            noError = false;
        }
        catch (Exception e) {
            logger.error("Got exception when reading from channel. Details: %s", new Object[]{e.getMessage()});
            logger.logException((Throwable)e);
            noError = false;
        }
        return noError;
    }

    public boolean readAndDecode(TCPSource source) {
        if (source.getChannel().getIOEndpoint() == IOLogicEndpoint.BUFFER) {
            this.readAndDecodeDirectly(source);
            return true;
        }
        return this.innerReadAndDecode(source);
    }

    private void readAndDecodeDirectly(TCPSource source) {
        try {
            ByteBuffer inboundBuffer = source.getChannel().getInboundDataBuffer();
            int bytesToProcess = inboundBuffer.position();
            if (bytesToProcess >= 0) {
                inboundBuffer.flip();
                if (this.type == ProtocolType.TEXT) {
                    byte[] temp = new byte[inboundBuffer.remaining()];
                    inboundBuffer.get(temp);
                    this.textBuffer.append(new String(temp, "US-ASCII"));
                    this.handleTextContents(source);
                    inboundBuffer.compact();
                    if (this.type == ProtocolType.BINARY) {
                        inboundBuffer.clear();
                        this.bytesToProcessInBulk = 4;
                        this.readLength = true;
                    }
                } else {
                    do {
                        if (this.inputBuffer.remaining() >= inboundBuffer.remaining()) {
                            this.inputBuffer.put(inboundBuffer);
                        } else {
                            byte[] destArray = new byte[this.inputBuffer.remaining()];
                            inboundBuffer.get(destArray);
                            this.inputBuffer.put(destArray);
                        }
                        this.inputBuffer.flip();
                        logger.debug("Unprocessed bytes: %d!", new Object[]{this.inputBuffer.remaining()});
                        if (this.inputBuffer.remaining() >= this.bytesToProcessInBulk) {
                            do {
                                if (this.readLength) {
                                    this.bytesToProcessInBulk = this.inputBuffer.getInt();
                                    this.binaryPacketHandlingBehaviour = this.bytesToProcessInBulk > 0 && this.inputBuffer.capacity() >= this.bytesToProcessInBulk ? LengthBasedPacketHandling.DEFAULT_HANDLING : LengthBasedPacketHandling.INADEQUATELY_SIZED_PACKET_HANDLING;
                                }
                                if (this.binaryPacketHandlingBehaviour == LengthBasedPacketHandling.DEFAULT_HANDLING) {
                                    if (this.inputBuffer.remaining() >= this.bytesToProcessInBulk) {
                                        logger.debug("handlingPacket ====");
                                        this.handlePacketContents(source, this.inputBuffer, this.bytesToProcessInBulk);
                                        this.bytesToProcessInBulk = 4;
                                        this.readLength = true;
                                        continue;
                                    }
                                    this.readLength = false;
                                    continue;
                                }
                                if (this.readLength) {
                                    logger.warn("Received inadequately-sized packet, packet length was = %d. Will close connection!", new Object[]{this.bytesToProcessInBulk});
                                }
                                this.inputBuffer.position(this.inputBuffer.limit());
                                this.bytesToProcessInBulk = 1;
                                this.readLength = false;
                            } while (this.inputBuffer.remaining() >= this.bytesToProcessInBulk);
                        }
                        logger.debug("InputBuffer before clear/compact: %s!", new Object[]{this.inputBuffer.toString()});
                        if (this.binaryPacketHandlingBehaviour == LengthBasedPacketHandling.INADEQUATELY_SIZED_PACKET_HANDLING) {
                            this.inputBuffer.clear();
                            continue;
                        }
                        this.inputBuffer.compact();
                    } while (inboundBuffer.remaining() > 0);
                    logger.debug("InboundBuffer before compact: %s!", new Object[]{inboundBuffer.toString()});
                    inboundBuffer.compact();
                    if (this.binaryPacketHandlingBehaviour == LengthBasedPacketHandling.INADEQUATELY_SIZED_PACKET_HANDLING) {
                        source.submitClose();
                    }
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not find encoding. Details: %s", new Object[]{uee.getMessage()});
        }
    }

    private void resetTextPacketContext() {
        this.currentPhase = TextProtocolPhase.FIRST_LINE;
        this.currentTextPacket = new RawTextPacket();
    }

    private void handleTextContents(TCPSource source) {
        int newLinePos;
        int currentPosition = 0;
        while ((newLinePos = this.textBuffer.indexOf("\r\n", currentPosition)) != -1) {
            if (newLinePos == currentPosition) {
                if (this.currentTextPacket.couldBeValid()) {
                    this.textPacketHandling.handleTextPacket(source, this.currentTextPacket);
                } else {
                    logger.error("Received invalid packet: %s.", new Object[]{this.currentTextPacket.toString()});
                }
                this.resetTextPacketContext();
                currentPosition = newLinePos + 2;
                continue;
            }
            String line = this.textBuffer.substring(currentPosition, newLinePos);
            if (this.currentPhase == TextProtocolPhase.FIRST_LINE) {
                this.currentTextPacket.setMessageKind(line);
                this.currentPhase = TextProtocolPhase.MESSAGE_TYPE;
                currentPosition = newLinePos + 2;
                continue;
            }
            if (this.currentPhase == TextProtocolPhase.MESSAGE_TYPE) {
                this.currentTextPacket.setMessageType(line);
                this.currentPhase = TextProtocolPhase.HEADER;
                currentPosition = newLinePos + 2;
                continue;
            }
            this.currentTextPacket.addHeaderLine(line);
            currentPosition = newLinePos + 2;
        }
        this.textBuffer.delete(0, currentPosition);
    }

    private void handlePacketContents(TCPSource source, ByteBuffer inboundBuffer, int bytesInPacket) {
        ThinAPPacket packet = ThinAPPacket.decode((ByteBuffer)inboundBuffer, (int)bytesInPacket, this.features);
        this.binaryPacketHandling.handlePacket(source, packet);
    }

    public void setFeatures(Set<Feature> features) {
        this.features = features;
    }

    static enum TextProtocolPhase {
        FIRST_LINE,
        MESSAGE_TYPE,
        HEADER;

    }

    static enum ProtocolType {
        TEXT,
        BINARY;

    }

    static enum LengthBasedPacketHandling {
        DEFAULT_HANDLING,
        INADEQUATELY_SIZED_PACKET_HANDLING;

    }
}

