/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.AccessPointConnectionManager;
import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.SoftSynchronizer;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.WirelessTransmitterBase;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.serial.ExposedByteArrayOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialHelper;
import at.mrdevelopment.esl.accesspoint.serial.SyncPacketHelper;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveDataCommand;
import at.mrdevelopment.esl.accesspoint.taskqueue.ReplyQueueEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.accesspoint.tcp.AccessPointSettingsReceiver;
import at.mrdevelopment.esl.accesspoint.tcp.ActiveCommandLogicThinAP;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelUtils;
import at.mrdevelopment.esl.accesspoint.tcp.CommandProcessResult;
import at.mrdevelopment.esl.accesspoint.tcp.ReplyData;
import at.mrdevelopment.esl.accesspoint.tcp.TCPSlotPipelineProcessing;
import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Reply;
import at.mrdevelopment.toolkit.FirmwareVersionProvider;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPReplyPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPUpdatePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;

public class TCPWirelessTransmitter
extends WirelessTransmitterBase
implements PacketDestinationStrategy {
    private static ESLLogger logger = ESLLogger.getLogger(TCPWirelessTransmitter.class);
    private static final int SYNC_PACKET_FIXED_DATA_LENGTH = 8;
    private static final int SYNC_PACKET_DATA_HEADER_LENGTH = 5;
    private static final int SYNC_PACKET_EMPTY_FLAG_LENGTH = 6;
    private static final int SYNC_PACKET_EMPTY_MASK_LENGTH = 2;
    private static final int SYNC_PACKET_JOIN_ALLOWED_LENGTH = 2;
    private static final int SYNC_HEADER_LENGTH = 5;
    private static final int SYNC_COMMANDS_LENGTH = 19;
    private static final int SYNC_KEYS_LENGTH = 48;
    private final int accessPointId;
    private final AccessPointConnectionManager connectionManager;
    private SlotId lastRequestedSlot = new SlotId(0);
    private SlotId nextSyncToSend = null;
    private int channel;
    private int replyStatus;
    private TCPSlotPipelineProcessing pipelineProcessing;
    private ActiveCommandLogicThinAP activeCommandsLogic;
    private SlotIdReader slotIdReader;
    private FirmwareVersionProvider firmwareVersionProvider;
    private final SoftSynchronizer softSynchronizer;
    private final AccessPointSettingsReceiver settingsReceiver;
    private Set<Feature> featureSet;

    public TCPWirelessTransmitter(SlotPipeline slotPipeline, TCPSlotPipelineProcessing pipelineProcessing, SoftSynchronizer softSynchronizer, ProtocolSettingsProvider protocolSettingsProvider, int accessPointId, AccessPointConnectionManager connectionManager, FirmwareVersionProvider firmwareVersionProvider, SlotIdReader slotIdReader, AccessPointSettingsReceiver settingsReceiver) {
        super(slotPipeline, protocolSettingsProvider);
        this.pipelineProcessing = pipelineProcessing;
        this.accessPointId = accessPointId;
        this.connectionManager = connectionManager;
        this.activeCommandsLogic = new ActiveCommandLogicThinAP();
        this.firmwareVersionProvider = firmwareVersionProvider;
        this.slotIdReader = slotIdReader;
        this.softSynchronizer = softSynchronizer;
        this.settingsReceiver = settingsReceiver;
        this.featureSet = new HashSet<Feature>();
    }

    public void accept(TCPPacket packet) {
        try {
            this.handlePacket(packet.getSource(), packet);
        }
        catch (IOException ioe) {
            logger.logException((Throwable)ioe);
        }
    }

    private void handlePacket(TCPSource source, TCPPacket packet) throws IOException {
        if (this.shutdownRequested()) {
            return;
        }
        if (packet instanceof ThinAPReplyPacket) {
            ThinAPReplyPacket replyPacket = (ThinAPReplyPacket)packet;
            logger.debug("Received replyPacket with firstSlotId = %d.", new Object[]{replyPacket.getFirstSlotId()});
            ReplyData[] replies = new ReplyData[replyPacket.getSlotReplyCount()];
            DateTime now = DateTime.now();
            for (int idx = 0; idx < replyPacket.getSlotReplyCount(); ++idx) {
                boolean channelOccupied;
                replies[idx] = new ReplyData();
                replies[idx].slotId = this.slotIdReader.getSlotId(replyPacket.getFirstSlotId() + idx);
                ByteArrayInputStream dataWrapper = new ByteArrayInputStream(replyPacket.getReplyDataByIdx(idx));
                FrameInputStream inputStream = new FrameInputStream(dataWrapper);
                int requestStatusByte = inputStream.readByte();
                replies[idx].uartReplyError = (requestStatusByte & 8) != 0;
                boolean otherSyncDetected = (requestStatusByte & 0x20) != 0;
                boolean bl = channelOccupied = (requestStatusByte & 0x10) != 0;
                if (replies[idx].uartReplyError) {
                    logger.debug("UART reply received too late or was corrupt (slot %s)", new Object[]{replies[idx].slotId});
                }
                if (otherSyncDetected) {
                    replies[idx].problems.add(AccessPointProblem.OTHER_SYNC_DETECTED);
                }
                if (channelOccupied) {
                    replies[idx].problems.add(AccessPointProblem.CHANNEL_OCCUPIED);
                }
                replies[idx].transmissionStatus = TransmissionStatus.fromCode(requestStatusByte & 7);
                replies[idx].transmissionInfo = inputStream.readTransmissionInfo();
                logger.debug("Transmission status: %s.", new Object[]{replies[idx].transmissionStatus});
                for (int replySlot = 0; replySlot < 3; ++replySlot) {
                    Reply reply = SerialHelper.receiveReplyPacket(inputStream, now, replySlot);
                    if (reply == null) continue;
                    replies[idx].replies[reply.getReplySlot()] = reply;
                }
                for (int joinSlot = 0; joinSlot < 5; ++joinSlot) {
                    JoinRequest joinRequest;
                    replies[idx].joinRequests[joinSlot] = joinRequest = SerialHelper.receiveJoinRequest(inputStream, now);
                }
                if (this.firmwareVersionProvider.getFirmwareVersion().isEqualOrNewer(ProtocolSettings.LABEL_EVENTS_VERSION)) {
                    for (int eventSlot = 0; eventSlot < 5; ++eventSlot) {
                        EventPacket eventPacket;
                        replies[idx].events[eventSlot] = eventPacket = SerialHelper.receiveLabelEvent(inputStream, now);
                    }
                }
                replies[idx].nextPartId = inputStream.readWord();
                replies[idx].partCount = inputStream.readByte();
                if (replies[idx].nextPartId <= 0 && replies[idx].partCount <= 0) continue;
                logger.debug("Part = %d, Count = %d.", new Object[]{replies[idx].nextPartId, replies[idx].partCount});
            }
            this.addRepliesAndForwardSyncPackets(replyPacket, replies, now);
        } else if (packet instanceof ThinAPUpdatePacket) {
            ThinAPUpdatePacket updatePacket = (ThinAPUpdatePacket)packet;
            logger.info("Received ThinAPUpdatePacket.", new Object[]{updatePacket.getChannel()});
            try {
                WirelessChannel channel = ChannelUtils.intToChannel(updatePacket.getChannel());
                this.settingsReceiver.updateChannel(channel);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.error("Got invalid channel in update packet.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInitialSyncPacket(boolean isFirst) {
        DateTime now = DateTime.now();
        LinkedList<SyncPacket> syncs = new LinkedList<SyncPacket>();
        SlotPipeline slotPipeline = this.slotPipeline;
        synchronized (slotPipeline) {
            for (int idx = 0; idx < this.slotPipeline.getSize(); ++idx) {
                syncs.add(this.getSyncPacketForThinAP(this.nextSyncToSend, 0, now));
                this.nextSyncToSend = this.nextSyncToSend.next();
            }
        }
        this.assembleAndForward(syncs, isFirst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepliesAndForwardSyncPackets(ThinAPReplyPacket replyPacket, ReplyData[] replyData, DateTime now) {
        LinkedList<SyncPacket> syncs = new LinkedList<SyncPacket>();
        SlotPipeline slotPipeline = this.slotPipeline;
        synchronized (slotPipeline) {
            for (ReplyData data : replyData) {
                this.addRepliesForThinAP(data.slotId, data.transmissionStatus, data.transmissionInfo, data.replies, data.joinRequests, data.events, data.uartReplyError, data.problems);
            }
        }
        if (replyData.length > 0) {
            SlotId newSlotRequest = replyData[0].slotId;
            if (!newSlotRequest.isNextOf(this.lastRequestedSlot)) {
                logger.warn("Next slot was not the expected slot ThinAP 2.0 protocol error.");
            } else if (replyPacket.isRestartSlotSet()) {
                this.reinitializeAndRestart(new SlotId(replyPacket.getRestartSlotId()));
            } else {
                this.softSynchronizer.want(this.commandCreator.getLastSyncQueueCommandIdx());
                SlotPipeline slotPipeline2 = this.slotPipeline;
                synchronized (slotPipeline2) {
                    for (int idx = 0; idx < replyData.length; ++idx) {
                        syncs.add(this.getSyncPacketForThinAP(this.nextSyncToSend, 0, now));
                        this.nextSyncToSend = this.nextSyncToSend.next();
                    }
                }
                this.lastRequestedSlot = replyData[replyData.length - 1].slotId;
                if (!this.shutdownRequested()) {
                    this.assembleAndForward(syncs, false);
                }
            }
        } else if (replyPacket.isRestartSlotSet()) {
            this.reinitializeAndRestart(new SlotId(replyPacket.getRestartSlotId()));
        } else {
            logger.error("Got ThinAPReplyPacket witch did not have a restart slot set and also didn't have any reply data. Should never happen!");
        }
    }

    public void reinitializeAndRestart(SlotId newSlotId) {
        this.nextSyncToSend = newSlotId;
        logger.info("Reinitialize and restart.");
        logger.info("Sending new initial sync packets with starting slot: %s", new Object[]{this.nextSyncToSend});
        this.pipelineProcessing.reInitializeAndWait(newSlotId);
        this.lastRequestedSlot = this.nextSyncToSend.previous(1);
        this.activeCommandsLogic.reset();
        this.commandCreator.reset();
        this.softSynchronizer.reset();
        this.sendInitialSyncPacket(true);
        this.sendInitialSyncPacket(false);
    }

    private void assembleAndForward(List<SyncPacket> syncs, boolean isInitialSyncBatch) {
        try {
            ProtocolSettings protocolSettings = this.getProtocolSettings();
            LinkedList<SyncPacket> syncsWithData = new LinkedList<SyncPacket>();
            int syncSendMask = 65535;
            int emptySyncJoinMask = 0;
            int emptySyncs = 0;
            int syncsDataLength = 0;
            boolean emptySyncOptimizationEnabled = this.featureSet.contains(Feature.EMPTY_SYNC_OPTIMIZATION);
            boolean joinAllowedFlagSet = this.featureSet.contains(Feature.JOIN_ALLOWED_FLAG);
            boolean skipEmptySyncs = emptySyncOptimizationEnabled && !isInitialSyncBatch && this.channel == protocolSettings.getLogicalChannel() && this.replyStatus == SerialHelper.getReplyStatus(protocolSettings);
            for (SyncPacket sync : syncs) {
                if (sync.getCommandType().isDataInit()) {
                    syncsWithData.add(sync);
                    syncsDataLength += sync.getDataCommand().getDataLength();
                }
                if (!skipEmptySyncs || !sync.getCommandType().isEmpty()) continue;
                ++emptySyncs;
                syncSendMask &= ~(1 << syncs.indexOf((Object)sync));
                if (!sync.isJoinRequestAllowed()) continue;
                emptySyncJoinMask &= 1 << syncs.indexOf((Object)sync);
            }
            int syncsLength = (16 - emptySyncs) * 72;
            int packetLength = 8 + syncsLength + (syncsDataLength += 5 * syncsWithData.size()) + (emptySyncs > 0 ? 2 : 0) + (joinAllowedFlagSet ? 2 : 0);
            ExposedByteArrayOutputStream exposedOutputStream = new ExposedByteArrayOutputStream(4 + packetLength);
            FrameOutputStream outputStream = new FrameOutputStream(exposedOutputStream);
            int syncLength = 72;
            if (emptySyncOptimizationEnabled) {
                syncLength <<= 6;
                if (emptySyncs > 0) {
                    syncLength |= 1;
                }
            }
            outputStream.writeInteger32(packetLength);
            outputStream.writeByte(ThinAPPacketIdentifier.SYNC.header());
            outputStream.writeByte(isInitialSyncBatch ? 1 : 0);
            outputStream.writeWord(this.slotIdReader.getSlotIdForThinAp(syncs.get(0).getSlotId().getId()));
            outputStream.writeByte(syncs.size());
            outputStream.writeWord(syncLength);
            if (emptySyncs > 0) {
                outputStream.writeWord(syncSendMask);
                if (joinAllowedFlagSet) {
                    outputStream.writeWord(emptySyncJoinMask);
                }
            }
            for (SyncPacket sync : syncs) {
                if (skipEmptySyncs && sync.getCommandType().isEmpty()) continue;
                int replyStatusByte = SerialHelper.getReplyStatus(protocolSettings);
                int slotInfoWord = this.slotIdReader.getSlotInfoWordForThinAp(sync.getSlotId().getId(), sync);
                outputStream.writeByte(175);
                outputStream.writeWord(slotInfoWord);
                outputStream.writeByte(protocolSettings.getLogicalChannel());
                outputStream.write(replyStatusByte);
                SyncPacketHelper.sendCommands(sync, outputStream);
                SyncPacketHelper.sendKeys(sync, outputStream);
                this.channel = protocolSettings.getLogicalChannel();
                this.replyStatus = replyStatusByte;
            }
            outputStream.write(syncsWithData.size());
            for (SyncPacket sync : syncsWithData) {
                outputStream.write(sync.getSlotId().getId() - syncs.get(0).getSlotId().getId());
                outputStream.writeInteger32(sync.getDataCommand().getDataLength());
                outputStream.writeBytes(sync.getDataCommand().getDataBytes());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Sending SYNC message.Length = %d\n", new Object[]{exposedOutputStream.size()});
            }
            this.connectionManager.forwardMessage(exposedOutputStream.getBackingArray(), exposedOutputStream.size(), this.accessPointId);
        }
        catch (IOException ioe) {
            logger.logException((Throwable)ioe);
        }
    }

    protected SyncPacket getSyncPacketForThinAP(SlotId slotId, int blockedSlots, DateTime now) {
        ProtocolSettings protocolSettings = this.protocolSettingsProvider.getProtocolSettings();
        SyncPacket syncPacket = this.slotPipeline.getSyncForForwarding(slotId);
        if (syncPacket == null) {
            logger.info("Sync queue is empty at slot %s", new Object[]{slotId});
            return SyncPacket.createInvalid(slotId, protocolSettings.getSyncProfile(), 3);
        }
        if (!syncPacket.getSlotId().equals(slotId)) {
            logger.info("Sync did not match slot %s!", new Object[]{slotId});
            return SyncPacket.createInvalid(slotId, protocolSettings.getSyncProfile(), 3);
        }
        if (syncPacket.getCommandType().isDataInit()) {
            CommittedDataCommand<?> dataCommand = syncPacket.getDataCommand();
            this.activeCommandsLogic.add(new ActiveDataCommand(dataCommand, slotId));
        }
        return syncPacket.withCorrectCommandType();
    }

    protected void addRepliesForThinAP(SlotId slotId, TransmissionStatus transmissionStatus, TransmissionInfo transmissionInfo, Reply[] replies, JoinRequest[] joinRequests, EventPacket[] events, boolean uartError, Collection<AccessPointProblem> problems) {
        CommandProcessResult result = this.activeCommandsLogic.delayedProcess(slotId, transmissionStatus);
        ActiveDataCommand tempCommand = result.getCurrentCommand() != null ? result.getCurrentCommand() : ActiveDataCommand.EMPTY;
        this.slotPipeline.addReplies(new ReplyQueueEntry(slotId.forReply(), transmissionStatus, transmissionInfo, tempCommand.getTransmissionSlots(), replies, joinRequests, events, uartError, problems, tempCommand.getCommandId(), result.getErrorType(), result.getErrorCommandId()), this.commandCreator);
    }

    public int getApId() {
        return this.accessPointId;
    }

    public Set<Feature> getFeatureSet() {
        return Collections.unmodifiableSet(this.featureSet);
    }

    public void setFeatureSet(Set<Feature> featureSet) {
        this.featureSet = featureSet;
    }
}

