/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.AccessPointConnectionManager;
import at.mrdevelopment.esl.accesspoint.tcp.BaseTCPChannelTask;
import at.mrdevelopment.esl.accesspoint.tcp.SlotChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.ThinAPProtocolV20Strategy;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPConnectionParameters;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import java.io.IOException;

public class TCPSlotChannelTask
extends BaseTCPChannelTask
implements AccessPointConnectionManager {
    private final int apId;
    private SlotChannelHandler slotChannelHandler;
    private PacketDestinationStrategy binaryPacketDestination;

    public TCPSlotChannelTask(int apId, TCPCoreConfig tcpConfig, TCPCore tcpCore, int remotePort) throws IOException {
        super(tcpConfig, tcpCore, remotePort, null);
        this.apId = apId;
    }

    public void setSlotChannelHandler(SlotChannelHandler slotChannelHandler) {
        this.slotChannelHandler = slotChannelHandler;
    }

    public void setBinaryPacketDestination(PacketDestinationStrategy binaryPacketDestination) {
        this.binaryPacketDestination = binaryPacketDestination;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    protected void doIfConnected() {
    }

    @Override
    protected void setConnectionStateToOffline() {
    }

    @Override
    protected TCPEventStrategy createEventStrategy() {
        ThinAPProtocolV20Strategy protocolStrategy = new ThinAPProtocolV20Strategy(this.tcpConfig.getInputBufferSize(), CommunicationChannelType.SLOT, this.apId);
        protocolStrategy.setBinaryPacketDestinationStrategy(this.binaryPacketDestination);
        protocolStrategy.setTextPacketDestinationStrategy(this.slotChannelHandler);
        return protocolStrategy;
    }

    @Override
    public void forwardMessage(byte[] data, int filledBytes, int accessPointId) {
        this.tcpCore.submit(new WriteTask(this.communicationChannel, data, filledBytes));
    }

    @Override
    protected void initiatingConnectionWith(TCPCommunicationChannel newChannel) {
    }

    @Override
    protected TCPCommunicationChannel createTCPCommunicationChannel() {
        return this.tcpCore.createTCPCommunicationChannel(this.tcpConfig, TCPConnectionParameters.TCP_TLS_AS_SERVER);
    }
}

