/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.accesspoint.ChannelStatus;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelStatusWrapper;
import at.mrdevelopment.esl.accesspoint.tcp.CommunicationDaemonInfoHolder;
import at.mrdevelopment.esl.accesspoint.tcp.SlotChannelHandler;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;

public class TCPHolder
implements ChannelStatusProvider,
DaemonInfoProvider,
Shutdownable {
    private final TCPCommunicationChannel commChannel;
    private ChannelStatusWrapper channelStatusWrapper;
    private CommunicationDaemonInfoHolder daemonInfoHolder;

    public TCPHolder(SlotChannelHandler handler, TCPCommunicationChannel commChannel) {
        this.commChannel = commChannel;
        this.channelStatusWrapper = new ChannelStatusWrapper();
        this.daemonInfoHolder = new CommunicationDaemonInfoHolder();
        handler.setChannelStatusWrapper(this.channelStatusWrapper);
        handler.setDaemonInfoHolder(this.daemonInfoHolder);
    }

    public TCPCommunicationChannel getChannel() {
        return this.commChannel;
    }

    @Override
    public Pair<String, String> getVersionAndDeviceType() {
        return this.daemonInfoHolder.getData();
    }

    @Override
    public ChannelStatus getControlChannelStatus() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSlotChannelRemoteEndpoint() {
        String endpoint = this.channelStatusWrapper.getSlotChannelRemoteEndpoint();
        return endpoint == null ? "" : endpoint;
    }

    public void shutdown() {
        this.channelStatusWrapper.disconnectHappened();
        this.daemonInfoHolder.disconnectHappened();
        this.commChannel.shutdownOperation();
    }
}

