/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.accesspoint.ChannelStatus;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.accesspoint.tcp.BaseTCPChannelTask;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelStatusWrapper;
import at.mrdevelopment.esl.accesspoint.tcp.CommunicationDaemonInfoHolder;
import at.mrdevelopment.esl.accesspoint.tcp.ControlChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.TCPConfigurationUpdate;
import at.mrdevelopment.esl.accesspoint.tcp.ThinAPProtocolV20Strategy;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPConnectionParameters;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import java.io.IOException;
import java.net.UnknownHostException;

public class TCPControlChannelTask
extends BaseTCPChannelTask
implements ChannelStatusProvider,
DaemonInfoProvider {
    private final int apId;
    private final ControlChannelHandler controlChannelHandler;
    private final TCPConfigurationUpdate configurationUpdateLogic = new TCPConfigurationUpdate();
    private final AccessPointConfigurationManager configurationManager;
    private ChannelStatusWrapper channelStatusWrapper;
    private CommunicationDaemonInfoHolder daemonInfoHolder;

    public TCPControlChannelTask(int apId, TCPCoreConfig tcpConfig, TCPCore tcpCore, int remotePort, ControlChannelHandler controlChannelHandler, AccessPointConfigurationManager configurationManager) throws UnknownHostException, IOException {
        super(tcpConfig, tcpCore, remotePort, "127.0.0.1");
        this.controlChannelHandler = controlChannelHandler;
        this.controlChannelHandler.setConfigurationUpdate(this.configurationUpdateLogic);
        this.channelStatusWrapper = new ChannelStatusWrapper();
        this.daemonInfoHolder = new CommunicationDaemonInfoHolder();
        this.controlChannelHandler.setChannelStatusWrapper(this.channelStatusWrapper);
        this.controlChannelHandler.setDaemonInfoHolder(this.daemonInfoHolder);
        this.configurationManager = configurationManager;
        this.apId = apId;
    }

    @Override
    protected void doIfConnected() {
        this.configurationUpdateLogic.sendConfigurationUpdateIfNecessary(this.configurationManager.getWirelessConfiguration(), this.configurationManager.getThinAPConfiguration(), this.communicationChannel.getSource());
    }

    @Override
    protected void setConnectionStateToOffline() {
        this.channelStatusWrapper.disconnectHappened();
        this.daemonInfoHolder.disconnectHappened();
    }

    @Override
    protected TCPEventStrategy createEventStrategy() {
        ThinAPProtocolV20Strategy protocolStrategy = new ThinAPProtocolV20Strategy(this.tcpConfig.getInputBufferSize(), CommunicationChannelType.CONFIG_CONTROL, this.apId);
        protocolStrategy.setTextPacketDestinationStrategy(this.controlChannelHandler);
        return protocolStrategy;
    }

    @Override
    public ChannelStatus getControlChannelStatus() {
        return this.channelStatusWrapper.getControlChannelStatus();
    }

    @Override
    public String getSlotChannelRemoteEndpoint() {
        String endpoint = this.channelStatusWrapper.getSlotChannelRemoteEndpoint();
        return endpoint == null ? "" : endpoint;
    }

    @Override
    protected void initiatingConnectionWith(TCPCommunicationChannel newChannel) {
        this.channelStatusWrapper.newConnection(newChannel);
        this.controlChannelHandler.resetInternalLogic();
    }

    @Override
    public Pair<String, String> getVersionAndDeviceType() {
        return this.daemonInfoHolder.getData();
    }

    @Override
    protected TCPCommunicationChannel createTCPCommunicationChannel() {
        return this.tcpCore.createTCPCommunicationChannel(this.tcpConfig, TCPConnectionParameters.BASIC_TCP);
    }
}

