/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.tcp.ChannelUtils;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigUpdateRequestPacket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TCPConfigurationUpdate {
    private static ESLLogger logger = ESLLogger.getLogger(TCPConfigurationUpdate.class);
    private WirelessConfiguration lastSentConfiguration = null;
    private ThinAPConfiguration lastSentThinAPConfiguration = null;
    private final Lock lock = new ReentrantLock();

    private boolean isDifferentFrom(WirelessConfiguration newConfig, ThinAPConfiguration newThinAPConfiguration) {
        boolean isDifferent = this.lastSentConfiguration != null && (this.lastSentConfiguration.getChannel() != newConfig.getChannel() || this.lastSentConfiguration.getRadioOutputPowerLevel() != newConfig.getRadioOutputPowerLevel());
        isDifferent = isDifferent || this.lastSentThinAPConfiguration != null && (!this.lastSentThinAPConfiguration.getApcAddress().equals(newThinAPConfiguration.getApcAddress()) || this.lastSentThinAPConfiguration.getApcPort() != newThinAPConfiguration.getApcPort());
        return isDifferent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSentConfiguration(WirelessConfiguration newConfig, ThinAPConfiguration newThinAPConfiguration) {
        try {
            this.lock.lock();
            this.lastSentConfiguration = newConfig;
            this.lastSentThinAPConfiguration = newThinAPConfiguration;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConfigurationUpdateIfNecessary(WirelessConfiguration newConfiguration, ThinAPConfiguration newThinApConfiguration, TCPSource source) {
        try {
            this.lock.lock();
            if (this.isDifferentFrom(newConfiguration, newThinApConfiguration)) {
                logger.warn("Last configuration is different to the new one, submitting configuration update!");
                this.lastSentConfiguration = newConfiguration;
                this.lastSentThinAPConfiguration = newThinApConfiguration;
                byte[] packetData = ConfigUpdateRequestPacket.create((String)ChannelUtils.channelToString(newConfiguration.getChannel()), (String)newConfiguration.getRadioOutputPowerLevel().name(), (String)newThinApConfiguration.getApcAddress(), (int)newThinApConfiguration.getApcPort());
                source.submit(packetData, packetData.length);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

