/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.tcp.AccessPointSettingsReceiver;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelStatusWrapper;
import at.mrdevelopment.esl.accesspoint.tcp.CommunicationDaemonInfoHolder;
import at.mrdevelopment.esl.accesspoint.tcp.TCPWirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.tcp.ThinAPProtocolV20Strategy;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationRequestPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;

public class SlotChannelHandler
implements PacketDestinationStrategy {
    private static final ESLLogger logger = ESLLogger.getLogger(SlotChannelHandler.class);
    private final int apId;
    private final TCPWirelessTransmitter thinAPTransmitter;
    private final AccessPointSettingsReceiver settingsReceiver;
    private ChannelStatusWrapper channelStatusWrapper;
    private CommunicationDaemonInfoHolder daemonInfoHolder;

    public SlotChannelHandler(int apId, AccessPointSettingsReceiver updateReceiver, TCPWirelessTransmitter thinAPTransmitter) {
        this.apId = apId;
        this.settingsReceiver = updateReceiver;
        this.thinAPTransmitter = thinAPTransmitter;
    }

    public void setChannelStatusWrapper(ChannelStatusWrapper statusWrapper) {
        this.channelStatusWrapper = statusWrapper;
    }

    public void setDaemonInfoHolder(CommunicationDaemonInfoHolder daemonInfoHolder) {
        this.daemonInfoHolder = daemonInfoHolder;
    }

    public void accept(TCPPacket packet) {
        TCPSource source = packet.getSource();
        ThinAPTextPacket textPacket = (ThinAPTextPacket)packet;
        if (textPacket.getType() == ThinAPPacketIdentifier.CONFIGURATION_RESPONSE) {
            ConfigurationResponsePacket response = (ConfigurationResponsePacket)textPacket;
            if (response.getResponseCode() == ConfigResponseCode.SUCCESS) {
                if (this.channelStatusWrapper != null) {
                    this.channelStatusWrapper.slotChannelConnected();
                }
                this.thinAPTransmitter.setFeatureSet(response.getFeatureSet());
                ThinAPProtocolV20Strategy strategy = (ThinAPProtocolV20Strategy)source.getChannel().getProtocolStrategy();
                strategy.setFeatures(response.getFeatureSet());
                strategy.switchToBinary();
                this.thinAPTransmitter.reinitializeAndRestart(new SlotId(response.getInitialSlot()));
                logger.info("Got: %s. Configuration successful.", new Object[]{textPacket.getType().name()});
            } else {
                logger.error("Got: %s. Configuration failed.", new Object[]{textPacket.getType().name()});
            }
        } else if (textPacket.getType() == ThinAPPacketIdentifier.INTRODUCTION_RESPONSE) {
            IntroductionResponsePacket response = (IntroductionResponsePacket)textPacket;
            if (response.getResponseCode() == IntroductionResponseCode.SUCCESS) {
                if (this.apId == response.getAccessPointId() && 2 == response.getProtocolVersion()) {
                    this.settingsReceiver.updateFirmaware(response.getFwVersion());
                    if (this.daemonInfoHolder != null) {
                        this.daemonInfoHolder.setData(response.getSwVersion(), response.getDeviceType());
                    }
                    this.settingsReceiver.updateMaxAllowedWindowSize(response.getMaxWindowSize());
                    try {
                        WirelessChannel channel = response.getEslChannel() < 0 ? null : WirelessChannel.getFromId((int)response.getEslChannel().shortValue());
                        this.settingsReceiver.updateChannel(channel);
                        byte[] packetData = ConfigurationRequestPacket.create();
                        source.submit(packetData, packetData.length);
                        logger.info("Got: %s, responding with: %s.", new Object[]{textPacket.getType().name(), ThinAPPacketIdentifier.CONFIGURATION_REQUEST.name()});
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.error("Got invalid channel in %s message!", new Object[]{ThinAPPacketIdentifier.INTRODUCTION_RESPONSE.name()});
                        source.submitClose();
                    }
                } else {
                    logger.error("Got: %s. Could not establish connection with SCD, closing channel. [AP-ID, PROTOCOL_VERSION] - expected: [%d, %d], got: [%d, %d].", new Object[]{textPacket.getType().name(), this.apId, (byte)2, response.getAccessPointId(), (byte)response.getProtocolVersion()});
                    source.submitClose();
                }
            } else {
                logger.error("Got: %s. With following response code - %s, closing channel.", new Object[]{textPacket.getType().name(), response.getResponseCode().getText()});
                source.submitClose();
            }
        } else {
            logger.error("Got: %s, which is unhandled in logic.", new Object[]{textPacket.getType().name()});
        }
    }

    public int getApId() {
        return this.apId;
    }
}

