/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigUpdateResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigurationResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ExtendedInfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.RawTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;

public class DefaultTextPacketLogic {
    private static ESLLogger logger = ESLLogger.getLogger(DefaultTextPacketLogic.class);
    private final CommunicationChannelType channelType;
    private PacketDestinationStrategy destinationStrategy;

    public DefaultTextPacketLogic(CommunicationChannelType channelType) {
        if (channelType == CommunicationChannelType.UNKNOWN) {
            throw new IllegalArgumentException(channelType.getText());
        }
        this.channelType = channelType;
    }

    public void set(PacketDestinationStrategy destinationStrategy) {
        this.destinationStrategy = destinationStrategy;
    }

    public void handle(TCPSource source, RawTextPacket textPacket) {
        ThinAPTextPacketKind kind = ThinAPTextPacketKind.from((String)textPacket.getMessageKind());
        String[] pair = textPacket.getMessageType().split(": ");
        if (pair.length == 2 && "Message-Type".equals(pair[0].trim())) {
            IntroductionResponsePacket newPacket = null;
            String type = pair[1].trim();
            if (this.channelType == CommunicationChannelType.SLOT) {
                switch (kind) {
                    case RESPONSE: {
                        if (type.equals("Introduction")) {
                            newPacket = new IntroductionResponsePacket();
                            break;
                        }
                        if (type.equals("Configuration")) {
                            newPacket = new ConfigurationResponsePacket();
                            break;
                        }
                        logger.info("Got an unknown text message response, on the slot channel!");
                        break;
                    }
                    default: {
                        logger.info("Got text message that was not a response, on the slot channel!");
                        break;
                    }
                }
            } else if (this.channelType == CommunicationChannelType.CONFIG_CONTROL) {
                switch (kind) {
                    case ONE_WAY: {
                        if (type.equals("Info")) {
                            newPacket = new InfoPacket();
                            break;
                        }
                        if (type.equals("Extended-Info")) {
                            newPacket = new ExtendedInfoPacket();
                            break;
                        }
                        logger.info("Got an unknown one way message!");
                        break;
                    }
                    case RESPONSE: {
                        if (type.equals("Introduction")) {
                            newPacket = new IntroductionResponsePacket();
                            break;
                        }
                        if (type.equals("Config-Update")) {
                            newPacket = new ConfigUpdateResponsePacket();
                            break;
                        }
                        logger.info("Got an unknown text message response, on the control channel!");
                        break;
                    }
                    case REQUEST: {
                        logger.info("Got an unknown text message request, on the control channel!");
                        break;
                    }
                    default: {
                        logger.info("Got text message that was not a response, on the control channel!");
                    }
                }
            }
            if (newPacket != null) {
                DefaultTextPacketLogic.setHeaders(textPacket, newPacket);
                if (newPacket.isValid()) {
                    newPacket.setSource(source);
                    this.destinationStrategy.accept((TCPPacket)newPacket);
                } else {
                    logger.debug("Packet %s is not valid", new Object[]{newPacket.getType()});
                }
            } else {
                logger.info("Got unsupported message - kind: %s, type: %s.", new Object[]{kind.getText(), type});
            }
        } else {
            logger.info("Could not handle following message-type line: %s. Ignoring everything afterwards.", new Object[]{textPacket.getMessageType()});
        }
    }

    public static void setHeaders(RawTextPacket textPacket, ThinAPTextPacket endPacket) {
        for (String headerLine : textPacket.getHeaderLines()) {
            if (endPacket.anyHeaderLineFailed()) continue;
            String[] pair = headerLine.split(": ");
            if (pair.length == 2) {
                endPacket.setTextHeader(pair[0].trim(), pair[1].trim());
                continue;
            }
            endPacket.headerLineFailed();
            logger.warn("Could not parse following header line: %s.", new Object[]{headerLine});
        }
    }
}

