/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelStatusWrapper;
import at.mrdevelopment.esl.accesspoint.tcp.ChannelUtils;
import at.mrdevelopment.esl.accesspoint.tcp.CommunicationDaemonInfoHolder;
import at.mrdevelopment.esl.accesspoint.tcp.InfoPacketHolder;
import at.mrdevelopment.esl.accesspoint.tcp.TCPConfigurationUpdate;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.thinap.PacketDestinationStrategy;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AlivePingPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigUpdateRequestPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigUpdateResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ExtendedInfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponsePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;

public class ControlChannelHandler
implements PacketDestinationStrategy {
    private static final ESLLogger logger = ESLLogger.getLogger(ControlChannelHandler.class);
    private final AccessPointSystemAttributes systemAttributes;
    private final AccessPointConfigurationManager configurationManager;
    private final AccessPointRuntimeConfiguration apRuntimeConfiguration;
    private TCPConfigurationUpdate configUpdate;
    private final InfoPacketHolder infoPacketHolder;
    private ChannelStatusWrapper channelStatusWrapper;
    private CommunicationDaemonInfoHolder daemonInfoHolder;
    private AtomicBoolean initialSuccessfulConfigUpdateResponse;

    public ControlChannelHandler(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration apRuntimeConfiguration, InfoPacketHolder infoPacketHolder) {
        this.configurationManager = configurationManager;
        this.systemAttributes = systemAttributes;
        this.apRuntimeConfiguration = apRuntimeConfiguration;
        this.infoPacketHolder = infoPacketHolder;
        this.initialSuccessfulConfigUpdateResponse = new AtomicBoolean(false);
    }

    void resetInternalLogic() {
        this.initialSuccessfulConfigUpdateResponse.set(false);
    }

    void setConfigurationUpdate(TCPConfigurationUpdate configUpdate) {
        this.configUpdate = configUpdate;
    }

    void setDaemonInfoHolder(CommunicationDaemonInfoHolder daemonInfoHolder) {
        this.daemonInfoHolder = daemonInfoHolder;
    }

    void setChannelStatusWrapper(ChannelStatusWrapper statusWrapper) {
        this.channelStatusWrapper = statusWrapper;
    }

    public void accept(TCPPacket packet) {
        TCPSource source = packet.getSource();
        ThinAPTextPacket textPacket = (ThinAPTextPacket)packet;
        if (textPacket.getType() == ThinAPPacketIdentifier.INFO) {
            InfoPacket infoPacket = (InfoPacket)textPacket;
            if (this.channelStatusWrapper.acceptMessage(source.getChannel(), infoPacket.getControllerAddress())) {
                logger.info("Got: %s. Answering with ALIVE-PING.", new Object[]{textPacket.getType().name()});
                source.submit(AlivePingPacket.ALIVE_PING_INSTANCE, AlivePingPacket.ALIVE_PING_INSTANCE.length);
                this.infoPacketHolder.setInfoPacket(infoPacket);
            }
        } else if (textPacket.getType() == ThinAPPacketIdentifier.EXTENDED_INFO) {
            ExtendedInfoPacket extendedInfoPacket = (ExtendedInfoPacket)textPacket;
            if (this.channelStatusWrapper.acceptMessage(source.getChannel(), extendedInfoPacket.getControllerAddress())) {
                logger.info("Got: %s. Answering with ALIVE-PING.", new Object[]{textPacket.getType().name()});
                source.submit(AlivePingPacket.ALIVE_PING_INSTANCE, AlivePingPacket.ALIVE_PING_INSTANCE.length);
                this.infoPacketHolder.setExtendedInfoPacket(extendedInfoPacket);
            }
        } else if (textPacket.getType() == ThinAPPacketIdentifier.CONFIG_UPDATE_RESPONSE) {
            ConfigUpdateResponsePacket response = (ConfigUpdateResponsePacket)textPacket;
            if (response.getResponseCode() == ConfigResponseCode.SUCCESS) {
                logger.info("Got: %s. Update successful.", new Object[]{textPacket.getType().name()});
                this.initialSuccessfulConfigUpdateResponse.compareAndSet(false, true);
            } else {
                logger.error("Got: %s. Update failed. Parse errors: %s. Update errors: %s.", new Object[]{textPacket.getType().name(), StringUtils.join((Object[])response.getParseErrorFields(), (String)", "), StringUtils.join((Object[])response.getUpdateErrorFields(), (String)", ")});
                if (!this.initialSuccessfulConfigUpdateResponse.get()) {
                    logger.error("Initial configuration update request was not successful, closing connection.");
                    source.submitClose();
                }
            }
        } else if (textPacket.getType() == ThinAPPacketIdentifier.INTRODUCTION_RESPONSE) {
            IntroductionResponsePacket response = (IntroductionResponsePacket)textPacket;
            if (response.getResponseCode() == IntroductionResponseCode.SUCCESS) {
                this.apRuntimeConfiguration.setFirmwareVersion(response.getFwVersion());
                this.daemonInfoHolder.setData(response.getSwVersion(), response.getDeviceType());
                if (this.systemAttributes.getId() == response.getAccessPointId().intValue() && 2 == response.getProtocolVersion()) {
                    WirelessConfiguration wiConfig = this.configurationManager.getWirelessConfiguration();
                    ThinAPConfiguration thinConfig = this.configurationManager.getThinAPConfiguration();
                    byte[] packetData = ConfigUpdateRequestPacket.create((String)ChannelUtils.channelToString(wiConfig.getChannel()), (String)wiConfig.getRadioOutputPowerLevel().name(), (String)thinConfig.getApcAddress(), (int)thinConfig.getApcPort());
                    source.submit(packetData, packetData.length);
                    this.configUpdate.setLastSentConfiguration(wiConfig, thinConfig);
                    logger.info("Got: %s, responding with: %s.", new Object[]{textPacket.getType().name(), ThinAPPacketIdentifier.CONFIG_UPDATE_REQUEST.name()});
                } else {
                    logger.error("Got: %s. Could not establish connection with SCD, closing channel. [AP-ID, PROTOCOL_VERSION] - expected: [%d, %d], got: [%d, %d].", new Object[]{textPacket.getType().name(), this.systemAttributes.getId(), (byte)2, response.getAccessPointId(), (byte)response.getProtocolVersion()});
                    source.submitClose();
                }
            } else {
                logger.error("Got: %s. With following response code - %s, closing channel.", new Object[]{textPacket.getType().name(), response.getResponseCode().getText()});
                source.submitClose();
            }
        } else {
            logger.error("Got: %s, which is unhandled in logic.", new Object[]{textPacket.getType().name()});
        }
    }

    public int getApId() {
        return this.systemAttributes.getId();
    }
}

