/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPChannel;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import java.io.IOException;

public abstract class BaseTCPChannelTask
implements ESLProcessingTask {
    private static final ESLLogger logger = ESLLogger.getLogger(BaseTCPChannelTask.class);
    protected final TCPCoreConfig tcpConfig;
    protected final TCPCore tcpCore;
    protected volatile String remoteAddress;
    protected final int remotePort;
    protected TCPCommunicationChannel communicationChannel;

    public BaseTCPChannelTask(TCPCoreConfig tcpConfig, TCPCore tcpCore, int remotePort, String remoteAddress) throws IOException {
        this.tcpConfig = tcpConfig;
        this.tcpCore = tcpCore;
        this.remotePort = remotePort;
        this.remoteAddress = remoteAddress;
        this.communicationChannel = null;
    }

    protected abstract void doIfConnected();

    protected abstract void setConnectionStateToOffline();

    protected abstract TCPEventStrategy createEventStrategy();

    protected abstract void initiatingConnectionWith(TCPCommunicationChannel var1);

    protected abstract TCPCommunicationChannel createTCPCommunicationChannel();

    public void run() throws Exception {
        if (this.communicationChannel != null) {
            if (this.communicationChannel.isClosed() || this.remoteAddress == null) {
                this.communicationChannel.shutdownOperation();
                this.communicationChannel = null;
                this.setConnectionStateToOffline();
            } else if (this.communicationChannel.isConnected()) {
                this.doIfConnected();
            }
        } else if (this.remoteAddress != null) {
            this.communicationChannel = this.createTCPCommunicationChannel();
            if (this.communicationChannel != null) {
                TCPEventStrategy tcpEventStrategy = this.createEventStrategy();
                if (this.communicationChannel.creationSuccessful()) {
                    this.tcpCore.register((TCPChannel)this.communicationChannel);
                    this.communicationChannel.setProtocolStrategy(tcpEventStrategy);
                    this.initiatingConnectionWith(this.communicationChannel);
                    this.communicationChannel.establishConnection(this.remoteAddress, this.remotePort, this.tcpCore);
                    logger.info("Initiated the connection to: [%s - %d]", new Object[]{this.remoteAddress, this.remotePort});
                } else {
                    this.communicationChannel.shutdownOperation();
                    this.communicationChannel = null;
                    this.setConnectionStateToOffline();
                }
            }
        }
    }
}

