/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.tcp;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveDataCommand;
import at.mrdevelopment.esl.accesspoint.tcp.CommandErrorType;
import at.mrdevelopment.esl.accesspoint.tcp.CommandProcessResult;
import java.util.LinkedList;
import java.util.UUID;

public class ActiveCommandLogicThinAP {
    private final LinkedList<ActiveDataCommand> activeDataCommands = new LinkedList();
    private ActiveDataCommand currentCommand = null;

    public void reset() {
        this.activeDataCommands.clear();
        this.currentCommand = null;
    }

    public void add(ActiveDataCommand dataCommand) {
        this.activeDataCommands.add(dataCommand);
    }

    public CommandProcessResult delayedProcess(SlotId slotId, TransmissionStatus transmissionStatus) {
        SlotId firstSlotId;
        UUID errorCommandId = null;
        CommandErrorType commandErrorType = CommandErrorType.NO_ERROR;
        ActiveDataCommand finishedCommand = null;
        if (transmissionStatus.isFinished() || transmissionStatus.isNoTransmission()) {
            finishedCommand = this.currentCommand;
            this.currentCommand = null;
            if (finishedCommand != null) {
                finishedCommand.countSlot();
            }
        }
        if (this.currentCommand != null) {
            this.currentCommand.countSlot();
        }
        if (this.activeDataCommands.size() > 0 && slotId.equals((firstSlotId = this.activeDataCommands.get(0).getSlotId()).next())) {
            if (this.currentCommand == null) {
                if (transmissionStatus == TransmissionStatus.RUNNING) {
                    this.currentCommand = this.activeDataCommands.remove();
                    if (this.currentCommand != null) {
                        this.currentCommand.countSlot();
                    }
                } else {
                    commandErrorType = CommandErrorType.NOT_STARTED;
                    errorCommandId = this.activeDataCommands.remove().getCommandId();
                }
            } else {
                commandErrorType = CommandErrorType.PIPELINE_HAZARD;
                errorCommandId = this.activeDataCommands.remove().getCommandId();
            }
        }
        return new CommandProcessResult(commandErrorType, errorCommandId, finishedCommand != null ? finishedCommand : this.currentCommand);
    }
}

