/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.LabelFeatures;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.taskqueue.DefaultUpdateTaskHolderFactory;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskHolderFactory;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskQueue;
import at.mrdevelopment.esl.updatetask.CommandUpdateTask;
import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class WaitingUpdateTasks {
    static ESLLogger logger = ESLLogger.getLogger(WaitingUpdateTasks.class);
    private final UpdateTaskQueue<DataUpdateTask, UpdateTaskHolderFactory<DataUpdateTask>> dataUpdateTasks;
    private final UpdateTaskQueue<CommandUpdateTask, UpdateTaskHolderFactory<CommandUpdateTask>> commandUpdateTasks;

    public WaitingUpdateTasks(int slotCount, InternalUpdateTaskCommit updateTaskCommit) {
        this.dataUpdateTasks = new UpdateTaskQueue(slotCount, new DefaultUpdateTaskHolderFactory(false), updateTaskCommit);
        this.commandUpdateTasks = new UpdateTaskQueue(slotCount, new DefaultUpdateTaskHolderFactory(true), updateTaskCommit);
    }

    public synchronized void addUpdateTask(int slotId, UpdateTask updateTask, LabelFeatures labelFeatures) {
        if (updateTask instanceof DataUpdateTask) {
            DataUpdateTask dataUpdateTask = (DataUpdateTask)updateTask;
            this.dataUpdateTasks.offer(slotId, dataUpdateTask, labelFeatures);
        } else if (updateTask instanceof CommandUpdateTask) {
            CommandUpdateTask commandUpdateTask = (CommandUpdateTask)updateTask;
            this.commandUpdateTasks.offer(slotId, commandUpdateTask, labelFeatures);
        } else {
            throw new AssertionError();
        }
    }

    public synchronized DataUpdateTask queryDataUpdateTask(SlotId slotId, TaskPriority priority, SyncProfile syncProfile) {
        for (int slotDivider = 0; slotDivider < 32; ++slotDivider) {
            int queueSlotId = (slotId.getId() + slotDivider * 32) % 1024;
            DataUpdateTask updateTask = this.dataUpdateTasks.poll(slotId.getId(), queueSlotId, priority, null, syncProfile);
            if (updateTask == null) continue;
            return updateTask;
        }
        return null;
    }

    public synchronized CommandUpdateTask queryCommandUpdateTask(SlotId slotId, TaskPriority priority, Address blockedLabelAddress, SyncProfile syncProfile) {
        for (int slotDivider = 0; slotDivider < 32; ++slotDivider) {
            int queueSlotId = (slotId.getId() + slotDivider * 32) % 1024;
            CommandUpdateTask updateTask = this.commandUpdateTasks.poll(slotId.getId(), queueSlotId, priority, blockedLabelAddress, syncProfile);
            if (updateTask == null) continue;
            return updateTask;
        }
        return null;
    }

    public synchronized int getDataUpdateTaskCount() {
        return this.dataUpdateTasks.getSize();
    }

    public synchronized int getCommandUpdateTaskCount() {
        return this.commandUpdateTasks.getSize();
    }

    public synchronized int getUpdateTaskCount() {
        return this.getDataUpdateTaskCount() + this.getCommandUpdateTaskCount();
    }
}

