/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.LabelFeatures;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotUpdateTaskHolder;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskHolderFactory;
import at.mrdevelopment.esl.updatetask.CommandUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.List;

public class UpdateTaskQueue<T extends UpdateTask, F extends UpdateTaskHolderFactory<T>> {
    static ESLLogger logger = ESLLogger.getLogger(UpdateTaskQueue.class);
    private List<SlotUpdateTaskHolder<T>> slotHolderList;
    private int numberOfElements = 0;
    T returnedUpdateTask;
    int numRemovedEntries;

    public UpdateTaskQueue(int slotCount, F taskHolderFactory, InternalUpdateTaskCommit updateTaskCommit) {
        this.slotHolderList = new ArrayList<SlotUpdateTaskHolder<T>>(slotCount);
        for (int slotId = 0; slotId < slotCount; ++slotId) {
            this.slotHolderList.add(slotId, taskHolderFactory.create(updateTaskCommit));
        }
    }

    public int getSize() {
        return this.numberOfElements;
    }

    public void offer(int slotId, T updateTask, LabelFeatures labelFeatures) {
        boolean selectOnData;
        boolean bl = selectOnData = updateTask instanceof CommandUpdateTask && labelFeatures.isCommandsOnDataSupported();
        if (this.slotHolderList.get(slotId).offer(updateTask, selectOnData)) {
            ++this.numberOfElements;
        }
    }

    public T poll(int slotId, int queueSlotId, TaskPriority priority, Address blockedAddress, SyncProfile syncProfile) {
        SlotUpdateTaskHolder<T> taskHolder = this.slotHolderList.get(queueSlotId);
        taskHolder.poll(slotId, priority.ordinal(), this, blockedAddress, syncProfile);
        this.numberOfElements -= this.numRemovedEntries;
        return this.returnedUpdateTask;
    }

    protected void setPollResults(T updateTask, int numRemovedEntries) {
        this.returnedUpdateTask = updateTask;
        this.numRemovedEntries = numRemovedEntries;
    }
}

