/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.FillSyncQueueCommandCreator;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingCommand;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingQueue;
import at.mrdevelopment.esl.accesspoint.ReinitializePipelineCommand;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.taskqueue.PipelinePlace;
import at.mrdevelopment.esl.accesspoint.taskqueue.ReplyQueueEntry;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SlotPipeline {
    private final int size;
    private final PipelinePlace[] syncQueue;
    private final Map<UUID, CommittedDataCommand<?>> dataCommands = new HashMap();
    public static final int REPLY_DISPLACEMENT = 2;
    private static final int SYNC_QUEUE_MULTIPLIER = 4;
    private Address blockedLabelAddress = null;
    private int blockedSlots = 0;
    private final PipelineProcessingQueue pipelineQueue;
    private ReplyQueueEntry[] replies;
    private ArrayList<SyncPacket> notForwardedSyncPackets;

    public SlotPipeline(int size) {
        this.size = size;
        this.syncQueue = new PipelinePlace[size * 4];
        for (int idx = 0; idx < this.syncQueue.length; ++idx) {
            this.syncQueue[idx] = new PipelinePlace();
        }
        this.replies = new ReplyQueueEntry[size];
        this.pipelineQueue = new PipelineProcessingQueue();
        this.notForwardedSyncPackets = new ArrayList(size * 2);
    }

    public int getSize() {
        return this.size;
    }

    public void add(SyncPacket newSync) {
        SlotId slotId = newSync.getSlotId();
        int queueSlot = this.getSyncQueueSlot(slotId.getId());
        this.syncQueue[queueSlot].replaceWith(newSync, this.notForwardedSyncPackets);
        if (newSync.getCommandType().isDataInit()) {
            CommittedDataCommand<?> dataCommand = newSync.getDataCommand();
            this.blockedSlots = dataCommand.getBlockedSlots(14);
            this.blockedLabelAddress = dataCommand.getAddress();
            this.dataCommands.put(dataCommand.getId(), dataCommand);
        }
        if (this.blockedSlots > 0) {
            --this.blockedSlots;
        } else {
            this.blockedLabelAddress = null;
        }
    }

    public List<PipelinePlace> getAllPipelinePlaces() {
        return Arrays.asList(this.syncQueue);
    }

    public SyncPacket getSyncForForwarding(SlotId slotId) {
        return this.syncQueue[this.getSyncQueueSlot(slotId.getId())].takeForForwarding();
    }

    public SyncPacket getSyncOnly(SlotId slotId) {
        return this.syncQueue[this.getSyncQueueSlot(slotId.getId())].getSyncOnly();
    }

    public void pretendAddReply(SlotId slotId, FillSyncQueueCommandCreator commandCreator) {
        this.checkAndSetIfRepliesReady(slotId.forReply(), commandCreator);
    }

    public void addReplies(ReplyQueueEntry entry, FillSyncQueueCommandCreator commandCreator) {
        this.replies[entry.getSlotId().getId() % this.replies.length] = entry;
        this.checkAndSetIfRepliesReady(entry.getSlotId(), commandCreator);
    }

    private void checkAndSetIfRepliesReady(SlotId slotId, FillSyncQueueCommandCreator commandCreator) {
        if ((slotId.getId() + 2 + 1) % this.size == 0) {
            this.putOnQueue(commandCreator.createFillSyncQueue(this.replies));
            this.replies = new ReplyQueueEntry[this.size];
        }
    }

    public void removeSync(SlotId slotId) {
        int syncQueueSlot = this.getSyncQueueSlot(slotId.getId());
        this.syncQueue[syncQueueSlot].clear();
    }

    public Address getBlockedLabelAddress() {
        return this.blockedLabelAddress;
    }

    public int getBlockedSlots() {
        return this.blockedSlots;
    }

    public CommittedDataCommand<?> getAndRemoveDataCommand(UUID commandId) {
        return this.dataCommands.remove(commandId);
    }

    public List<CommittedDataCommand<?>> getAndRemoveAllDataCommands() {
        LinkedList commandList = new LinkedList(this.dataCommands.values());
        this.dataCommands.clear();
        return commandList;
    }

    private int getSyncQueueSlot(int slotId) {
        return slotId % this.syncQueue.length;
    }

    public void clear() {
        this.replies = new ReplyQueueEntry[this.size];
        for (int index = 0; index < this.syncQueue.length; ++index) {
            this.syncQueue[index].clear();
        }
        this.blockedSlots = 0;
        this.dataCommands.clear();
        this.notForwardedSyncPackets.clear();
    }

    public PipelineProcessingCommand getCommand() {
        return this.pipelineQueue.getCommand();
    }

    public void breakGetCommand() {
        this.pipelineQueue.wakeGetCommand();
    }

    private void putOnQueue(PipelineProcessingCommand command) {
        this.pipelineQueue.putOnQueue(command);
    }

    public void putReinitializeOnQueue(SlotId slotId) {
        this.pipelineQueue.putOnQueue(new ReinitializePipelineCommand(slotId, this.replies));
    }

    public SyncPacket[] getAndRemoveNotForwarded() {
        SyncPacket[] packets = new SyncPacket[this.notForwardedSyncPackets.size()];
        this.notForwardedSyncPackets.toArray(packets);
        this.notForwardedSyncPackets.clear();
        return packets;
    }
}

