/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.tcp.CommandErrorType;
import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Reply;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ReplyQueueEntry {
    private final SlotId slotId;
    private final Reply[] replies;
    private final JoinRequest[] joinRequests;
    private final EventPacket[] events;
    private final boolean uartError;
    private final List<AccessPointProblem> problems;
    private final TransmissionStatus transmissionStatus;
    private final TransmissionInfo transmissionInfo;
    private final int transmissionSlots;
    private final UUID expectedCommandId;
    private final UUID errorCommandId;
    private final CommandErrorType errorType;

    public ReplyQueueEntry(SlotId slotId, TransmissionStatus transmissionStatus, TransmissionInfo transmissionInfo, int transmissionSlots, Reply[] replies, JoinRequest[] joinRequests, EventPacket[] events, boolean uartError, Collection<AccessPointProblem> problems, UUID expectedCommandId, CommandErrorType commandErrorType, UUID errorCommandId) {
        this.slotId = slotId;
        this.transmissionStatus = transmissionStatus;
        this.transmissionInfo = transmissionInfo;
        this.transmissionSlots = transmissionSlots;
        this.replies = replies;
        this.joinRequests = joinRequests;
        this.events = events;
        this.uartError = uartError;
        this.problems = Lists.newArrayList(problems);
        this.expectedCommandId = expectedCommandId;
        this.errorType = commandErrorType == null ? CommandErrorType.NO_ERROR : commandErrorType;
        this.errorCommandId = errorCommandId;
    }

    public ReplyQueueEntry(SlotId slotId, TransmissionStatus transmissionStatus, TransmissionInfo transmissionInfo, int transmissionSlots, Reply[] replies, JoinRequest[] joinRequests, EventPacket[] events, boolean uartError, Collection<AccessPointProblem> problems, UUID expectedCommandId, UUID errCommandId) {
        this(slotId, transmissionStatus, transmissionInfo, transmissionSlots, replies, joinRequests, events, uartError, problems, expectedCommandId, errCommandId != null ? CommandErrorType.PIPELINE_HAZARD : CommandErrorType.NO_ERROR, errCommandId);
    }

    public SlotId getSlotId() {
        return this.slotId;
    }

    public TransmissionStatus getTransmissionStatus() {
        return this.transmissionStatus;
    }

    public TransmissionInfo getTransmissionInfo() {
        return this.transmissionInfo;
    }

    public int getTransmissionSlots() {
        return this.transmissionSlots;
    }

    public Reply getReply(int replySlot) {
        return this.replies[replySlot];
    }

    public int getReplyCount() {
        return this.countNonNull(this.replies);
    }

    public JoinRequest getJoinRequest(int joinSlot) {
        return this.joinRequests[joinSlot];
    }

    public int getJoinRequestCount() {
        return this.countNonNull(this.joinRequests);
    }

    public EventPacket getEvent(int eventSlot) {
        return this.events[eventSlot];
    }

    public int getEventCount() {
        return this.countNonNull(this.events);
    }

    public boolean hasUartError() {
        return this.uartError;
    }

    public Collection<AccessPointProblem> getProblems() {
        return Collections.unmodifiableCollection(this.problems);
    }

    public UUID getExpectedCommandId() {
        return this.expectedCommandId;
    }

    public UUID getErrorCommandId() {
        return this.errorCommandId;
    }

    public boolean isErrorCommandSet() {
        return this.errorType.isError();
    }

    public UpdateError getUpdateError() {
        return this.errorType.getUpdateError();
    }

    public CommandErrorType getErrorType() {
        return this.errorType;
    }

    public boolean isPipelineHazard() {
        return this.errorType == CommandErrorType.PIPELINE_HAZARD;
    }

    private int countNonNull(Object[] array) {
        int count = 0;
        for (Object object : array) {
            if (object == null) continue;
            ++count;
        }
        return count;
    }
}

