/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.toolkit.Shutdownable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;

public class ImpreciseDateTimeProvider
implements Shutdownable,
Runnable {
    private static final Lock lock = new ReentrantLock();
    private static ImpreciseDateTimeProvider INSTANCE = null;
    private int startIdx = 1;
    private int multiplicity;
    private ArrayList<AtomicReference<DateTime>> currentTime;
    private volatile boolean shutdownRequested = false;

    private ImpreciseDateTimeProvider(int multiplicity) {
        this.multiplicity = multiplicity;
        this.currentTime = new ArrayList(multiplicity);
        DateTime now = DateTime.now();
        for (int idx = 0; idx < multiplicity; ++idx) {
            this.currentTime.add(new AtomicReference<DateTime>(now));
        }
    }

    private void startProcessingThread() {
        Thread thread = new Thread(this);
        thread.setName("ImpreciseDateTimeProviderThread");
        thread.start();
    }

    public void shutdown() {
        this.shutdownRequested = true;
    }

    @Override
    public void run() {
        do {
            DateTime temp = DateTime.now();
            for (int idx = 0; idx < this.multiplicity; ++idx) {
                this.currentTime.get(idx).set(temp);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.shutdownRequested);
    }

    public static DateTime get(int idx) {
        return ImpreciseDateTimeProvider.INSTANCE.currentTime.get(idx).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int acquireIdx() {
        int retIdx = 0;
        lock.lock();
        try {
            if (ImpreciseDateTimeProvider.INSTANCE.startIdx % ImpreciseDateTimeProvider.INSTANCE.multiplicity == 0) {
                ImpreciseDateTimeProvider.INSTANCE.startIdx = 0;
            }
            retIdx = ImpreciseDateTimeProvider.INSTANCE.startIdx++;
        }
        finally {
            lock.unlock();
        }
        return retIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndStart(int multiplicity) {
        block4: {
            lock.lock();
            try {
                if (INSTANCE == null) {
                    INSTANCE = new ImpreciseDateTimeProvider(multiplicity < 0 ? 1 : multiplicity);
                    INSTANCE.startProcessingThread();
                    break block4;
                }
                throw new RuntimeException("ImpreciseDateTimeProvider already exists!");
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static ImpreciseDateTimeProvider getInstance() {
        if (INSTANCE == null) {
            throw new RuntimeException("Please createAndStart(...) ImpreciseDateTimeProvider first!");
        }
        return INSTANCE;
    }
}

