/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.taskqueue.BaseUpdateTaskHolder;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotUpdateTaskHolder;
import at.mrdevelopment.esl.accesspoint.taskqueue.TaskEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskQueue;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;
import gnu.trove.list.linked.TLinkedList;
import java.util.Arrays;

public class DataUpdateTaskHolder<T extends UpdateTask>
extends BaseUpdateTaskHolder<T>
implements SlotUpdateTaskHolder<T> {
    static ESLLogger logger = ESLLogger.getLogger(DataUpdateTaskHolder.class);
    private static final int[] PRIORITY_MAPPING = new int[TaskPriority.values().length];

    protected DataUpdateTaskHolder() {
        super(3);
    }

    @Override
    public boolean offer(T newTask, boolean selectOnData) {
        ((TLinkedList)this.updateTaskLists.get(PRIORITY_MAPPING[newTask.getPriority().ordinal()])).add(new TaskEntry<T>(newTask, selectOnData));
        return true;
    }

    @Override
    public void poll(int slotId, int priorityOrdinal, UpdateTaskQueue<T, ?> updateTaskQueue, Address blockedAddress, SyncProfile syncProfile) {
        this.listIterator.init((TLinkedList)this.updateTaskLists.get(PRIORITY_MAPPING[priorityOrdinal]));
        this.innerPoll(slotId, updateTaskQueue, blockedAddress, syncProfile);
    }

    static {
        Arrays.fill(PRIORITY_MAPPING, -2);
        DataUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.PING.ordinal()] = -1;
        DataUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.JOIN.ordinal()] = -1;
        DataUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.HIGH.ordinal()] = 0;
        DataUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.NORMAL.ordinal()] = 1;
        DataUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.LOW.ordinal()] = 2;
        for (int idx = 0; idx < PRIORITY_MAPPING.length; ++idx) {
            if (PRIORITY_MAPPING[idx] != -2) continue;
            throw new IllegalStateException(String.format("TaskPriority has been added/removed but the priority mapping has not been updated in %s!", DataUpdateTaskHolder.class.getName()));
        }
    }
}

