/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.taskqueue.BaseUpdateTaskHolder;
import at.mrdevelopment.esl.accesspoint.taskqueue.ImpreciseDateTimeProvider;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotUpdateTaskHolder;
import at.mrdevelopment.esl.accesspoint.taskqueue.TaskEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskQueue;
import at.mrdevelopment.esl.updatetask.JoinUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.esl.wireless.WakeupProfile;
import at.mrdevelopment.esl.wireless.WakeupProfileMapping;
import at.mrdevelopment.toolkit.log.ESLLogger;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.linked.TLinkedList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;
import org.joda.time.DateTime;

public class CommandUpdateTaskHolder<T extends UpdateTask>
extends BaseUpdateTaskHolder<T>
implements SlotUpdateTaskHolder<T> {
    static ESLLogger logger = ESLLogger.getLogger(CommandUpdateTaskHolder.class);
    private static final int[] PRIORITY_MAPPING = new int[TaskPriority.values().length];
    private static final int JOIN_IDX = -1;
    private TLongObjectHashMap<TaskEntry<T>> mapping = new TLongObjectHashMap(9);
    private InternalUpdateTaskCommit updateTaskCommit;
    private final int dateTimeProviderIdx;

    public CommandUpdateTaskHolder(InternalUpdateTaskCommit internalUpdateTaskCommit) {
        super(4);
        this.updateTaskCommit = internalUpdateTaskCommit;
        this.dateTimeProviderIdx = ImpreciseDateTimeProvider.acquireIdx();
    }

    @Override
    public boolean offer(T newTask, boolean selectOnData) {
        if (newTask.getPriority() == TaskPriority.JOIN) {
            TaskEntry oldEntry = (TaskEntry)((Object)this.mapping.put(newTask.getAddress().getHardwareAddress(), new TaskEntry<T>(newTask, selectOnData)));
            return oldEntry == null;
        }
        ((TLinkedList)this.updateTaskLists.get(PRIORITY_MAPPING[newTask.getPriority().ordinal()])).add(new TaskEntry<T>(newTask, selectOnData));
        return true;
    }

    @Override
    public void poll(int slotId, int priorityOrdinal, UpdateTaskQueue<T, ?> updateTaskQueue, Address blockedAddress, SyncProfile syncProfile) {
        int listIdx = PRIORITY_MAPPING[priorityOrdinal];
        if (listIdx == -1) {
            int numRemovedEntries = 0;
            Object polledTask = null;
            DateTime now = ImpreciseDateTimeProvider.get(this.dateTimeProviderIdx);
            TLongObjectIterator iterator = this.mapping.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                TaskEntry entry = (TaskEntry)((Object)iterator.value());
                if (((JoinUpdateTask)entry.getUpdateTask()).getCreationTime().plusSeconds(150).isBeforeNow()) {
                    iterator.remove();
                    ++numRemovedEntries;
                    this.updateTaskCommit.joinFailed(((JoinUpdateTask)entry.getUpdateTask()).getAddress(), now);
                    continue;
                }
                if (blockedAddress != null && !entry.isSelectOnData()) continue;
                Object updateTask = entry.getUpdateTask();
                Address address = updateTask.getAddress();
                WakeupProfile realWakeupProfile = WakeupProfileMapping.forAddress((Address)address, (SyncProfile)syncProfile);
                int maskedSlotId = (int)((long)slotId & realWakeupProfile.getMask());
                int labelWakeupSlot = address.getWakeupSlot(realWakeupProfile);
                if (address.equals((Object)blockedAddress) || labelWakeupSlot != maskedSlotId) continue;
                logger.info("Selecting task address=%s slotId=%s, labelWakeupSlot=%s", new Object[]{address, slotId, labelWakeupSlot});
                iterator.remove();
                ++numRemovedEntries;
                polledTask = updateTask;
                break;
            }
            if (numRemovedEntries > 1) {
                logger.info(String.format("Removed %d JoinUpdateTasks that were late.", numRemovedEntries - 1));
            }
            updateTaskQueue.setPollResults(polledTask, numRemovedEntries);
        } else {
            this.listIterator.init((TLinkedList)this.updateTaskLists.get(listIdx));
            this.innerPoll(slotId, updateTaskQueue, blockedAddress, syncProfile);
        }
    }

    static {
        Arrays.fill(PRIORITY_MAPPING, -2);
        CommandUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.JOIN.ordinal()] = -1;
        CommandUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.HIGH.ordinal()] = 0;
        CommandUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.NORMAL.ordinal()] = 1;
        CommandUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.LOW.ordinal()] = 2;
        CommandUpdateTaskHolder.PRIORITY_MAPPING[TaskPriority.PING.ordinal()] = 3;
        for (int idx = 0; idx < PRIORITY_MAPPING.length; ++idx) {
            if (PRIORITY_MAPPING[idx] != -2) continue;
            throw new IllegalStateException(String.format("TaskPriority has been added/removed but the priority mapping has not been updated in %s!", CommandUpdateTaskHolder.class.getName()));
        }
    }
}

