/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.taskqueue.TaskEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.UpdateTaskQueue;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.esl.wireless.WakeupProfile;
import at.mrdevelopment.esl.wireless.WakeupProfileMapping;
import at.mrdevelopment.toolkit.log.ESLLogger;
import gnu.trove.list.linked.ModifiedTroveIteratorImpl;
import gnu.trove.list.linked.TLinkedList;
import java.util.ArrayList;

public abstract class BaseUpdateTaskHolder<T extends UpdateTask> {
    static ESLLogger logger = ESLLogger.getLogger(BaseUpdateTaskHolder.class);
    protected final ModifiedTroveIteratorImpl<TaskEntry<T>> listIterator = new ModifiedTroveIteratorImpl();
    protected final ArrayList<TLinkedList<TaskEntry<T>>> updateTaskLists;

    protected BaseUpdateTaskHolder(int listCount) {
        this.updateTaskLists = new ArrayList(listCount);
        for (int idx = 0; idx < listCount; ++idx) {
            this.updateTaskLists.add(new TLinkedList());
        }
    }

    void innerPoll(int slotId, UpdateTaskQueue<T, ?> updateTaskQueue, Address blockedAddress, SyncProfile syncProfile) {
        int numRemovedEntries = 0;
        Object polledTask = null;
        while (this.listIterator.hasNext()) {
            TaskEntry entry = (TaskEntry)this.listIterator.next();
            if (blockedAddress != null && !entry.isSelectOnData()) continue;
            Object updateTask = entry.getUpdateTask();
            Address address = updateTask.getAddress();
            WakeupProfile realWakeupProfile = WakeupProfileMapping.forAddress((Address)address, (SyncProfile)syncProfile);
            int maskedSlotId = (int)((long)slotId & realWakeupProfile.getMask());
            int labelWakeupSlot = address.getWakeupSlot(realWakeupProfile);
            if (address.equals((Object)blockedAddress) || labelWakeupSlot != maskedSlotId) continue;
            logger.info("Selecting task address=%s slotId=%s, labelWakeupSlot=%s", new Object[]{address, slotId, labelWakeupSlot});
            this.listIterator.remove();
            ++numRemovedEntries;
            polledTask = updateTask;
            break;
        }
        updateTaskQueue.setPollResults(polledTask, numRemovedEntries);
    }
}

