/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.command.DataCommand;
import at.mrdevelopment.esl.wireless.Address;
import java.util.UUID;

public class ActiveDataCommand {
    public static ActiveDataCommand EMPTY = new ActiveDataCommand();
    private final SlotId slotId;
    private final DataCommand dataCommand;
    private int blockedSlots;
    private int transmissionSlots;

    private ActiveDataCommand() {
        this.dataCommand = null;
        this.slotId = null;
        this.blockedSlots = 0;
        this.transmissionSlots = 0;
    }

    public ActiveDataCommand(DataCommand dataCommand) {
        this.dataCommand = dataCommand;
        this.slotId = null;
        this.transmissionSlots = 0;
    }

    public ActiveDataCommand(DataCommand dataCommand, SlotId slotId) {
        this.dataCommand = dataCommand;
        this.slotId = slotId;
        this.transmissionSlots = 0;
    }

    public boolean isEmpty() {
        return this.dataCommand == null;
    }

    public SlotId getSlotId() {
        return this.slotId;
    }

    public DataCommand getDataCommand() {
        return this.dataCommand;
    }

    public int getTransmissionSlots() {
        return this.dataCommand != null ? this.transmissionSlots : 0;
    }

    public void countSlot() {
        if (this.blockedSlots > 0) {
            --this.blockedSlots;
        }
        if (this.dataCommand != null) {
            ++this.transmissionSlots;
        }
    }

    public Address getAddress() {
        return this.dataCommand != null ? this.dataCommand.getAddress() : null;
    }

    public UUID getCommandId() {
        return this.dataCommand != null ? this.dataCommand.getId() : null;
    }
}

