/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.taskqueue;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveCommandLogicResult;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveDataCommand;
import java.util.UUID;

public class ActiveCommandLogic {
    private UUID pipelineHazardCommandId = null;
    private ActiveDataCommand currentCommand = ActiveDataCommand.EMPTY;

    public ReplyProcessResult addRepliesProcess(TransmissionStatus transmissionStatus) {
        TransmissionStatus newTransmissionStatus = transmissionStatus;
        this.currentCommand.countSlot();
        if (this.currentCommand.isEmpty() && !newTransmissionStatus.isNoTransmission()) {
            newTransmissionStatus = TransmissionStatus.NO_TRANSMISSION;
        }
        ReplyProcessResult result = new ReplyProcessResult(newTransmissionStatus, this.currentCommand, this.pipelineHazardCommandId);
        if (newTransmissionStatus.isFinished() || newTransmissionStatus.isNoTransmission()) {
            this.currentCommand = ActiveDataCommand.EMPTY;
        }
        this.pipelineHazardCommandId = null;
        return result;
    }

    public ActiveCommandLogicResult getSyncProcess(SlotId slotId, SyncPacket newSync) {
        boolean newSyncRequired = false;
        if (newSync.getCommandType().isDataInit()) {
            CommittedDataCommand<?> dataCommand = newSync.getDataCommand();
            if (!this.currentCommand.isEmpty()) {
                this.pipelineHazardCommandId = dataCommand.getId();
                newSyncRequired = true;
            } else {
                this.currentCommand = new ActiveDataCommand(dataCommand);
            }
        }
        return new ActiveCommandLogicResult(this.currentCommand, newSyncRequired);
    }

    public ActiveDataCommand getCurrentCommand() {
        return this.currentCommand;
    }

    public class ReplyProcessResult {
        private TransmissionStatus status;
        private UUID pipelineHazardCommandId;
        private ActiveDataCommand activeDataCommand;

        public ReplyProcessResult(TransmissionStatus status, ActiveDataCommand activeDataCommand, UUID pipelineHazardCommandId) {
            this.status = status;
            this.pipelineHazardCommandId = pipelineHazardCommandId;
            this.activeDataCommand = activeDataCommand;
        }

        public TransmissionStatus getStatus() {
            return this.status;
        }

        public void setTransmissionStatus(TransmissionStatus status) {
            this.status = status;
        }

        public UUID getPipelineHazardCommandId() {
            return this.pipelineHazardCommandId;
        }

        public ActiveDataCommand getActiveDataCommand() {
            return this.activeDataCommand;
        }
    }
}

