/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameQueue;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelOutputFrame;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.OutputStream;

public class UartWriter
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(UartWriter.class);
    private final OutputStream outputStream;
    private final FrameQueue frameQueue;
    private volatile boolean shutdownRequested;

    public UartWriter(OutputStream outputStream, FrameQueue frameQueue) {
        super("UartWriter");
        this.outputStream = outputStream;
        this.frameQueue = frameQueue;
    }

    @Override
    public void run() {
        while (!this.shutdownRequested) {
            try {
                UartLowlevelOutputFrame frame = this.frameQueue.getFrame();
                frame.write(this.outputStream);
            }
            catch (InterruptedException exc) {
                logger.info("Interrupting UartWriter");
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
            }
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
    }
}

