/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameException;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandler;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandlerWiSpy;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrameWiSpy;
import at.mrdevelopment.esl.accesspoint.serial.UartReader;
import at.mrdevelopment.toolkit.Shutdownable;
import java.io.InputStream;

public class UartReaderWiSpy
extends UartReader
implements Shutdownable {
    private final InputStream inputStream;
    private final SerialEventHandlerWiSpy eventHandler;
    private volatile boolean shutdownRequested;

    public UartReaderWiSpy(InputStream inputStream, SerialEventHandlerWiSpy serialEventHandlerWiSpy) {
        super(null, (SerialEventHandler)null);
        this.inputStream = inputStream;
        this.eventHandler = serialEventHandlerWiSpy;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[512];
        while (!this.shutdownRequested) {
            try {
                UartLowlevelFrame frame = UartLowlevelFrameWiSpy.loadFrame(this.inputStream, buffer);
                this.eventHandler.processFrame(frame);
            }
            catch (FrameException exc) {
                logger.info("Frame error: %s", new Object[]{exc.getMessage()});
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
    }
}

