/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameException;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandler;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.InputStream;

public class UartReader
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(UartReader.class);
    private final InputStream inputStream;
    private final SerialEventHandler eventHandler;
    private volatile boolean shutdownRequested;

    public UartReader(InputStream inputStream, SerialEventHandler eventHandler) {
        super("UartReader");
        this.inputStream = inputStream;
        this.eventHandler = eventHandler;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[512];
        while (!this.shutdownRequested) {
            try {
                UartLowlevelFrame frame = UartLowlevelFrame.loadFrame(this.inputStream, buffer);
                this.eventHandler.processFrame(frame);
            }
            catch (FrameException exc) {
                logger.info("Frame error: %s", new Object[]{exc.getMessage()});
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
            }
            catch (Throwable thr) {
                logger.logException(thr);
            }
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
    }
}

