/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.toolkit.checksum.CRC16;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.io.OutputStream;

public class UartLowlevelOutputFrame {
    static ESLLogger logger = ESLLogger.getLogger(UartLowlevelOutputFrame.class);
    private static final int CRC_BYTES = 2;
    private final byte[] data;
    private final boolean writeAdditionalData;

    public UartLowlevelOutputFrame(byte[] data) {
        this.data = data;
        this.writeAdditionalData = true;
    }

    public UartLowlevelOutputFrame(byte[] data, boolean writeAdditionalData) {
        this.data = data;
        this.writeAdditionalData = writeAdditionalData;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.writeAdditionalData) {
            int length = this.data.length + 2;
            CRC16 crc16 = new CRC16();
            crc16.calc(length);
            for (byte dataByte : this.data) {
                crc16.calc((int)dataByte);
            }
            int checksum = crc16.getChecksum();
            if (logger.isDebugEnabled()) {
                if (this.data.length > 0) {
                    logger.debug("Send: length = %03d, header = %02X, checksum = %04X", new Object[]{length, this.data[0], checksum});
                } else {
                    logger.debug("Send: length = %03d, checksum = %04X", new Object[]{length, checksum});
                }
            }
            outputStream.write(length);
            outputStream.write(this.data, 0, this.data.length);
            outputStream.write(checksum >> 8);
            outputStream.write(checksum);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Send: length = %03d, header = %02X.", new Object[]{this.data.length, this.data[1]});
            }
            outputStream.write(this.data, 0, this.data.length);
        }
        outputStream.flush();
    }
}

