/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameException;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.toolkit.checksum.CRC16;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UartLowlevelFrameWiSpy
extends UartLowlevelFrame {
    public static UartLowlevelFrame loadFrame(InputStream inputStream, byte[] buffer) throws IOException, FrameException {
        int length = inputStream.read();
        int dataLength = length - 2;
        int totalLength = length + 1;
        int bytesAvailable = inputStream.available();
        if (bytesAvailable > 74 && logger.isDebugEnabled()) {
            logger.debug("Missed slot request (%d waiting bytes from transmitter)", new Object[]{bytesAvailable});
        }
        if (dataLength <= 1) {
            throw new FrameException("Invalid frame size");
        }
        int header = inputStream.read();
        buffer[0] = (byte)length;
        buffer[1] = (byte)header;
        int totalBytesRead = 2;
        while (totalBytesRead < totalLength) {
            int bytesRead = inputStream.read(buffer, totalBytesRead, totalLength - totalBytesRead);
            if (bytesRead <= 0) continue;
            totalBytesRead += bytesRead;
        }
        CRC16 crc16 = new CRC16();
        for (int index = 0; index < totalLength; ++index) {
            crc16.calc((int)buffer[index]);
        }
        int checksum = crc16.getChecksum();
        if (checksum != 0) {
            throw new FrameException("Checksum error");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Recv: length = %03d, header = %02X, checksum = %04X", new Object[]{length, header, checksum});
        }
        if ((header & 0xF0) != 160) {
            throw new FrameException("Invalid frame header");
        }
        if (header == 170) {
            return new UartLowlevelFrameWiSpy(new ByteArrayInputStream(buffer, 1, dataLength));
        }
        if (header == 171) {
            return new UartLowlevelFrameWiSpy(new ByteArrayInputStream(buffer, 1, dataLength));
        }
        if (header == 172) {
            return new UartLowlevelFrameWiSpy(new ByteArrayInputStream(buffer, 1, dataLength));
        }
        return new UartLowlevelFrame(new ByteArrayInputStream(buffer, 1, dataLength));
    }

    private UartLowlevelFrameWiSpy(ByteArrayInputStream stream) throws FrameException {
        super(stream);
    }
}

